/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.DefaultServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.DeprecationUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchGenerator;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import javax.annotation.Nonnull;
import lombok.Generated;

class DefaultServiceBatchGenerator {
    private static final String SERVICE_FIELD_NAME = "service";
    private static final String SERVICE_PATH_FIELD_NAME = "servicePath";
    private static final String THIS = "this";
    private final JCodeModel codeModel;

    ClassStub createDefaultImplementation(JClassContainer targetPackage, JDefinedClass basicServiceClass, ServiceBatchGenerator.InterfaceStub batchServiceStub, ServiceBatchChangeSetGenerator.InterfaceStub changeSetStub, Service service) throws JClassAlreadyExistsException {
        JDefinedClass interfaceToImplement = batchServiceStub.getServiceBatchStub();
        JDefinedClass changeSetInterface = changeSetStub.getServiceBatchChangeSetStub();
        JDefinedClass defaultImplementation = this.createClassHeader(targetPackage, interfaceToImplement, changeSetInterface, this.unimport((JClass)basicServiceClass));
        this.createBasicServiceField(defaultImplementation, this.unimport((JClass)basicServiceClass), service);
        this.createBasicServicePathField(defaultImplementation);
        this.createConstructor(defaultImplementation, this.unimport((JClass)basicServiceClass), service);
        this.implementGetServicePathForBatchRequestMethod(defaultImplementation);
        this.implementGetThisMethod(defaultImplementation);
        return new ClassStub(defaultImplementation);
    }

    @Nonnull
    private JClass unimport(@Nonnull JClass cl) {
        return this.codeModel.directClass(cl.fullName());
    }

    private void implementGetThisMethod(JDefinedClass defaultImplementation) {
        JMethod createdMethod = defaultImplementation.method(2, (JType)defaultImplementation, "getThis");
        createdMethod.annotate(Nonnull.class);
        createdMethod.annotate(Override.class);
        createdMethod.body()._return(JExpr._this());
    }

    private void implementGetServicePathForBatchRequestMethod(JDefinedClass defaultImplementation) {
        JMethod method = defaultImplementation.method(2, String.class, "getServicePathForBatchRequest");
        method.annotate(Nonnull.class);
        method.annotate(Override.class);
        method.body()._return((JExpression)JExpr.ref((String)SERVICE_PATH_FIELD_NAME));
    }

    private void implementBeginChangeSetMethod(JDefinedClass defaultImplementation, JDefinedClass changeSetInterface, JDefinedClass changeSetImplementation) {
        JMethod createdMethod = defaultImplementation.method(1, (JType)changeSetInterface, "beginChangeSet");
        createdMethod.annotate(Nonnull.class);
        createdMethod.annotate(Override.class);
        createdMethod.body()._return((JExpression)JExpr._new((JClass)changeSetImplementation).arg(JExpr._this()).arg((JExpression)JExpr.ref((String)SERVICE_FIELD_NAME)));
    }

    private JDefinedClass createClassHeader(JClassContainer targetPackage, JDefinedClass interfaceToImplement, JDefinedClass changeSetInterface, JClass basicServiceClass) throws JClassAlreadyExistsException {
        JDefinedClass defaultImplementation = targetPackage._class(1, this.createClassName(interfaceToImplement));
        defaultImplementation._extends(this.codeModel.ref(BatchFluentHelperBasic.class).narrow(new JClass[]{interfaceToImplement, changeSetInterface}));
        defaultImplementation._implements((JClass)interfaceToImplement);
        defaultImplementation.javadoc().add((Object)String.format("Default implementation of the {@link %s} interface exposed in the {@link %s %s}, allowing you to create multiple changesets and finally execute the batch request.", interfaceToImplement.name(), basicServiceClass.fullName(), basicServiceClass.name()));
        return defaultImplementation;
    }

    private void createBasicServiceField(JDefinedClass defaultImplementation, JClass basicServiceClass, Service service) {
        DeprecationUtils.createBasicServiceInterfaceField(defaultImplementation, basicServiceClass, SERVICE_FIELD_NAME, service);
    }

    private void createBasicServicePathField(JDefinedClass defaultImplementation) {
        JFieldVar serviceField = defaultImplementation.field(12, String.class, SERVICE_PATH_FIELD_NAME);
        serviceField.annotate(Nonnull.class);
    }

    private void createConstructor(JDefinedClass defaultImplementation, JClass basicServiceClass, Service service) {
        this.createConstructorForSupportedService(defaultImplementation, basicServiceClass);
        if (service.isDeprecated()) {
            defaultImplementation.constructors().forEachRemaining(c -> c.annotate(SuppressWarnings.class).param("value", "deprecation"));
        }
    }

    private void createConstructorForSupportedService(JDefinedClass defaultImplementation, JClass basicServiceClass) {
        JMethod constructor = defaultImplementation.constructor(1);
        JVar param = constructor.param(8, (JType)basicServiceClass, SERVICE_FIELD_NAME);
        param.annotate(Nonnull.class);
        constructor.body().invoke(THIS).arg((JExpression)param).arg((JExpression)basicServiceClass.staticRef("DEFAULT_SERVICE_PATH"));
        constructor.javadoc().add((Object)String.format("Creates a new instance of this %s.", defaultImplementation.name()));
        constructor.javadoc().addParam(param).add((Object)"The service to execute all operations in this changeset on.");
        constructor = defaultImplementation.constructor(1);
        JVar param1 = constructor.param(8, (JType)basicServiceClass, SERVICE_FIELD_NAME);
        param1.annotate(Nonnull.class);
        JVar param2 = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        param2.annotate(Nonnull.class);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)SERVICE_FIELD_NAME), (JExpression)param1);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)SERVICE_PATH_FIELD_NAME), (JExpression)param2);
        constructor.javadoc().add((Object)String.format("Creates a new instance of this %s.", defaultImplementation.name()));
        constructor.javadoc().addParam(param1).add((Object)"The service to execute all operations in this changeset on.");
        constructor.javadoc().addParam(param2).add((Object)"The custom service path to operate on.");
    }

    private String createClassName(JDefinedClass interfaceName) {
        return "Default" + interfaceName.name();
    }

    @Generated
    DefaultServiceBatchGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    final class ClassStub {
        private final JDefinedClass defaultServiceBatchStub;

        void implementBeginChangeSetMethod(ServiceBatchChangeSetGenerator.InterfaceStub changeSetStub, DefaultServiceBatchChangeSetGenerator.ClassStub implementationStub) {
            DefaultServiceBatchGenerator.this.implementBeginChangeSetMethod(this.defaultServiceBatchStub, changeSetStub.getServiceBatchChangeSetStub(), implementationStub.getDefaultBatchChangeSetStub());
        }

        @Generated
        private ClassStub(JDefinedClass defaultServiceBatchStub) {
            this.defaultServiceBatchStub = defaultServiceBatchStub;
        }

        @Generated
        JDefinedClass getDefaultServiceBatchStub() {
            return this.defaultServiceBatchStub;
        }
    }
}

