/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.datamodel.metadata.generator.ApiUsageMetadata;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataGenerator;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataInput;
import com.sap.cloud.sdk.datamodel.metadata.generator.JavaServiceMethodResolver;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenCoordinate;
import com.sap.cloud.sdk.datamodel.metadata.generator.ODataApiUsageMetadata;
import com.sap.cloud.sdk.datamodel.metadata.generator.ProtocolSpecificMetadata;
import com.sap.cloud.sdk.datamodel.odata.generator.EdmxFile;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceClassGenerator;
import io.vavr.control.Option;
import java.net.URI;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;

class DatamodelMetadataGeneratorAdapter {
    private final Logger logger;
    private static final URI MAVEN_MODULE_REPOSITORY_LINK = URI.create("https://mvnrepository.com/artifact/com.sap.cloud.sdk.datamodel/odata-generator");
    private static final MavenCoordinate GENERATOR_MAVEN_COORDINATE = MavenCoordinate.builder().artifactId("odata-generator").groupId("com.sap.cloud.sdk.datamodel").build();

    void generateMetadataIfApplicable(@Nonnull Path inputDir, @Nonnull Path outputDir, @Nonnull Collection<EdmxFile> edmxFiles, @Nonnull ServiceClassGenerator serviceClassGenerator) {
        DatamodelMetadataGenerator datamodelMetadataGenerator = new DatamodelMetadataGenerator(inputDir);
        if (!datamodelMetadataGenerator.isMetadataGenerationEnabled()) {
            return;
        }
        List<EdmxFile> edmxFilesForMetadataGeneration = edmxFiles.stream().filter(EdmxFile::isSuccessfullyParsed).collect(Collectors.toList());
        List<DatamodelMetadataInput> datamodelMetadataInputList = this.getDatamodelMetadata(edmxFilesForMetadataGeneration, serviceClassGenerator, outputDir);
        try {
            this.logger.info("Calling metadata generation using input directory: " + String.valueOf(inputDir.toAbsolutePath()));
            datamodelMetadataGenerator.generate(datamodelMetadataInputList, outputDir);
        }
        catch (Exception e) {
            throw new ODataGeneratorException("Failed during datamodel metadata generation", e);
        }
    }

    private List<DatamodelMetadataInput> getDatamodelMetadata(@Nonnull Collection<EdmxFile> edmxFiles, @Nonnull ServiceClassGenerator serviceClassGenerator, @Nonnull Path outputDir) {
        String description = "The Virtual Data Model for OData V2 Services";
        ZonedDateTime currentTime = ZonedDateTime.now();
        return edmxFiles.stream().map(edmxFile -> DatamodelMetadataInput.builder().codeGenerationSuccessful(edmxFile.isSuccessfullyGenerated()).apiSpecFilePath(edmxFile.getFilePath()).description("The Virtual Data Model for OData V2 Services").generatorMavenCoordinate(GENERATOR_MAVEN_COORDINATE).generatorRepositoryLink(MAVEN_MODULE_REPOSITORY_LINK).generationTime(currentTime).protocolSpecificMetadata(ProtocolSpecificMetadata.ofODataV2((ODataApiUsageMetadata)this.getODataV2ApiUsageMetadata(serviceClassGenerator, (EdmxFile)edmxFile, outputDir))).build()).collect(Collectors.toList());
    }

    private ODataApiUsageMetadata getODataV2ApiUsageMetadata(ServiceClassGenerator serviceClassGenerator, EdmxFile edmxFile, @Nonnull Path outputDir) {
        return edmxFile.isSuccessfullyGenerated() ? (ODataApiUsageMetadata)edmxFile.getService().flatMap(service -> this.getApiUsageMetadata((Service)service, serviceClassGenerator, outputDir)).getOrNull() : null;
    }

    private Option<ODataApiUsageMetadata> getApiUsageMetadata(@Nonnull Service service, @Nonnull ServiceClassGenerator serviceClassGenerator, @Nonnull Path outputDir) {
        Option<String> serviceClass = serviceClassGenerator.getQualifiedServiceImplementationClassName(service.getName());
        if (serviceClass.isEmpty()) {
            this.logger.info("No service implementation class name found for OData V2 service {}.", (Object)service.getName());
            return Option.none();
        }
        Option<String> serviceInterface = serviceClassGenerator.getQualifiedServiceInterfaceName(service.getName());
        if (serviceInterface.isEmpty()) {
            this.logger.info("No service interface name found for OData V2 service {}.", (Object)service.getName());
            return Option.none();
        }
        Optional javaMethod = JavaServiceMethodResolver.builder().finalMethod(ApiUsageMetadata.method((String)"executeRequest").arg("destination", Destination.class)).sourceDirectory(outputDir).excludedMethodName("withServicePath").qualifiedServiceName((String)serviceInterface.get()).priorityByMethodNamePrefix(new String[]{"getAll", "get", "create", "update", "delete"}).additionalInvocation(JavaServiceMethodResolver.forPrefix((String)"getAll").add(ApiUsageMetadata.method((String)"top").arg("5"))).build();
        if (!javaMethod.isPresent()) {
            this.logger.info("No suitable service method found for OData V2 service {}.", (Object)service.getName());
            return Option.none();
        }
        return Option.of((Object)ODataApiUsageMetadata.builder().qualifiedServiceClassName((String)serviceClass.get()).qualifiedServiceInterfaceName((String)serviceInterface.get()).qualifiedServiceMethodResult(((JavaServiceMethodResolver)javaMethod.get()).getResultType()).serviceMethodInvocations((Collection)((JavaServiceMethodResolver)javaMethod.get()).getInvocations()).build());
    }

    @Generated
    public DatamodelMetadataGeneratorAdapter(Logger logger) {
        this.logger = logger;
    }
}

