/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.CopyrightHeaderCodeWriter;
import com.sap.cloud.sdk.datamodel.odata.generator.DataModelGeneratorConfig;
import com.sap.cloud.sdk.datamodel.odata.generator.DefaultServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.DefaultServiceBatchGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.EdmService;
import com.sap.cloud.sdk.datamodel.odata.generator.EntitySetProcessor;
import com.sap.cloud.sdk.datamodel.odata.generator.FluentHelperClassGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.GeneratorReferenceCodeWriter;
import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.NamespaceClassGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.NamingContext;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorWriteException;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataToVdmGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.PreparedEntityBluePrint;
import com.sap.cloud.sdk.datamodel.odata.generator.SafeCodeWriter;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceClassGenerator;
import com.sap.cloud.sdk.datamodel.odata.utility.LegacyClassScanner;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingStrategy;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;

class CodeModelClassGenerator {
    private static final Logger logger = MessageCollector.getLogger(ODataToVdmGenerator.class);
    private final NamespaceClassGenerator namespaceClassGenerator;
    private final ServiceClassGenerator serviceClassGenerator;
    private final FluentHelperClassGenerator fluentGenerator;
    private final JCodeModel codeModel;
    private final DataModelGeneratorConfig config;

    CodeModelClassGenerator(@Nonnull DataModelGeneratorConfig config, @Nonnull String namespaceParentPackageName, @Nonnull String servicePackageName) {
        this.config = config;
        this.codeModel = new JCodeModel();
        NamingStrategy namingStrategy = config.getNamingStrategy();
        JPackage namespaceParentPackage = this.codeModel._package(namespaceParentPackageName);
        this.namespaceClassGenerator = new NamespaceClassGenerator(this.codeModel, namespaceParentPackage, namingStrategy, config.getAnnotationStrategy(), config.isGeneratePojosOnly());
        if (config.isGeneratePojosOnly()) {
            this.serviceClassGenerator = null;
            this.fluentGenerator = null;
        } else {
            JPackage servicePackage = this.codeModel._package(servicePackageName);
            ServiceBatchGenerator serviceBatchGenerator = new ServiceBatchGenerator(this.codeModel);
            ServiceBatchChangeSetGenerator serviceBatchChangeSetGenerator = new ServiceBatchChangeSetGenerator(this.codeModel);
            DefaultServiceBatchGenerator defaultServiceBatchGenerator = new DefaultServiceBatchGenerator(this.codeModel);
            DefaultServiceBatchChangeSetGenerator defaultServiceBatchChangeSetGenerator = new DefaultServiceBatchChangeSetGenerator(this.codeModel);
            LegacyClassScanner classScanner = config.isKeepExistingSignatures() ? new LegacyClassScanner(config.getOutputDirectory()) : LegacyClassScanner.DISABLED;
            this.serviceClassGenerator = new ServiceClassGenerator(this.codeModel, servicePackage, namespaceParentPackage, namingStrategy, serviceBatchChangeSetGenerator, serviceBatchGenerator, defaultServiceBatchGenerator, defaultServiceBatchChangeSetGenerator, config.isServiceMethodsPerEntitySet(), classScanner);
            this.fluentGenerator = new FluentHelperClassGenerator(this.codeModel, namingStrategy, classScanner);
        }
    }

    void processService(Service service, @Nullable Collection<String> includedEntitySets, @Nullable Collection<String> includedFunctionImports) {
        String serviceTitle = service.getTitle();
        String odataEndpointPath = service.getServiceUrl();
        logger.info("Processing OData service '" + serviceTitle + "' at " + odataEndpointPath);
        EntitySetProcessor entitySetProcessor = new EntitySetProcessor(service, odataEndpointPath, this.namespaceClassGenerator, this.serviceClassGenerator, this.fluentGenerator, this.config.isServiceMethodsPerEntitySet());
        NamingContext entityClassNamingContext = new NamingContext(NamingContext.NameEqualityStrategy.CASE_INSENSITIVE);
        if (this.config.getDeprecationNotice() != null) {
            ((EdmService)service).setGenerateExplicitDeprecationNotices(true);
            this.serviceClassGenerator.setCustomDeprecationNoticeForService(this.config.getDeprecationNotice());
        }
        List<PreparedEntityBluePrint> preparedEntityBluePrints = entitySetProcessor.processEntitySets(includedEntitySets, entityClassNamingContext);
        entitySetProcessor.processNavigationPropertyModels(preparedEntityBluePrints);
        if (!this.config.isGeneratePojosOnly()) {
            entitySetProcessor.processFunctionImports(includedFunctionImports, entityClassNamingContext);
        }
    }

    void writeClasses(@Nonnull DataModelGeneratorConfig config, @Nonnull Charset encoding) {
        this.ensureDirectoryExists(config.getOutputDirectory());
        CodeWriter codeWriter = this.getCodeWriter(config, encoding);
        this.writeCodeModel(codeWriter);
    }

    private void writeCodeModel(CodeWriter codeWriter) {
        try {
            this.codeModel.build(codeWriter);
        }
        catch (IOException e) {
            throw new ODataGeneratorWriteException(e);
        }
    }

    private void ensureDirectoryExists(File targetDir) {
        boolean success;
        if (!targetDir.exists() && !(success = targetDir.mkdirs())) {
            throw new ODataGeneratorWriteException("Could not create directory at '" + targetDir.getAbsolutePath() + "'");
        }
    }

    private CodeWriter getCodeWriter(@Nonnull DataModelGeneratorConfig config, @Nonnull Charset encoding) {
        CodeWriter codeWriter;
        if (config.isForceFileOverride()) {
            try {
                codeWriter = new FileCodeWriter(config.getOutputDirectory(), encoding.toString());
            }
            catch (IOException e) {
                throw new ODataGeneratorWriteException(e);
            }
        } else {
            codeWriter = new SafeCodeWriter(config.getOutputDirectory(), encoding.toString());
        }
        if (!config.getCopyrightHeader().isEmpty()) {
            codeWriter = new CopyrightHeaderCodeWriter(codeWriter, config.getCopyrightHeader(), encoding.toString());
        }
        if (config.isGenerateVersionReference()) {
            codeWriter = new GeneratorReferenceCodeWriter(codeWriter, encoding.toString());
        }
        return codeWriter;
    }

    boolean wasServiceGenerated(String serviceName) {
        return this.serviceClassGenerator != null && this.serviceClassGenerator.wasServiceGenerated(serviceName);
    }

    @Generated
    NamespaceClassGenerator getNamespaceClassGenerator() {
        return this.namespaceClassGenerator;
    }

    @Generated
    ServiceClassGenerator getServiceClassGenerator() {
        return this.serviceClassGenerator;
    }
}

