/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorReadException;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceDetails;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceDetailsOpenApi3;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceDetailsSwagger2;
import com.sap.cloud.sdk.result.ElementNameGsonFieldNamingStrategy;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

class ServiceDetailsParser {
    private static final String VERSION2_IDENTIFIER_PATTERN = Pattern.compile("^2\\.0$").pattern();
    private static final String VERSION3_IDENTIFIER_PATTERN = Pattern.compile("^3\\.\\d+\\.\\d+$").pattern();

    ServiceDetailsParser() {
    }

    @Nonnull
    static ServiceDetails parse(@Nonnull File serviceSwaggerFile, Charset encoding) {
        ResultElement serviceDetailsResult = ServiceDetailsParser.readSwaggerJsonFile(serviceSwaggerFile, encoding);
        Class<? extends ServiceDetails> implementationClass = ServiceDetailsParser.determineServiceDetailsImplementation(serviceDetailsResult.getAsObject());
        return (ServiceDetails)serviceDetailsResult.getAsObject().as(implementationClass);
    }

    private static Class<? extends ServiceDetails> determineServiceDetailsImplementation(ResultObject object) {
        String version;
        String version2;
        ResultElement version3Identifier = object.get("openapi");
        if (version3Identifier != null && (version2 = version3Identifier.asString()).matches(VERSION3_IDENTIFIER_PATTERN)) {
            return ServiceDetailsOpenApi3.class;
        }
        ResultElement version2Identifier = object.get("swagger");
        if (version2Identifier != null && (version = version2Identifier.asString()).matches(VERSION2_IDENTIFIER_PATTERN)) {
            return ServiceDetailsSwagger2.class;
        }
        throw new ODataGeneratorReadException("The given swagger is no valid Swagger 2.0 (missing or invalid 'swagger' property) or OpenAPI 3.x.x (missing or invalid 'openapi' property).");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResultElement readSwaggerJsonFile(@Nonnull File serviceSwaggerFile, Charset encoding) {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(serviceSwaggerFile.toPath(), new OpenOption[0]), encoding);){
            ResultElement resultElement = ServiceDetailsParser.parseResponse(reader);
            return resultElement;
        }
        catch (IOException e) {
            throw new ODataGeneratorReadException(e);
        }
    }

    private static ResultElement parseResponse(Reader reader) {
        JsonElement responseElement = JsonParser.parseReader((Reader)reader);
        JsonObject resultContainer = responseElement.getAsJsonObject();
        GsonResultElementFactory resultElementFactory = new GsonResultElementFactory(ServiceDetailsParser.getGsonBuilder());
        return resultElementFactory.create((Object)resultContainer);
    }

    private static GsonBuilder getGsonBuilder() {
        return new GsonBuilder().setFieldNamingStrategy((FieldNamingStrategy)new ElementNameGsonFieldNamingStrategy());
    }
}

