/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.sap.cloud.sdk.datamodel.odata.generator.AbstractServiceDetails;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorReadException;
import com.sap.cloud.sdk.result.ElementName;
import io.vavr.control.Option;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceDetailsOpenApi3
extends AbstractServiceDetails {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceDetailsOpenApi3.class);
    @ElementName(value="servers")
    @JsonAdapter(value=ServersAdapter.class)
    private String serviceUrl;

    @Generated
    public ServiceDetailsOpenApi3() {
    }

    @Override
    @Generated
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    @Generated
    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @Override
    @Nonnull
    @Generated
    public String toString() {
        return "ServiceDetailsOpenApi3(serviceUrl=" + this.getServiceUrl() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceDetailsOpenApi3)) {
            return false;
        }
        ServiceDetailsOpenApi3 other = (ServiceDetailsOpenApi3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        return !(this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServiceDetailsOpenApi3;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        return result;
    }

    private static class ServersAdapter
    extends TypeAdapter<String> {
        private ServersAdapter() {
        }

        public void write(JsonWriter out, String value) throws IOException {
        }

        public String read(JsonReader in) throws IOException {
            List<String> serverUrls = this.extractServerUrls(in);
            if (serverUrls.isEmpty()) {
                return "/";
            }
            Option<String> basePathFromServerUrlTemplate = ServersAdapter.getBasePathFromServerUrlTemplate(serverUrls);
            if (basePathFromServerUrlTemplate.isDefined()) {
                return (String)basePathFromServerUrlTemplate.get();
            }
            log.warn("No server URL template supplied. Expected the format \"{protocol}://{host{:port}}/base/path\".");
            Option<String> basePathFromApiHubSandbox = ServersAdapter.getBasePathFromApiHubSandbox(serverUrls);
            if (basePathFromApiHubSandbox.isDefined()) {
                log.warn("Falling back to base path from the API Hub sandbox URL.");
                return (String)basePathFromApiHubSandbox.get();
            }
            throw new ODataGeneratorReadException("Could not read base path from the 'servers' property of the swagger file.");
        }

        private static Option<String> getBasePathFromServerUrlTemplate(@Nonnull List<String> serverUrls) {
            return Option.ofOptional(serverUrls.stream().map(ServersAdapter::extractPath).distinct().filter(Option::isDefined).map(Option::get).findFirst());
        }

        private static Option<String> getBasePathFromApiHubSandbox(@Nonnull List<String> serverUrls) {
            return Option.ofOptional(serverUrls.stream().filter(s -> s.contains("sandbox.api.sap.com")).map(s -> URI.create(s).getPath()).distinct().findFirst());
        }

        private static Option<String> extractPath(String urlString) {
            return Option.some((Object)urlString).filter(s -> s.contains("://")).filter(s -> !s.endsWith("://")).map(s -> urlString.split("://")[1]).map(s -> s.indexOf("/") > 0 ? s.substring(s.indexOf("/")) : "").map(path -> path.isEmpty() ? "/" : path);
        }

        private List<String> extractServerUrls(JsonReader in) throws IOException {
            ArrayList<String> serverUrls = new ArrayList<String>();
            in.beginArray();
            while (in.hasNext()) {
                in.beginObject();
                while (in.peek() != JsonToken.END_OBJECT) {
                    String propertyName = in.nextName();
                    if (propertyName.equals("url")) {
                        String url = in.nextString();
                        serverUrls.add(url);
                        continue;
                    }
                    in.skipValue();
                }
                in.endObject();
            }
            in.endArray();
            return serverUrls;
        }
    }
}

