/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperServiceBatch;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import javax.annotation.Nonnull;
import lombok.Generated;

class ServiceBatchGenerator {
    private final JCodeModel codeModel;

    InterfaceStub createInterfaceStub(JClassContainer targetPackage, JDefinedClass serviceInterface) throws JClassAlreadyExistsException {
        JDefinedClass interfaceToCreate = targetPackage._interface(1, this.createInterfaceName(serviceInterface));
        interfaceToCreate.javadoc().add((Object)String.format("Interface to the batch object of an {@code %s %s} service.", serviceInterface.fullName(), serviceInterface.name()));
        return new InterfaceStub(interfaceToCreate);
    }

    private void addSuperClass(JDefinedClass stubToModify, JDefinedClass batchChangeSetInterface) {
        stubToModify._extends(this.codeModel.ref(FluentHelperServiceBatch.class).narrow(new JClass[]{stubToModify, batchChangeSetInterface}));
    }

    private String createInterfaceName(JDefinedClass serviceInterface) {
        return serviceInterface.name() + "Batch";
    }

    @Generated
    ServiceBatchGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    class InterfaceStub {
        @Nonnull
        private final JDefinedClass serviceBatchStub;

        void addSuperClass(ServiceBatchChangeSetGenerator.InterfaceStub changeSetInterfaceStub) {
            ServiceBatchGenerator.this.addSuperClass(this.serviceBatchStub, changeSetInterfaceStub.getServiceBatchChangeSetStub());
        }

        @Generated
        private InterfaceStub(JDefinedClass serviceBatchStub) {
            if (serviceBatchStub == null) {
                throw new NullPointerException("serviceBatchStub is marked non-null but is null");
            }
            this.serviceBatchStub = serviceBatchStub;
        }

        @Nonnull
        @Generated
        JDefinedClass getServiceBatchStub() {
            return this.serviceBatchStub;
        }
    }
}

