/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;

class SafeCodeWriter
extends CodeWriter {
    private final File targetDirectory;

    public SafeCodeWriter(File targetDirectory, String encoding) {
        this.encoding = encoding;
        this.targetDirectory = targetDirectory;
    }

    @Nonnull
    public OutputStream openBinary(@Nonnull JPackage pkg, @Nonnull String fileName) throws IOException {
        boolean success;
        File dir = pkg.isUnnamed() ? this.targetDirectory : new File(this.targetDirectory, SafeCodeWriter.toDirName(pkg));
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new IOException("Could not create directory at '" + dir.getAbsolutePath() + "'");
        }
        File fn = new File(dir, fileName);
        if (fn.exists()) {
            throw new IOException("Cannot override existing file: " + fn.getAbsolutePath());
        }
        return Files.newOutputStream(fn.toPath(), new OpenOption[0]);
    }

    private static String toDirName(JPackage pkg) {
        return pkg.name().replace('.', File.separatorChar);
    }

    public void close() {
    }
}

