/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.datamodel.odata.generator.DefaultNameFormattingStrategy;
import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.NameFormattingStrategy;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

class NamingContext {
    private static final int GETTER_AND_SETTER_PREFIX_LENGTH = 3;
    private static final Logger logger = MessageCollector.getLogger(NamingContext.class);
    private static final List<String> knownGeneratedFields = Lists.newArrayList((Object[])new String[]{"allFields", "destinationForFetch"});
    private final Map<String, Integer> occurrences;
    private final NameFormattingStrategy nameFormattingStrategy;

    NamingContext() {
        this(new DefaultNameFormattingStrategy(), NameEqualityStrategy.CASE_SENSITIVE);
    }

    NamingContext(NameFormattingStrategy nameFormattingStrategy) {
        this(nameFormattingStrategy, NameEqualityStrategy.CASE_SENSITIVE);
    }

    NamingContext(NameEqualityStrategy nameEqualityStrategy) {
        this(new DefaultNameFormattingStrategy(), nameEqualityStrategy);
    }

    NamingContext(NameFormattingStrategy nameFormattingStrategy, NameEqualityStrategy nameEqualityStrategy) {
        this.nameFormattingStrategy = nameFormattingStrategy;
        this.occurrences = nameEqualityStrategy.getOccurrencesMap();
    }

    String ensureUniqueName(String proposedName) {
        String comparisonName = this.nameFormattingStrategy.applyFormat(proposedName);
        String uniqueName = proposedName;
        if (this.occurrences.containsKey(comparisonName)) {
            uniqueName = this.addFollowingOccurrence(proposedName, comparisonName);
            logger.info(String.format("Found more than one occurrence of the Java identifier %s. The new identifier has been renamed to %s", proposedName, uniqueName));
        } else {
            this.addFirstOccurrence(comparisonName);
        }
        return uniqueName;
    }

    boolean alreadyUses(String proposedName) {
        String comparisonName = this.nameFormattingStrategy.applyFormat(proposedName);
        return this.occurrences.containsKey(comparisonName);
    }

    private void addFirstOccurrence(String comparisonName) {
        this.occurrences.put(comparisonName, 1);
    }

    private String addFollowingOccurrence(String proposedName, String comparisonName) {
        int newCount = this.occurrences.get(comparisonName) + 1;
        this.occurrences.put(comparisonName, newCount);
        return this.formatNextName(proposedName, newCount);
    }

    private String formatNextName(String proposedName, int occurrence) {
        return String.format("%s_%d", proposedName, occurrence);
    }

    void loadGettersAndSettersOfClassAsAlreadyPresentFields(Class<?> methodsProvidingClass) {
        Method[] methods = methodsProvidingClass.getDeclaredMethods();
        Arrays.stream(methods).filter(NamingContext::isVisibleInSubclasses).map(Method::getName).filter(NamingContext::hasGetterOrSetterPrefix).map(NamingContext::removeGetterOrSetterPrefix).map(StringUtils::uncapitalize).map(this.nameFormattingStrategy::applyFormat).forEach(this::addFirstOccurrence);
        Class<?> superclass = methodsProvidingClass.getSuperclass();
        if (superclass != null) {
            this.loadGettersAndSettersOfClassAsAlreadyPresentFields(superclass);
        }
    }

    private static boolean hasGetterOrSetterPrefix(String methodName) {
        return (methodName.startsWith("get") || methodName.startsWith("set")) && Character.isUpperCase(methodName.charAt(3));
    }

    private static String removeGetterOrSetterPrefix(String methodName) {
        return methodName.substring(3);
    }

    private static boolean isVisibleInSubclasses(Method method) {
        return !Modifier.isPrivate(method.getModifiers());
    }

    void loadKnownGeneratedFields() {
        knownGeneratedFields.stream().map(this.nameFormattingStrategy::applyFormat).forEach(this::addFirstOccurrence);
    }

    static enum NameEqualityStrategy {
        CASE_SENSITIVE(true),
        CASE_INSENSITIVE(false);

        private final boolean caseSensitive;

        private NameEqualityStrategy(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        Map<String, Integer> getOccurrencesMap() {
            return this.caseSensitive ? new HashMap() : new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }
    }
}

