/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.NamespaceClassGenerator;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

class GeneratorReferenceCodeWriter
extends CodeWriter {
    private static final Logger logger = MessageCollector.getLogger(NamespaceClassGenerator.class);
    private static final String RESOURCE_VERSION = "version.properties";
    private static final String RESOURCE_KEY = "version.sdk";
    private static final String REFERENCE_HEADER = "\n/*\n * Generated by OData VDM code generator of SAP Cloud SDK in version %s\n */\n";
    @Nonnull
    private final CodeWriter delegate;
    @Nullable
    private final String generatorReference = (String)this.loadReference().getOrNull();

    GeneratorReferenceCodeWriter(@Nonnull CodeWriter codeWriter, String encoding) {
        this.delegate = codeWriter;
        this.encoding = encoding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<String> loadReference() {
        try (InputStream versionResource = GeneratorReferenceCodeWriter.class.getClassLoader().getResourceAsStream(RESOURCE_VERSION);){
            Properties prop = new Properties();
            prop.load(versionResource);
            String generator = prop.getProperty(RESOURCE_KEY);
            Option option = Option.of((Object)generator);
            return option;
        }
        catch (IOException e) {
            logger.error("Failed to load version.properties", (Throwable)e);
            return Option.none();
        }
    }

    public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
        OutputStream result = this.delegate.openBinary(pkg, fileName);
        if (this.generatorReference != null) {
            String referenceText = String.format(REFERENCE_HEADER, this.generatorReference);
            result.write(referenceText.getBytes(StandardCharsets.UTF_8));
        }
        return result;
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

