/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.generator.EntityPropertyModel;
import com.sap.cloud.sdk.datamodel.odata.generator.FunctionImportParameterModel;
import com.sap.cloud.sdk.datamodel.odata.generator.NamingContext;
import com.sap.cloud.sdk.datamodel.odata.helper.CollectionValuedFluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperCreate;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;
import com.sap.cloud.sdk.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;
import com.sap.cloud.sdk.datamodel.odata.utility.LegacyClassScanner;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingStrategy;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingUtils;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

class FluentHelperClassGenerator {
    private static final String SERVICE_PATH_FIELD_NAME = "servicePath";
    private static final String ENTITY_COLLECTION_FIELD_NAME = "entityCollection";
    private final JCodeModel codeModel;
    private final NamingStrategy codeNamingStrategy;
    private final LegacyClassScanner classScanner;

    private void createGetEntityClass(JDefinedClass clazz, JClass entityClass) {
        JMethod getEntityClassMethod = clazz.method(2, (JType)this.codeModel.ref(Class.class).narrow(entityClass), "getEntityClass");
        getEntityClassMethod.annotate(Override.class);
        getEntityClassMethod.annotate(Nonnull.class);
        getEntityClassMethod.body()._return(entityClass.dotclass());
    }

    private void createRefineJsonResponse(JDefinedClass clazz) {
        JMethod method = clazz.method(2, (JType)this.codeModel.ref(JsonElement.class), "refineJsonResponse");
        JVar jsonElement = method.param((JType)this.codeModel.ref(JsonElement.class), "jsonElement");
        jsonElement.annotate(Nullable.class);
        method.annotate(Override.class);
        method.annotate(Nullable.class);
        JCast castedJsonElement = JExpr.cast((JType)this.codeModel.ref(JsonObject.class), (JExpression)jsonElement);
        JInvocation getFunctionName = JExpr.invoke((String)"getFunctionName");
        method.body()._if(jsonElement._instanceof((JType)this.codeModel.ref(JsonObject.class)).cand((JExpression)castedJsonElement.invoke("has").arg((JExpression)getFunctionName)))._then().assign((JAssignmentTarget)jsonElement, (JExpression)castedJsonElement.invoke("get").arg((JExpression)getFunctionName));
        method.body()._return((JExpression)JExpr._super().invoke(method).arg((JExpression)jsonElement));
    }

    private void generateDeprecatedReadConstructor(JDefinedClass fluentHelperClass) {
        JMethod constructor = fluentHelperClass.constructor(1);
        constructor.annotate(Deprecated.class);
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        servicePathParam.annotate(Nonnull.class);
        constructor.body().invoke("super").arg((JExpression)servicePathParam);
        constructor.javadoc().add((Object)"Creates a fluent helper using the specified service path to send the read requests.");
        constructor.javadoc().addParam(servicePathParam).add((Object)"The service path to direct the read requests to.");
        constructor.javadoc().addDeprecated().add((Object)("Use the constructor {@link " + fluentHelperClass.name() + "#" + fluentHelperClass.name() + "(String, String)} instead."));
    }

    private void generateReadConstructor(JDefinedClass fluentHelperClass) {
        JMethod constructor = fluentHelperClass.constructor(1);
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        servicePathParam.annotate(Nonnull.class);
        JVar entityCollectionParam = constructor.param(8, String.class, ENTITY_COLLECTION_FIELD_NAME);
        entityCollectionParam.annotate(Nonnull.class);
        constructor.body().invoke("super").arg((JExpression)servicePathParam).arg((JExpression)entityCollectionParam);
        constructor.javadoc().add((Object)"Creates a fluent helper using the specified service path and entity collection to send the read requests.");
        constructor.javadoc().addParam(servicePathParam).add((Object)"The service path to direct the read requests to.");
        constructor.javadoc().addParam(entityCollectionParam).add((Object)"The entity collection to direct the requests to.");
    }

    JDefinedClass generateEntityReadFluentHelperClass(NamingContext entityClassNamingContext, JClassContainer namespacePackage, JDefinedClass entityClass, JDefinedClass specificEntitySelectableClass) throws JClassAlreadyExistsException {
        String fluentHelperClassName = entityClassNamingContext.ensureUniqueName(NamingUtils.deriveJavaEntityFluentHelperClassName((String)entityClass.name()));
        JDefinedClass entityFluentHelperClass = namespacePackage._class(1, fluentHelperClassName);
        entityFluentHelperClass._extends(this.codeModel.ref(FluentHelperRead.class).narrow(new JClass[]{entityFluentHelperClass, entityClass, specificEntitySelectableClass}));
        entityFluentHelperClass.javadoc().add((Object)String.format("Fluent helper to fetch multiple {@link %s %s} entities. This fluent helper allows methods which modify the underlying query to be called before executing the query itself. ", entityClass.fullName(), entityClass.name()));
        this.generateReadConstructor(entityFluentHelperClass);
        this.generateDeprecatedReadConstructor(entityFluentHelperClass);
        this.createGetEntityClass(entityFluentHelperClass, (JClass)entityClass);
        return entityFluentHelperClass;
    }

    JDefinedClass generateEntityByKeyFluentHelperClass(NamingContext entityClassNamingContext, JClassContainer namespacePackage, JDefinedClass entityClass, Iterable<EntityPropertyModel> keyProperties, JDefinedClass specificEntitySelectableClass) throws JClassAlreadyExistsException {
        String fluentHelperClassName = entityClassNamingContext.ensureUniqueName(NamingUtils.deriveJavaEntityByKeyFluentHelperClassName((String)entityClass.name()));
        JDefinedClass entityByKeyFluentHelperClass = namespacePackage._class(1, fluentHelperClassName);
        entityByKeyFluentHelperClass._extends(this.codeModel.ref(FluentHelperByKey.class).narrow(new JClass[]{entityByKeyFluentHelperClass, entityClass, specificEntitySelectableClass}));
        entityByKeyFluentHelperClass.javadoc().add((Object)String.format("Fluent helper to fetch a single {@link %s %s} entity using key fields. This fluent helper allows methods which modify the underlying query to be called before executing the query itself. ", entityClass.fullName(), entityClass.name()));
        this.createGetEntityClass(entityByKeyFluentHelperClass, (JClass)entityClass);
        JClass keyClass = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        JFieldVar keyMapField = entityByKeyFluentHelperClass.field(12, (JType)keyClass, "key", (JExpression)this.codeModel.ref(Maps.class).staticInvoke("newHashMap"));
        JMethod deprecatedConstructor = this.generateDeprecatedEntityByKeyFluentHelperConstructor(entityClass, entityByKeyFluentHelperClass, keyProperties);
        JMethod regularConstructor = this.generateEntityByKeyFluentHelperConstructor(entityClass, entityByKeyFluentHelperClass);
        JMethod[] constructors = new JMethod[]{deprecatedConstructor, regularConstructor};
        for (EntityPropertyModel keyProperty : keyProperties) {
            ((Stream)Arrays.stream(constructors).parallel()).forEach(constructor -> {
                JVar param = constructor.param(8, keyProperty.getJavaFieldType(), keyProperty.getJavaFieldName());
                constructor.body().add((JStatement)JExpr.refthis((String)keyMapField.name()).invoke("put").arg(keyProperty.getEdmName()).arg((JExpression)param));
                JCommentPart parameterJavadoc = constructor.javadoc().addParam(param);
                parameterJavadoc.add((Object)keyProperty.getBasicDescription());
                if (!Strings.isNullOrEmpty((String)keyProperty.getBasicDescription())) {
                    parameterJavadoc.add((Object)String.format("<p>%s</p>", keyProperty.getConstraintsDescription()));
                }
            });
        }
        JMethod getKeyMethod = entityByKeyFluentHelperClass.method(2, (JType)keyClass, "getKey");
        getKeyMethod.annotate(Override.class);
        getKeyMethod.annotate(Nonnull.class);
        getKeyMethod.body()._return((JExpression)keyMapField);
        return entityByKeyFluentHelperClass;
    }

    @Nonnull
    private JMethod generateEntityByKeyFluentHelperConstructor(JDefinedClass entityClass, JDefinedClass entityByKeyFluentHelperClass) {
        JMethod constructor = entityByKeyFluentHelperClass.constructor(1);
        constructor.javadoc().add((Object)String.format("Creates a fluent helper object that will fetch a single {@link %s %s} entity with the provided key field values. To perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        servicePathParam.annotate(Nonnull.class);
        constructor.javadoc().addParam(servicePathParam).add((Object)String.format("Service path to be used to fetch a single {@code %s}", entityClass.name()));
        JVar entityCollectionParam = constructor.param(8, String.class, ENTITY_COLLECTION_FIELD_NAME);
        entityCollectionParam.annotate(Nonnull.class);
        constructor.javadoc().addParam(entityCollectionParam).add((Object)String.format("Entity Collection to be used to fetch a single {@code %s}", entityClass.name()));
        constructor.body().invoke("super").arg((JExpression)servicePathParam).arg((JExpression)entityCollectionParam);
        return constructor;
    }

    @Nonnull
    private JMethod generateDeprecatedEntityByKeyFluentHelperConstructor(JDefinedClass entityClass, JDefinedClass entityByKeyFluentHelperClass, Iterable<EntityPropertyModel> keyProperties) {
        JMethod constructor = entityByKeyFluentHelperClass.constructor(1);
        constructor.annotate(Deprecated.class);
        constructor.javadoc().add((Object)String.format("Creates a fluent helper object that will fetch a single {@link %s %s} entity with the provided key field values. To perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        servicePathParam.annotate(Nonnull.class);
        constructor.javadoc().addParam(servicePathParam).add((Object)String.format("Service path to be used to fetch a single {@code %s}", entityClass.name()));
        constructor.body().invoke("super").arg((JExpression)servicePathParam);
        String javadocLinkTagContentSuffix = Joiner.on((String)", ").join((Iterable)StreamSupport.stream(keyProperties.spliterator(), false).map(EntityPropertyModel::getJavaFieldType).map(JType::name).collect(Collectors.toList()));
        constructor.javadoc().addDeprecated().add((Object)("Use the constructor {@link " + entityByKeyFluentHelperClass.name() + "#" + entityByKeyFluentHelperClass.name() + "(String, String" + (Strings.isNullOrEmpty((String)javadocLinkTagContentSuffix) ? "" : ", " + javadocLinkTagContentSuffix) + ")}  instead."));
        return constructor;
    }

    private JClass getReturnTypeClass(JType javaReturnType) {
        return javaReturnType.isPrimitive() ? javaReturnType.boxify() : (JClass)javaReturnType;
    }

    JDefinedClass generateFunctionImportFluentHelperClass(JPackage namespacePackage, String edmName, String edmLabel, JType javaReturnType, boolean isCollectionReturnType, String httpMethod, Iterable<FunctionImportParameterModel> parameters, NamingContext functionImportClassNamingContext) throws JClassAlreadyExistsException {
        JClass returnTypeClass = this.getReturnTypeClass(javaReturnType);
        String fluentHelperClassName = functionImportClassNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaFluentHelperClassName(edmName, edmLabel));
        JDefinedClass functionImportFluentHelperClass = namespacePackage._class(1, fluentHelperClassName);
        JClass executionResultClass = isCollectionReturnType ? this.codeModel.ref(List.class).narrow(returnTypeClass) : returnTypeClass;
        JClass functionTypeClass = isCollectionReturnType ? this.codeModel.ref(CollectionValuedFluentHelperFunction.class) : this.codeModel.ref(SingleValuedFluentHelperFunction.class);
        functionImportFluentHelperClass._extends(functionTypeClass.narrow(new JClass[]{functionImportFluentHelperClass, returnTypeClass, executionResultClass}));
        functionImportFluentHelperClass.javadoc().add((Object)String.format("Fluent helper for the <b>%s</b> OData function import.", edmName));
        JFieldVar valuesMapField = functionImportFluentHelperClass.field(12, (JType)this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class}), "values", (JExpression)this.codeModel.ref(Maps.class).staticInvoke("newHashMap"));
        this.createGetEntityClass(functionImportFluentHelperClass, returnTypeClass);
        List constructors = this.classScanner.determineArgumentsForConstructor(functionImportFluentHelperClass.fullName(), parameters, FunctionImportParameterModel::getJavaName, 1);
        for (List arguments : constructors) {
            JMethod constructor = functionImportFluentHelperClass.constructor(1);
            constructor.javadoc().add((Object)String.format("Creates a fluent helper object that will execute the <b>%s</b> OData function import with the provided parameters. To perform execution, call the {@link #execute execute} method on the fluent helper object.", edmName));
            JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
            servicePathParam.annotate(Nonnull.class);
            constructor.javadoc().addParam(servicePathParam).add((Object)"Service path to be used to call the functions against.");
            constructor.body().invoke("super").arg((JExpression)servicePathParam);
            JClass oDataTypeValueSerializerClass = this.codeModel.ref(ODataTypeValueSerializer.class);
            JClass edmSimpleTypeKindEnum = this.codeModel.ref(EdmSimpleTypeKind.class);
            for (FunctionImportParameterModel functionImportParam : arguments) {
                JVar param = constructor.param(8, functionImportParam.getJavaType(), functionImportParam.getJavaName());
                param.annotate(functionImportParam.isNonnull() ? Nonnull.class : Nullable.class);
                JInvocation val = oDataTypeValueSerializerClass.staticInvoke("of").arg((JExpression)edmSimpleTypeKindEnum.staticRef(functionImportParam.getEdmType())).invoke("toUri").arg((JExpression)param);
                JBlock container = functionImportParam.isNonnull() ? constructor.body() : constructor.body()._if(param.ne(JExpr._null()))._then().block();
                container.invoke((JExpression)valuesMapField, "put").arg(functionImportParam.getEdmName()).arg((JExpression)val);
                constructor.javadoc().addParam(param).add((Object)functionImportParam.getDescription());
            }
        }
        JMethod getFunctionNameMethod = functionImportFluentHelperClass.method(2, String.class, "getFunctionName");
        getFunctionNameMethod.annotate(Override.class);
        getFunctionNameMethod.annotate(Nonnull.class);
        getFunctionNameMethod.body()._return(JExpr.lit((String)edmName));
        this.createRefineJsonResponse(functionImportFluentHelperClass);
        JMethod getParametersMethod = functionImportFluentHelperClass.method(2, (JType)this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class}), "getParameters");
        getParametersMethod.annotate(Override.class);
        getParametersMethod.annotate(Nonnull.class);
        getParametersMethod.body()._return((JExpression)valuesMapField);
        JClass httpRequestClass = this.codeModel.ref("org.apache.http.client.methods.Http" + NamingUtils.httpMethodToApacheClientClassName((String)httpMethod));
        JMethod createRequestMethod = functionImportFluentHelperClass.method(2, (JType)this.codeModel.ref(HttpUriRequest.class), "createRequest");
        createRequestMethod.annotate(Override.class);
        createRequestMethod.annotate(Nonnull.class);
        JVar uriParam = createRequestMethod.param(8, (JType)this.codeModel.ref(URI.class), "uri");
        uriParam.annotate(Nonnull.class);
        createRequestMethod.body()._return((JExpression)JExpr._new((JClass)httpRequestClass).arg((JExpression)uriParam));
        JMethod executeMethod = functionImportFluentHelperClass.method(1, (JType)executionResultClass, "execute");
        JVar destinationParam = executeMethod.param(8, (JType)this.codeModel.ref(HttpDestinationProperties.class), "destination");
        destinationParam.annotate(Nonnull.class);
        executeMethod.annotate(Override.class);
        executeMethod.annotate(Deprecated.class);
        executeMethod.javadoc().append((Object)"Execute this function import.").addDeprecated().add((Object)"Use the improved method {@code executeRequest(HttpDestinationProperties)} instead.");
        executeMethod._throws(ODataException.class);
        if (isCollectionReturnType) {
            executeMethod.annotate(Nonnull.class);
            executeMethod.body()._return((JExpression)JExpr._super().invoke("executeMultiple").arg((JExpression)destinationParam));
        } else {
            executeMethod.annotate(Nullable.class);
            executeMethod.body()._return((JExpression)JExpr._super().invoke("executeSingle").arg((JExpression)destinationParam));
        }
        return functionImportFluentHelperClass;
    }

    JDefinedClass generateCreateFluentHelper(NamingContext entityClassNamingContext, JPackage namespacePackage, JDefinedClass entityClass) throws JClassAlreadyExistsException {
        String fluentHelperClassName = entityClassNamingContext.ensureUniqueName(NamingUtils.deriveJavaCreateFluentHelperClassName((String)entityClass.name()));
        JDefinedClass createFluentHelperClass = namespacePackage._class(1, fluentHelperClassName);
        createFluentHelperClass._extends(this.codeModel.ref(FluentHelperCreate.class).narrow(new JClass[]{createFluentHelperClass, entityClass}));
        createFluentHelperClass.javadoc().add((Object)String.format("Fluent helper to create a new {@link %s %s} entity and save it to the S/4HANA system.<p>\nTo perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        this.generateDeprecatedCreateFluentHelperConstructor(entityClass, createFluentHelperClass);
        this.generateCreateFluentHelperConstructor(entityClass, createFluentHelperClass);
        JFieldVar entityField = this.addEntityInstanceFieldAndGetter(createFluentHelperClass, entityClass);
        entityField.javadoc().add((Object)String.format("{@link %s %s} entity object that will be created in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
        return createFluentHelperClass;
    }

    private void generateCreateFluentHelperConstructor(JDefinedClass entityClass, JDefinedClass createFluentHelperClass) {
        JMethod constructor = createFluentHelperClass.constructor(1);
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        servicePathParam.annotate(Nonnull.class);
        JVar entityParam = constructor.param(8, (JType)entityClass, "entity");
        entityParam.annotate(Nonnull.class);
        JVar entityCollectionParam = constructor.param(8, String.class, ENTITY_COLLECTION_FIELD_NAME);
        entityCollectionParam.annotate(Nonnull.class);
        constructor.body().invoke("super").arg((JExpression)servicePathParam).arg((JExpression)entityCollectionParam);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)"entity"), (JExpression)entityParam);
        constructor.javadoc().add((Object)String.format("Creates a fluent helper object that will create a {@link %s %s} entity on the OData endpoint. To perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        constructor.javadoc().addParam(servicePathParam).add((Object)"The service path to direct the create requests to.");
        constructor.javadoc().addParam(entityParam).add((Object)String.format("The %s to create.", entityClass.name()));
        constructor.javadoc().addParam(entityCollectionParam).add((Object)"Entity Collection  to direct the create requests to.");
    }

    private void generateDeprecatedCreateFluentHelperConstructor(JDefinedClass entityClass, JDefinedClass createFluentHelperClass) {
        JMethod constructor = createFluentHelperClass.constructor(1);
        constructor.annotate(Deprecated.class);
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        servicePathParam.annotate(Nonnull.class);
        JVar entityParam = constructor.param(8, (JType)entityClass, "entity");
        entityParam.annotate(Nonnull.class);
        constructor.body().invoke("super").arg((JExpression)servicePathParam);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)"entity"), (JExpression)entityParam);
        constructor.javadoc().add((Object)String.format("Creates a fluent helper object that will create a {@link %s %s} entity on the OData endpoint. To perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        constructor.javadoc().addParam(servicePathParam).add((Object)"The service path to direct the create requests to.");
        constructor.javadoc().addParam(entityParam).add((Object)String.format("The %s to create.", entityClass.name()));
        constructor.javadoc().addDeprecated().add((Object)("Use the constructor {@link " + createFluentHelperClass.name() + "#" + createFluentHelperClass.name() + "(String, " + entityClass.name() + ",String)} instead."));
    }

    private JFieldVar addEntityInstanceFieldAndGetter(JDefinedClass fluentHelperClass, JDefinedClass entityClass) {
        JFieldVar entityField = fluentHelperClass.field(12, (JType)entityClass, "entity");
        JMethod getEntityMethod = fluentHelperClass.method(2, (JType)entityClass, "getEntity");
        getEntityMethod.annotate(Override.class);
        getEntityMethod.annotate(Nonnull.class);
        getEntityMethod.body()._return((JExpression)entityField);
        return entityField;
    }

    JDefinedClass generateUpdateFluentHelper(NamingContext entityClassNamingContext, JPackage namespacePackage, JDefinedClass entityClass) throws JClassAlreadyExistsException {
        String fluentHelperClassName = entityClassNamingContext.ensureUniqueName(NamingUtils.deriveJavaUpdateFluentHelperClassName((String)entityClass.name()));
        JDefinedClass updateFluentHelperClass = namespacePackage._class(1, fluentHelperClassName);
        updateFluentHelperClass._extends(this.codeModel.ref(FluentHelperUpdate.class).narrow(new JClass[]{updateFluentHelperClass, entityClass}));
        updateFluentHelperClass.javadoc().add((Object)String.format("Fluent helper to update an existing {@link %s %s} entity and save it to the S/4HANA system.<p>\nTo perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        this.generateDeprecatedUpdateFluentHelperConstructor(entityClass, updateFluentHelperClass, "Creates a fluent helper object that will update a {@link %s %s} entity on the OData endpoint. ", "The %s to take the updated values from.");
        this.generateUpdateFluentHelperConstructor(entityClass, updateFluentHelperClass);
        JFieldVar entityField = this.addEntityInstanceFieldAndGetter(updateFluentHelperClass, entityClass);
        entityField.javadoc().add((Object)String.format("{@link %s %s} entity object that will be updated in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
        return updateFluentHelperClass;
    }

    private void generateUpdateFluentHelperConstructor(JDefinedClass entityClass, JDefinedClass updateFluentHelperClass) {
        JMethod constructor = updateFluentHelperClass.constructor(1);
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        JVar entityParam = constructor.param(8, (JType)entityClass, "entity");
        JVar entityCollectionParam = constructor.param(8, String.class, ENTITY_COLLECTION_FIELD_NAME);
        servicePathParam.annotate(Nonnull.class);
        entityParam.annotate(Nonnull.class);
        entityCollectionParam.annotate(Nonnull.class);
        constructor.body().invoke("super").arg((JExpression)servicePathParam).arg((JExpression)entityCollectionParam);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)"entity"), (JExpression)entityParam);
        constructor.javadoc().add((Object)String.format("Creates a fluent helper object that will update a {@link %s %s} entity on the OData endpoint. To perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        constructor.javadoc().addParam(servicePathParam).add((Object)"The service path to direct the update requests to.");
        constructor.javadoc().addParam(entityParam).add((Object)String.format("The %s to take the updated values from.", entityClass.name()));
    }

    private void generateDeprecatedUpdateFluentHelperConstructor(JDefinedClass entityClass, JDefinedClass updateFluentHelperClass, String s, String s2) {
        JMethod constructor = updateFluentHelperClass.constructor(1);
        constructor.annotate(Deprecated.class);
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        JVar entityParam = constructor.param(8, (JType)entityClass, "entity");
        servicePathParam.annotate(Nonnull.class);
        entityParam.annotate(Nonnull.class);
        constructor.body().invoke("super").arg((JExpression)servicePathParam);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)"entity"), (JExpression)entityParam);
        constructor.javadoc().add((Object)String.format(s + "To perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        constructor.javadoc().addParam(servicePathParam).add((Object)"The service path to direct the update requests to.");
        constructor.javadoc().addParam(entityParam).add((Object)String.format(s2, entityClass.name()));
        constructor.javadoc().addDeprecated().add((Object)("Use the constructor {@link " + updateFluentHelperClass.name() + "#" + updateFluentHelperClass.name() + "(String, " + entityClass.name() + ",String)} instead."));
    }

    JDefinedClass generateDeleteFluentHelper(NamingContext entityClassNamingContext, JPackage namespacePackage, JDefinedClass entityClass) throws JClassAlreadyExistsException {
        String fluentHelperClassName = entityClassNamingContext.ensureUniqueName(NamingUtils.deriveJavaDeleteFluentHelperClassName((String)entityClass.name()));
        JDefinedClass deleteFluentHelperClass = namespacePackage._class(1, fluentHelperClassName);
        deleteFluentHelperClass._extends(this.codeModel.ref(FluentHelperDelete.class).narrow(new JClass[]{deleteFluentHelperClass, entityClass}));
        deleteFluentHelperClass.javadoc().add((Object)String.format("Fluent helper to delete an existing {@link %s %s} entity in the S/4HANA system.<p>\nTo perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        this.generateDeprecatedDeleteFluentHelperConstructor(entityClass, deleteFluentHelperClass);
        this.generateDeleteFluentHelperConstructor(entityClass, deleteFluentHelperClass);
        JFieldVar entityField = this.addEntityInstanceFieldAndGetter(deleteFluentHelperClass, entityClass);
        entityField.javadoc().add((Object)String.format("{@link %s %s} entity object that will be deleted in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
        return deleteFluentHelperClass;
    }

    private void generateDeleteFluentHelperConstructor(JDefinedClass entityClass, JDefinedClass deleteFluentHelperClass) {
        JMethod constructor = deleteFluentHelperClass.constructor(1);
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        JVar entityParam = constructor.param(8, (JType)entityClass, "entity");
        JVar entityCollectionParam = constructor.param(8, String.class, ENTITY_COLLECTION_FIELD_NAME);
        servicePathParam.annotate(Nonnull.class);
        entityParam.annotate(Nonnull.class);
        entityCollectionParam.annotate(Nonnull.class);
        constructor.body().invoke("super").arg((JExpression)servicePathParam).arg((JExpression)entityCollectionParam);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)"entity"), (JExpression)entityParam);
        constructor.javadoc().add((Object)String.format("Creates a fluent helper object that will delete a {@link %s %s} entity on the OData endpoint. To perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        constructor.javadoc().addParam(servicePathParam).add((Object)"The service path to direct the update requests to.");
        constructor.javadoc().addParam(entityParam).add((Object)String.format("The %s to delete from the endpoint.", entityClass.name()));
        constructor.javadoc().addParam(entityCollectionParam).add((Object)"The entity collection to direct the update requests to.");
    }

    private void generateDeprecatedDeleteFluentHelperConstructor(JDefinedClass entityClass, JDefinedClass deleteFluentHelperClass) {
        JMethod constructor = deleteFluentHelperClass.constructor(1);
        constructor.annotate(Deprecated.class);
        JVar servicePathParam = constructor.param(8, String.class, SERVICE_PATH_FIELD_NAME);
        JVar entityParam = constructor.param(8, (JType)entityClass, "entity");
        servicePathParam.annotate(Nonnull.class);
        entityParam.annotate(Nonnull.class);
        constructor.body().invoke("super").arg((JExpression)servicePathParam);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)"entity"), (JExpression)entityParam);
        constructor.javadoc().add((Object)String.format("Creates a fluent helper object that will delete a {@link %s %s} entity on the OData endpoint. To perform execution, call the {@link #execute execute} method on the fluent helper object.", entityClass.fullName(), entityClass.name()));
        constructor.javadoc().addParam(servicePathParam).add((Object)"The service path to direct the update requests to.");
        constructor.javadoc().addParam(entityParam).add((Object)String.format("The %s to delete from the endpoint.", entityClass.name()));
        constructor.javadoc().addDeprecated().add((Object)("Use the constructor {@link " + deleteFluentHelperClass.name() + "#" + deleteFluentHelperClass.name() + "(String, " + entityClass.name() + ",String)} instead."));
    }

    @Generated
    public FluentHelperClassGenerator(JCodeModel codeModel, NamingStrategy codeNamingStrategy, LegacyClassScanner classScanner) {
        this.codeModel = codeModel;
        this.codeNamingStrategy = codeNamingStrategy;
        this.classScanner = classScanner;
    }
}

