/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.FluentHelperClassGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.NamespaceClassGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.NamingContext;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorReadException;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorWriteException;
import com.sap.cloud.sdk.datamodel.odata.generator.PreparedEntityBluePrint;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceClassGenerator;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

final class EntitySetProcessor {
    private static final Logger logger = MessageCollector.getLogger(EntitySetProcessor.class);
    private final Map<String, JDefinedClass> generatedEntities = new HashMap<String, JDefinedClass>();
    private final Map<String, JDefinedClass> generatedComplexTypes = new HashMap<String, JDefinedClass>();
    private final Service service;
    private final String odataEndpointPath;
    private final NamespaceClassGenerator namespaceClassGenerator;
    private final ServiceClassGenerator serviceClassGenerator;
    private final FluentHelperClassGenerator fluentGenerator;
    private final boolean serviceMethodsPerEntitySet;

    EntitySetProcessor(Service service, String odataEndpointPath, NamespaceClassGenerator namespaceClassGenerator, ServiceClassGenerator serviceClassGenerator, FluentHelperClassGenerator fluentGenerator, boolean serviceMethodsPerEntitySet) {
        this.service = service;
        this.odataEndpointPath = odataEndpointPath;
        this.namespaceClassGenerator = namespaceClassGenerator;
        this.serviceClassGenerator = serviceClassGenerator;
        this.fluentGenerator = fluentGenerator;
        this.serviceMethodsPerEntitySet = serviceMethodsPerEntitySet;
    }

    List<PreparedEntityBluePrint> processEntitySets(Collection<String> includeEntitySets, NamingContext entityClassNamingContext) {
        ArrayList<PreparedEntityBluePrint> entityResults = new ArrayList<PreparedEntityBluePrint>();
        ArrayList<Service.EntitySet> entitySetsToProcess = new ArrayList<Service.EntitySet>();
        if (includeEntitySets != null && !includeEntitySets.isEmpty()) {
            for (String entitySetName : includeEntitySets) {
                Service.EntitySet entitySet = this.service.getEntitySet(entitySetName);
                if (entitySet != null) {
                    entitySetsToProcess.add(entitySet);
                    continue;
                }
                logger.warn(String.format("Entity set '%s' was not found in the EDMX for service '%s', skipping.", entitySetName, this.service.getName()));
            }
        } else {
            entitySetsToProcess.addAll(this.service.getAllEntitySets());
        }
        for (Service.EntitySet entitySet : entitySetsToProcess) {
            try {
                Option<PreparedEntityBluePrint> entityStuffAfterFirstPass = this.namespaceClassGenerator.processEntitySet(this.serviceClassGenerator, this.fluentGenerator, this.service, this.odataEndpointPath, this.generatedEntities, this.generatedComplexTypes, entitySet, entityClassNamingContext, this.serviceMethodsPerEntitySet);
                entityStuffAfterFirstPass.peek(entityResults::add);
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorWriteException(e);
            }
        }
        return entityResults;
    }

    void processNavigationPropertyModels(Iterable<PreparedEntityBluePrint> entityBluePrints) {
        for (PreparedEntityBluePrint entityBluePrint : entityBluePrints) {
            if (entityBluePrint.getNavigationProperties().isEmpty()) continue;
            this.namespaceClassGenerator.addNavigationPropertyCode(entityBluePrint, this.generatedEntities);
        }
    }

    void processFunctionImports(Collection<String> includeFunctionImports, NamingContext entityClassNamingContext) {
        NamingContext functionImportFetchMethodNamingContext = new NamingContext();
        ArrayList<Service.FunctionImport> functionImportsToProcess = new ArrayList<Service.FunctionImport>();
        if (includeFunctionImports != null && !includeFunctionImports.isEmpty()) {
            for (String functionImportName : includeFunctionImports) {
                Service.FunctionImport functionImport = this.service.getFunctionImport(functionImportName);
                if (functionImport != null) {
                    functionImportsToProcess.add(functionImport);
                    continue;
                }
                logger.warn(String.format("Function import '%s' was not found in the EDMX for service '%s', skipping.", functionImportName, this.service.getName()));
            }
        } else {
            functionImportsToProcess.addAll(this.service.getAllFunctionImports());
        }
        for (Service.FunctionImport functionImport : functionImportsToProcess) {
            this.validateFunctionImport(functionImport);
            try {
                this.namespaceClassGenerator.processFunctionImport(this.serviceClassGenerator, this.fluentGenerator, this.service, this.generatedEntities, this.generatedComplexTypes, functionImport, entityClassNamingContext, functionImportFetchMethodNamingContext);
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorWriteException(e);
            }
        }
    }

    private void validateFunctionImport(Service.FunctionImport functionImport) {
        if (functionImport.getHttpMethod() == null) {
            throw new ODataGeneratorReadException("There was not HTTP method given for function import " + functionImport.getName() + ". You need to provide one via the 'm:HttpMethod' property.");
        }
    }
}

