/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.datamodel.odata.helper.FilterFunction;
import com.sap.cloud.sdk.datamodel.odata.helper.OneToOneLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import javax.annotation.Nonnull;

class EntityLinkGenerator {
    private static final String NAMESPACE_SUB_PACKAGE_NAME = "link";
    private final JCodeModel codeModel;

    EntityLinkGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    JDefinedClass generateSpecificEntityLinkClass(JPackage namespacePackage, JDefinedClass entityClass, JDefinedClass selectableInterface) throws JClassAlreadyExistsException {
        String entityClassName = entityClass.name();
        JPackage linkSubPackage = this.getLinkSubPackage(namespacePackage);
        JDefinedClass specificEntityLink = linkSubPackage._class(1, entityClassName + "Link");
        JTypeVar objectT = specificEntityLink.generify("ObjectT", this.codeModel.ref(VdmObject.class).narrow(this.codeModel.wildcard()));
        JClass entityLinkExtension = this.codeModel.ref(EntityLink.class).narrow(new JClass[]{specificEntityLink.narrow((JClass)objectT), entityClass, objectT});
        specificEntityLink._extends(entityLinkExtension);
        specificEntityLink._implements((JClass)selectableInterface);
        this.fillLinkClassJavadoc(entityClass, (JDocCommentable)specificEntityLink);
        this.createLinkConstructor(specificEntityLink);
        this.createLinkCopyConstructor(specificEntityLink, entityLinkExtension);
        this.createTranslateLinkTypeMethod(specificEntityLink, objectT, entityLinkExtension);
        return specificEntityLink;
    }

    JDefinedClass generateSpecificEntityLinkOneToOneClass(JPackage namespacePackage, JDefinedClass generatedEntityClass, JDefinedClass generatedSpecificEntityLinkClass, Service service) throws JClassAlreadyExistsException {
        String entityClassName = generatedEntityClass.name();
        JPackage linkSubPackage = this.getLinkSubPackage(namespacePackage);
        JDefinedClass specificEntityOneToOneLink = linkSubPackage._class(1, entityClassName + "OneToOneLink");
        JTypeVar objectT = specificEntityOneToOneLink.generify("ObjectT", this.codeModel.ref(VdmObject.class).narrow(this.codeModel.wildcard()));
        specificEntityOneToOneLink._extends(generatedSpecificEntityLinkClass.narrow((JClass)objectT));
        specificEntityOneToOneLink._implements(this.codeModel.ref(OneToOneLink.class).narrow(new JClass[]{generatedEntityClass, objectT}));
        this.createLinkConstructor(specificEntityOneToOneLink);
        specificEntityOneToOneLink.javadoc().add((Object)String.format("Template class to represent entity navigation links of {@link %s %s} to other entities, where the cardinality of the related entity is at most 1. This class extends {@link %s %s} and provides an additional filter function.\n", generatedEntityClass.fullName(), generatedEntityClass.name(), generatedSpecificEntityLinkClass.fullName(), generatedSpecificEntityLinkClass.name()));
        specificEntityOneToOneLink.javadoc().add((Object)"@param <ObjectT>\nEntity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.");
        JMethod filterFunction = specificEntityOneToOneLink.method(1, (JType)this.codeModel.ref(ExpressionFluentHelper.class).narrow((JClass)generatedEntityClass), "filter");
        JVar filterExpression = filterFunction.param(8, (JType)this.codeModel.ref(ExpressionFluentHelper.class).narrow((JClass)objectT), "filterExpression");
        filterExpression.annotate(this.codeModel.ref(Nonnull.class));
        filterFunction.body().decl(8, (JType)this.codeModel.ref(FilterExpressionWrapper.class).narrow(String.class), "forceImport", (JExpression)JExpr._new((JClass)this.codeModel.ref(FilterExpressionWrapper.class).narrow(String.class)).arg("").arg((JExpression)this.codeModel.ref(FilterFunction.class).staticRef("EQUALS")).arg(""));
        filterFunction.body()._return((JExpression)JExpr._new((JClass)this.codeModel.ref(ExpressionFluentHelper.class).narrow((JClass)generatedEntityClass)).arg(JExpr.direct((String)"new FilterExpressionWrapper<>(getFieldName() + \"/\" + filterExpression.getExpression().getFieldName(),filterExpression.getExpression().getOperator(),filterExpression.getExpression().getValue())")));
        filterFunction.javadoc().add((Object)"Query modifier to restrict the result set to entities for which this expression (formulated over a property of a <b>related</b> entity) evaluates to true. Note that filtering on a related entity does not expand the selection of the respective query to that entity.");
        filterFunction.javadoc().addParam(filterExpression).add((Object)"A filter expression on the related entity.");
        filterFunction.javadoc().addReturn().add((Object)"A filter expression over a related entity, scoped to the parent entity.");
        filterFunction.annotate(this.codeModel.ref(Nonnull.class));
        filterFunction.annotate(this.codeModel.ref(Override.class));
        return specificEntityOneToOneLink;
    }

    private JPackage getLinkSubPackage(JPackage namespacePackage) {
        return namespacePackage.subPackage(NAMESPACE_SUB_PACKAGE_NAME);
    }

    private void fillLinkClassJavadoc(JDefinedClass entityClass, JDocCommentable specificEntityLink) {
        specificEntityLink.javadoc().add((Object)String.format("Template class to represent entity navigation links of {@link %s %s} to other entities. Instances of this object are used in query modifier methods of the entity\nfluent helpers. Contains methods to compare a field's value with a provided value.\n\nUse the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData\nfield names, so use the constructor with caution.\n\n", entityClass.fullName(), entityClass.name()));
        specificEntityLink.javadoc().add((Object)"@param <ObjectT>\nEntity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.");
    }

    private void createLinkConstructor(JDefinedClass specificEntityLink) {
        JMethod specificEntityLinkConstructor = specificEntityLink.constructor(1);
        specificEntityLinkConstructor.javadoc().add((Object)"Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData field names, so use with caution.");
        JVar fieldNameParam = specificEntityLinkConstructor.param(8, (JType)this.codeModel.ref(String.class), "fieldName");
        specificEntityLinkConstructor.javadoc().addParam(fieldNameParam).append((Object)"OData navigation field name. Must match the field returned by the underlying OData service.");
        specificEntityLinkConstructor.body().invoke("super").arg((JExpression)fieldNameParam);
    }

    private void createLinkCopyConstructor(JDefinedClass specificEntityLink, JClass entityLinkExtension) {
        JMethod cloneConstructor = specificEntityLink.constructor(4);
        JVar toCloneParam = cloneConstructor.param(8, (JType)entityLinkExtension, "toClone");
        cloneConstructor.body().invoke("super").arg((JExpression)toCloneParam);
    }

    private void createTranslateLinkTypeMethod(JDefinedClass specificEntityLink, JTypeVar objectT, JClass entityLinkExtension) {
        JMethod linkTranslateMethod = specificEntityLink.method(2, (JType)specificEntityLink.narrow((JClass)objectT), "translateLinkType");
        JVar linkParam = linkTranslateMethod.param(8, (JType)entityLinkExtension, NAMESPACE_SUB_PACKAGE_NAME);
        linkTranslateMethod.annotate(Nonnull.class);
        linkTranslateMethod.annotate(Override.class);
        linkTranslateMethod.body()._return((JExpression)JExpr._new((JClass)specificEntityLink.narrow((JClass)objectT)).arg((JExpression)linkParam));
    }
}

