/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import lombok.Generated;

class EntityFieldGenerator {
    private static final String NAMESPACE_SUB_PACKAGE_NAME = "field";
    private final JCodeModel codeModel;

    JDefinedClass generateSpecificEntityFieldClass(JPackage namespacePackage, JDefinedClass entityClass, JDefinedClass selectableInterface) throws JClassAlreadyExistsException {
        String entityClassName = entityClass.name();
        JPackage fieldSubPackage = namespacePackage.subPackage(NAMESPACE_SUB_PACKAGE_NAME);
        JDefinedClass specificEntityField = fieldSubPackage._class(1, entityClassName + "Field");
        JTypeVar fieldT = specificEntityField.generify("FieldT");
        specificEntityField._extends(this.codeModel.ref(EntityField.class).narrow(new JClass[]{entityClass, fieldT}));
        specificEntityField._implements((JClass)selectableInterface);
        specificEntityField.javadoc().add((Object)String.format("Template class to represent entity fields of the Entity {@link %s %s}. Instances of this object are used in query modifier methods of the entity\nfluent helpers. Contains methods to compare a field's value with a provided value.\n\nUse the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData\nfield names, so use the constructor with caution.\n\n", entityClass.fullName(), entityClass.name()));
        specificEntityField.javadoc().add((Object)"@param <FieldT>\nField type");
        JMethod specificEntityFieldConstructor = specificEntityField.constructor(1);
        specificEntityFieldConstructor.javadoc().add((Object)"Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData field names, so use with caution.");
        JVar fieldNameParam = specificEntityFieldConstructor.param(8, (JType)this.codeModel.ref(String.class), "fieldName");
        specificEntityFieldConstructor.javadoc().addParam(fieldNameParam).append((Object)"OData field name. Must match the field returned by the underlying OData service.");
        specificEntityFieldConstructor.body().invoke("super").arg((JExpression)fieldNameParam);
        JMethod constructorWithTypeConverter = specificEntityField.constructor(1);
        constructorWithTypeConverter.javadoc().add((Object)"Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData field names, so use with caution.");
        constructorWithTypeConverter.javadoc().add((Object)"When creating instances for custom fields, this constructor can be used to add a type converter that will be automatically used by the respective entity when getting or setting custom fields.");
        JVar fieldNameParam2 = constructorWithTypeConverter.param(8, (JType)this.codeModel.ref(String.class), "fieldName");
        constructorWithTypeConverter.javadoc().addParam(fieldNameParam).append((Object)"OData field name. Must match the field returned by the underlying OData service.");
        JVar typeConverterParam = constructorWithTypeConverter.param(8, (JType)this.codeModel.ref(TypeConverter.class).narrow(new JClass[]{fieldT, this.codeModel.wildcard()}), "typeConverter");
        constructorWithTypeConverter.javadoc().addParam(typeConverterParam).append((Object)"An implementation of a TypeConverter. The first type must match FieldT, the second type must match the type Olingo returns.");
        constructorWithTypeConverter.body().invoke("super").arg((JExpression)fieldNameParam2).arg((JExpression)typeConverterParam);
        return specificEntityField;
    }

    @Generated
    public EntityFieldGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }
}

