/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.Multiplicity;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odata.generator.TypeKind;
import java.util.Collection;
import org.apache.olingo.odata2.api.edm.EdmAnnotationElement;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;

class EdmUtils {
    EdmUtils() {
    }

    static Multiplicity convertMultiplicity(EdmMultiplicity multiplicity) {
        switch (multiplicity) {
            case MANY: {
                return Multiplicity.MANY;
            }
            case ONE: {
                return Multiplicity.ONE;
            }
            case ZERO_TO_ONE: {
                return Multiplicity.ZERO_TO_ONE;
            }
        }
        throw new ODataGeneratorException("Encountered unknown multiplicity: " + multiplicity);
    }

    static TypeKind convertTypeKind(EdmTypeKind typeKind) {
        switch (typeKind) {
            case SIMPLE: {
                return TypeKind.SIMPLE;
            }
            case COMPLEX: {
                return TypeKind.COMPLEX;
            }
            case ENTITY: {
                return TypeKind.ENTITY;
            }
        }
        throw new ODataGeneratorException("Encountered unknown type kind: " + typeKind);
    }

    static EdmAnnotationElement getDocumentationElement(Collection<EdmAnnotationElement> annotationElements) {
        if (annotationElements != null && !annotationElements.isEmpty()) {
            for (EdmAnnotationElement element : annotationElements) {
                if (!element.getName().equals("Documentation")) continue;
                return element;
            }
        }
        return null;
    }
}

