/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.sap.cloud.sdk.datamodel.odata.generator.ApiFunction;
import com.sap.cloud.sdk.datamodel.odata.generator.EdmUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.Multiplicity;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorReadException;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceDetails;
import com.sap.cloud.sdk.datamodel.odata.generator.TypeKind;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingUtils;
import io.vavr.control.Option;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotationAttribute;
import org.apache.olingo.odata2.api.edm.EdmAnnotationElement;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmElement;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmParameter;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.core.edm.EdmDateTime;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.edm.EdmTime;
import org.slf4j.Logger;

class EdmService
implements Service {
    private static final Logger logger = MessageCollector.getLogger(EdmService.class);
    private static final String sapNamespace = "http://www.sap.com/Protocols/SAPData";
    private final String name;
    private final PropertiesConfiguration serviceNameMappings;
    private final ServiceDetails details;
    private final Function<String, Collection<ApiFunction>> allowedFunctionsByEntity;
    private final boolean linkToApiBusinessHub;
    private final Map<String, Service.EntitySet> entitySets = new LinkedHashMap<String, Service.EntitySet>();
    private final Map<String, Service.FunctionImport> functionImports = new LinkedHashMap<String, Service.FunctionImport>();

    EdmService(@Nonnull String name, @Nonnull PropertiesConfiguration serviceNameMappings, @Nonnull Edm metadata, @Nonnull ServiceDetails details, @Nonnull Multimap<String, ApiFunction> allowedFunctionsByEntity, boolean linkToApiBusinessHub) {
        this.name = name;
        this.serviceNameMappings = serviceNameMappings;
        this.details = details;
        this.allowedFunctionsByEntity = arg_0 -> allowedFunctionsByEntity.get(arg_0);
        this.linkToApiBusinessHub = linkToApiBusinessHub;
        try {
            for (EdmEntitySet entitySet : metadata.getEntitySets()) {
                this.entitySets.put(entitySet.getName(), new EntitySetAdapter(entitySet));
            }
            for (EdmFunctionImport value : metadata.getFunctionImports()) {
                this.functionImports.put(value.getName(), new FunctionImportAdapter(value));
            }
        }
        catch (EdmException e) {
            throw new ODataGeneratorReadException(e);
        }
    }

    @Override
    public String getTitle() {
        ServiceDetails.Info swaggerInfo = this.details.getInfo();
        if (swaggerInfo != null && !Strings.isNullOrEmpty((String)swaggerInfo.getTitle())) {
            return swaggerInfo.getTitle();
        }
        return NamingUtils.apiNameToServiceTitle((String)this.name);
    }

    @Override
    public boolean isDeprecated() {
        return this.details.isDeprecated();
    }

    @Override
    public Option<Service.DeprecationInfo> getDeprecationInfo() {
        if (this.isDeprecated()) {
            return this.details.getStateInfo().map(DefaultDeprecationInfo::new);
        }
        return Option.none();
    }

    @Override
    public String getServiceUrl() {
        return this.details.getServiceUrl();
    }

    @Override
    public Service.EntitySet getEntitySet(String entitySetName) {
        return this.entitySets.get(entitySetName);
    }

    @Override
    public Collection<Service.EntitySet> getAllEntitySets() {
        return this.entitySets.values();
    }

    @Override
    public Service.FunctionImport getFunctionImport(String functionImportName) {
        return this.functionImports.get(functionImportName);
    }

    @Override
    public Collection<Service.FunctionImport> getAllFunctionImports() {
        return this.functionImports.values();
    }

    @Override
    public String getJavaPackageName() {
        String javaPackageNameKey = this.name + ".packageName";
        String javaPackageName = this.serviceNameMappings.getString(javaPackageNameKey);
        if (javaPackageName == null) {
            javaPackageName = NamingUtils.serviceNameToJavaPackageName((String)this.getTitle());
        }
        return javaPackageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJavaClassName() {
        String javaClassNameKey = this.name + ".className";
        String javaClassName = this.serviceNameMappings.getString(javaClassNameKey);
        if (javaClassName == null) {
            javaClassName = NamingUtils.serviceNameToBaseJavaClassName((String)this.getTitle());
        }
        return javaClassName;
    }

    @Override
    public String getInfoDescription() {
        if (this.details.getInfo() == null) {
            return null;
        }
        return this.details.getInfo().getDescription();
    }

    @Override
    public String getInfoVersion() {
        if (this.details.getInfo() == null) {
            return null;
        }
        return this.details.getInfo().getVersion();
    }

    @Override
    public String getMinErpVersion() {
        return this.details.getMinErpVersion();
    }

    @Override
    public String getExternalUrl() {
        if (this.details.getExternalDocs() == null) {
            return null;
        }
        return this.details.getExternalDocs().getUrl();
    }

    @Override
    public String getExternalDescription() {
        if (this.details.getExternalDocs() == null) {
            return null;
        }
        return this.details.getExternalDocs().getDescription();
    }

    @Override
    public Collection<ApiFunction> getAllowedFunctionsByEntity(String entity) {
        return this.allowedFunctionsByEntity.apply(entity);
    }

    @Override
    public boolean hasLinkToApiBusinessHub() {
        return this.linkToApiBusinessHub;
    }

    public List<Service.ExternalOverview> getExternalOverview() {
        List<? extends ServiceDetails.ExternalOverview> input = this.details.getExtOverview();
        if (input == null) {
            return null;
        }
        ArrayList<Service.ExternalOverview> result = new ArrayList<Service.ExternalOverview>(input.size());
        for (ServiceDetails.ExternalOverview externalOverview : input) {
            result.add(new ExternalOverviewAdapter(externalOverview));
        }
        return result;
    }

    private static Service.Type convertType(@Nonnull EdmType type) {
        if (type instanceof EdmSimpleType) {
            return new SimpleTypeAdapter((EdmSimpleType)type);
        }
        if (type instanceof EdmEntityType) {
            return new EntityTypeAdapter((EdmEntityType)type);
        }
        if (type instanceof EdmComplexType) {
            return new ComplexTypeAdapter((EdmStructuralType)type);
        }
        throw new ODataGeneratorException("Found unknown EdmType implementation: " + type.getClass());
    }

    private static Service.Typed convertTyped(@Nonnull EdmTyped typed) {
        if (typed instanceof EdmProperty) {
            return new PropertyAdapter((EdmProperty)typed);
        }
        if (typed instanceof EdmParameter) {
            return new ParameterAdapter((EdmParameter)typed);
        }
        if (typed instanceof EdmNavigationProperty) {
            return new NavigationPropertyAdapter(typed);
        }
        throw new ODataGeneratorException("Found unknown EdmTyped implementation: " + typed.getClass());
    }

    private static Service.AnnotationElement getDocumentationElement(EdmAnnotatable annotatable) {
        List annotationElements;
        try {
            annotationElements = annotatable.getAnnotations().getAnnotationElements();
        }
        catch (EdmException e) {
            throw new ODataGeneratorReadException(e);
        }
        EdmAnnotationElement documentationElement = EdmUtils.getDocumentationElement(annotationElements);
        if (documentationElement == null) {
            return null;
        }
        return new AnnotationElementAdapter(documentationElement);
    }

    private static String getLabel(EdmAnnotations annotations) {
        String attributeName = "label";
        return EdmService.getAttributeText(annotations, "label");
    }

    private static String getQuickInfo(EdmAnnotations annotations) {
        String attributeName = "quickinfo";
        return EdmService.getAttributeText(annotations, "quickinfo");
    }

    private static String getAttributeText(EdmAnnotations annotations, String attributeName) {
        EdmAnnotationAttribute attribute = annotations.getAnnotationAttribute(attributeName, sapNamespace);
        if (attribute == null) {
            return null;
        }
        return attribute.getText();
    }

    @Nonnull
    @Generated
    public String toString() {
        return "EdmService(name=" + this.getName() + ", serviceNameMappings=" + this.serviceNameMappings + ", details=" + this.details + ", allowedFunctionsByEntity=" + this.allowedFunctionsByEntity + ", linkToApiBusinessHub=" + this.linkToApiBusinessHub + ", entitySets=" + this.entitySets + ", functionImports=" + this.functionImports + ")";
    }

    private static class DefaultDeprecationInfo
    implements Service.DeprecationInfo {
        @Nonnull
        private final ServiceDetails.StateInfo details;

        @Override
        public Option<String> getSuccessorApi() {
            return Option.of((Object)this.details.getSuccessorApi());
        }

        @Override
        public Option<String> getDeprecationDate() {
            return Option.of((Object)this.details.getDeprecationDate());
        }

        @Override
        public Option<String> getDeprecationRelease() {
            return Option.of((Object)this.details.getDeprecationRelease());
        }

        @Generated
        public DefaultDeprecationInfo(@Nonnull ServiceDetails.StateInfo details) {
            if (details == null) {
                throw new NullPointerException("details is marked non-null but is null");
            }
            this.details = details;
        }
    }

    private static final class NavigationPropertyAdapter
    extends TypedAdapter {
        NavigationPropertyAdapter(EdmTyped edmTyped) {
            super(edmTyped);
        }
    }

    private static final class PropertyAdapter
    extends ElementAdapter
    implements Service.Property {
        private final EdmProperty edmProperty;

        private PropertyAdapter(@Nonnull EdmProperty edmProperty) {
            super((EdmElement)edmProperty);
            this.edmProperty = edmProperty;
        }

        @Override
        public String getLabel() {
            try {
                return EdmService.getLabel(this.edmProperty.getAnnotations());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getQuickInfo() {
            try {
                return EdmService.getQuickInfo(this.edmProperty.getAnnotations());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.AnnotationElement getDocumentationElement() {
            return EdmService.getDocumentationElement((EdmAnnotatable)this.edmProperty);
        }
    }

    private static abstract class ElementAdapter
    extends TypedAdapter
    implements Service.Element {
        private final EdmElement edmElement;

        ElementAdapter(@Nonnull EdmElement edmElement) {
            super((EdmTyped)edmElement);
            this.edmElement = edmElement;
        }

        @Override
        public Service.Facets getFacets() {
            EdmFacets facets;
            try {
                facets = this.edmElement.getFacets();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
            if (facets == null) {
                return null;
            }
            return new FacetsAdapter(facets);
        }
    }

    private static final class EntityTypeAdapter
    extends StructuralTypeAdapter
    implements Service.EntityType {
        private final EdmEntityType entityType;

        private EntityTypeAdapter(EdmEntityType entityType) {
            super((EdmStructuralType)entityType);
            this.entityType = entityType;
        }

        @Override
        public Collection<String> getKeyPropertyNames() {
            try {
                return this.entityType.getKeyPropertyNames();
            }
            catch (EdmException e) {
                logger.info("Entity type \"" + this.entityType + "\" does not define a key.");
                return Collections.emptyList();
            }
        }

        @Override
        public Collection<String> getNavigationPropertyNames() {
            try {
                return this.entityType.getNavigationPropertyNames();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public boolean hasMediaStream() {
            try {
                return this.entityType.hasStream();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
    }

    private static final class ComplexTypeAdapter
    extends StructuralTypeAdapter
    implements Service.ComplexType {
        private ComplexTypeAdapter(EdmStructuralType edmComplexType) {
            super(edmComplexType);
        }
    }

    private static final class SimpleTypeAdapter
    extends TypeAdapter
    implements Service.SimpleType {
        private final EdmSimpleType simpleType;

        private SimpleTypeAdapter(EdmSimpleType simpleType) {
            super((EdmType)simpleType);
            this.simpleType = simpleType;
        }

        @Override
        public Class<?> getDefaultType() {
            if (this.simpleType instanceof EdmDateTime) {
                return LocalDateTime.class;
            }
            if (this.simpleType instanceof EdmTime) {
                return LocalTime.class;
            }
            if (this.simpleType instanceof EdmDateTimeOffset) {
                return ZonedDateTime.class;
            }
            return this.simpleType.getDefaultType();
        }
    }

    private static abstract class StructuralTypeAdapter
    extends TypeAdapter
    implements Service.StructuralType {
        private final EdmStructuralType edmStructuralType;

        StructuralTypeAdapter(@Nonnull EdmStructuralType edmStructuralType) {
            super((EdmType)edmStructuralType);
            this.edmStructuralType = edmStructuralType;
        }

        @Override
        public String getLabel() {
            try {
                return EdmService.getLabel(this.edmStructuralType.getAnnotations());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getQuickInfo() {
            try {
                return EdmService.getQuickInfo(this.edmStructuralType.getAnnotations());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.AnnotationElement getDocumentationElement() {
            return EdmService.getDocumentationElement((EdmAnnotatable)this.edmStructuralType);
        }

        @Override
        public Collection<String> getPropertyNames() {
            try {
                return this.edmStructuralType.getPropertyNames();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Typed getProperty(String propertyName) {
            try {
                return EdmService.convertTyped(this.edmStructuralType.getProperty(propertyName));
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getName() {
            try {
                return this.edmStructuralType.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
    }

    private static final class AnnotationElementAdapter
    implements Service.AnnotationElement {
        private final EdmAnnotationElement edmAnnotationElement;

        private AnnotationElementAdapter(@Nonnull EdmAnnotationElement edmAnnotationElement) {
            this.edmAnnotationElement = edmAnnotationElement;
        }

        @Override
        public Iterable<? extends Service.AnnotationElement> getChildElements() {
            List input = this.edmAnnotationElement.getChildElements();
            ArrayList<AnnotationElementAdapter> result = new ArrayList<AnnotationElementAdapter>(input.size());
            for (EdmAnnotationElement value : input) {
                result.add(new AnnotationElementAdapter(value));
            }
            return result;
        }

        @Override
        public String getText() {
            return this.edmAnnotationElement.getText();
        }

        @Override
        public String getName() {
            return this.edmAnnotationElement.getName();
        }
    }

    private static final class FacetsAdapter
    implements Service.Facets {
        private final EdmFacets edmFacets;

        private FacetsAdapter(@Nonnull EdmFacets edmFacets) {
            this.edmFacets = edmFacets;
        }

        @Override
        public Boolean isNullable() {
            return this.edmFacets.isNullable();
        }

        @Override
        public String getDefaultValue() {
            return this.edmFacets.getDefaultValue();
        }

        @Override
        public Integer getMaxLength() {
            return this.edmFacets.getMaxLength();
        }

        @Override
        public Integer getPrecision() {
            return this.edmFacets.getPrecision();
        }

        @Override
        public Integer getScale() {
            return this.edmFacets.getScale();
        }
    }

    private static final class ParameterAdapter
    extends ElementAdapter
    implements Service.Parameter {
        private final EdmParameter edmParameter;

        private ParameterAdapter(@Nonnull EdmParameter edmParameter) {
            super((EdmElement)edmParameter);
            this.edmParameter = edmParameter;
        }

        @Override
        public String getLabel() {
            try {
                return EdmService.getLabel(this.edmParameter.getAnnotations());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getQuickInfo() {
            try {
                return EdmService.getQuickInfo(this.edmParameter.getAnnotations());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.AnnotationElement getDocumentationElement() {
            return EdmService.getDocumentationElement((EdmAnnotatable)this.edmParameter);
        }

        @Override
        public Service.Type getType() {
            try {
                return EdmService.convertType(this.edmParameter.getType());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Multiplicity getMultiplicity() {
            try {
                return EdmUtils.convertMultiplicity(this.edmParameter.getMultiplicity());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
    }

    private static abstract class TypeAdapter
    implements Service.Type {
        private final EdmType edmType;

        TypeAdapter(@Nonnull EdmType edmType) {
            this.edmType = edmType;
        }

        @Override
        public TypeKind getKind() {
            return EdmUtils.convertTypeKind(this.edmType.getKind());
        }

        @Override
        public String getName() {
            try {
                return this.edmType.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
    }

    private static final class FunctionImportAdapter
    implements Service.FunctionImport {
        private final EdmFunctionImport functionImport;

        private FunctionImportAdapter(@Nonnull EdmFunctionImport functionImport) {
            this.functionImport = functionImport;
        }

        @Override
        public String getName() {
            try {
                return this.functionImport.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getLabel() {
            try {
                return EdmService.getLabel(this.functionImport.getAnnotations());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getQuickInfo() {
            try {
                return EdmService.getQuickInfo(this.functionImport.getAnnotations());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.AnnotationElement getDocumentationElement() {
            return EdmService.getDocumentationElement((EdmAnnotatable)this.functionImport);
        }

        @Override
        @Nullable
        public Service.Type getReturnType() {
            try {
                EdmTyped returnType = this.functionImport.getReturnType();
                if (returnType == null) {
                    return null;
                }
                return EdmService.convertType(returnType.getType());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        @Nullable
        public Multiplicity getReturnTypeMultiplicity() {
            try {
                EdmTyped returnType = this.functionImport.getReturnType();
                if (returnType == null) {
                    return null;
                }
                return EdmUtils.convertMultiplicity(returnType.getMultiplicity());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getHttpMethod() {
            try {
                return this.functionImport.getHttpMethod();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Collection<String> getParameterNames() {
            try {
                return this.functionImport.getParameterNames();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Parameter getParameter(String parameterName) {
            try {
                return new ParameterAdapter(this.functionImport.getParameter(parameterName));
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
    }

    private static abstract class TypedAdapter
    implements Service.Typed {
        private final EdmTyped edmTyped;

        TypedAdapter(@Nonnull EdmTyped edmTyped) {
            this.edmTyped = edmTyped;
        }

        @Override
        public Service.Type getType() {
            try {
                return EdmService.convertType(this.edmTyped.getType());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Multiplicity getMultiplicity() {
            try {
                return EdmUtils.convertMultiplicity(this.edmTyped.getMultiplicity());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
    }

    private static final class EntitySetAdapter
    implements Service.EntitySet {
        private final EdmEntitySet entitySet;

        private EntitySetAdapter(@Nonnull EdmEntitySet entitySet) {
            this.entitySet = entitySet;
        }

        @Override
        public Service.EntityType getEntityType() {
            try {
                return new EntityTypeAdapter(this.entitySet.getEntityType());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getName() {
            try {
                return this.entitySet.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
    }

    private static final class ExternalOverviewAdapter
    implements Service.ExternalOverview {
        private final ServiceDetails.ExternalOverview overview;

        private ExternalOverviewAdapter(@Nonnull ServiceDetails.ExternalOverview overview) {
            this.overview = overview;
        }

        @Override
        public String getName() {
            return this.overview.getName();
        }

        @Override
        public List<String> getValues() {
            return this.overview.getValues();
        }
    }
}

