/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.DefaultServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.DeprecationUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.JavadocUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchGenerator;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import javax.annotation.Nonnull;
import lombok.Generated;

class DefaultServiceBatchGenerator {
    private static final String SERVICE_FIELD_NAME = "service";
    private final JCodeModel codeModel;

    ClassStub createDefaultImplementation(JClassContainer targetPackage, JDefinedClass basicServiceClass, ServiceBatchGenerator.InterfaceStub batchServiceStub, ServiceBatchChangeSetGenerator.InterfaceStub changeSetStub, Service service) throws JClassAlreadyExistsException {
        JDefinedClass interfaceToImplement = batchServiceStub.getServiceBatchStub();
        JDefinedClass changeSetInterface = changeSetStub.getServiceBatchChangeSetStub();
        JDefinedClass defaultImplementation = this.createClassHeader(targetPackage, interfaceToImplement, changeSetInterface, basicServiceClass);
        this.createBasicServiceField(defaultImplementation, basicServiceClass, service);
        this.createConstructor(defaultImplementation, basicServiceClass, service);
        this.implementGetServicePathForBatchRequestMethod(defaultImplementation, basicServiceClass, service);
        this.implementGetThisMethod(defaultImplementation);
        return new ClassStub(defaultImplementation);
    }

    private void implementGetThisMethod(JDefinedClass defaultImplementation) {
        JMethod createdMethod = defaultImplementation.method(2, (JType)defaultImplementation, "getThis");
        createdMethod.annotate(Nonnull.class);
        createdMethod.annotate(Override.class);
        createdMethod.body()._return(JExpr._this());
        JavadocUtils.inheritJavadoc((JDocCommentable)createdMethod);
    }

    private void implementGetServicePathForBatchRequestMethod(JDefinedClass defaultImplementation, JDefinedClass basicServiceClass, Service service) {
        JMethod createdMethod = defaultImplementation.method(2, String.class, "getServicePathForBatchRequest");
        createdMethod.annotate(Nonnull.class);
        createdMethod.annotate(Override.class);
        DeprecationUtils.addGetDefaultServicePathBody(createdMethod, basicServiceClass, service);
        JavadocUtils.inheritJavadoc((JDocCommentable)createdMethod);
    }

    private void implementBeginChangeSetMethod(JDefinedClass defaultImplementation, JDefinedClass changeSetInterface, JDefinedClass changeSetImplementation) {
        JMethod createdMethod = defaultImplementation.method(1, (JType)changeSetInterface, "beginChangeSet");
        createdMethod.annotate(Nonnull.class);
        createdMethod.annotate(Override.class);
        createdMethod.body()._return((JExpression)JExpr._new((JClass)changeSetImplementation).arg(JExpr._this()).arg((JExpression)JExpr.ref((String)SERVICE_FIELD_NAME)));
        JavadocUtils.inheritJavadoc((JDocCommentable)createdMethod);
    }

    private JDefinedClass createClassHeader(JClassContainer targetPackage, JDefinedClass interfaceToImplement, JDefinedClass changeSetInterface, JDefinedClass basicServiceClass) throws JClassAlreadyExistsException {
        JDefinedClass defaultImplementation = targetPackage._class(1, this.createClassName(interfaceToImplement));
        defaultImplementation._extends(this.codeModel.ref(BatchFluentHelperBasic.class).narrow(new JClass[]{interfaceToImplement, changeSetInterface}));
        defaultImplementation._implements((JClass)interfaceToImplement);
        defaultImplementation.javadoc().add((Object)String.format("Default implementation of the {@link %s} interface exposed in the {@link %s %s}, allowing you to create multiple changesets and finally execute the batch request.", interfaceToImplement.name(), basicServiceClass.fullName(), basicServiceClass.name()));
        return defaultImplementation;
    }

    private void createBasicServiceField(JDefinedClass defaultImplementation, JDefinedClass basicServiceClass, Service service) {
        DeprecationUtils.createBasicServiceInterfaceField(defaultImplementation, basicServiceClass, SERVICE_FIELD_NAME, service);
    }

    private void createConstructor(JDefinedClass defaultImplementation, JDefinedClass basicServiceClass, Service service) {
        if (service.isDeprecated()) {
            this.createConstructorForDeprecatedService(defaultImplementation, basicServiceClass);
        } else {
            this.createConstructorForSupportedService(defaultImplementation, basicServiceClass);
        }
    }

    private void createConstructorForSupportedService(JDefinedClass defaultImplementation, JDefinedClass basicServiceClass) {
        JMethod constructor = defaultImplementation.constructor(1);
        JVar param = constructor.param(8, (JType)basicServiceClass, SERVICE_FIELD_NAME);
        param.annotate(Nonnull.class);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)SERVICE_FIELD_NAME), (JExpression)param);
        constructor.javadoc().add((Object)String.format("Creates a new instance of this %s.", defaultImplementation.name()));
        constructor.javadoc().addParam(param).add((Object)"The service to execute all operations in this changeset on.");
    }

    private void createConstructorForDeprecatedService(JDefinedClass defaultImplementation, JDefinedClass basicServiceClass) {
        defaultImplementation.direct("\n    /**\n     * Creates a new instance of this " + defaultImplementation.name() + "\n" + "    " + " *\n" + "    " + " * @param service\n" + "    " + " * The service to execute all operations in this changeset on.\n" + "    " + " */\n" + "    " + "@SuppressWarnings( \"deprecation\" )\n" + "    " + "public " + defaultImplementation.name() + "(@Nonnull final " + basicServiceClass.fullName() + " " + SERVICE_FIELD_NAME + "){\n" + "    " + "    " + "this." + SERVICE_FIELD_NAME + " = " + SERVICE_FIELD_NAME + ";\n" + "    " + "}");
    }

    private String createClassName(JDefinedClass interfaceName) {
        return "Default" + interfaceName.name();
    }

    @Generated
    DefaultServiceBatchGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    final class ClassStub {
        private final JDefinedClass defaultServiceBatchStub;

        void implementBeginChangeSetMethod(ServiceBatchChangeSetGenerator.InterfaceStub changeSetStub, DefaultServiceBatchChangeSetGenerator.ClassStub implementationStub) {
            DefaultServiceBatchGenerator.this.implementBeginChangeSetMethod(this.defaultServiceBatchStub, changeSetStub.getServiceBatchChangeSetStub(), implementationStub.getDefaultBatchChangeSetStub());
        }

        @Generated
        private ClassStub(JDefinedClass defaultServiceBatchStub) {
            this.defaultServiceBatchStub = defaultServiceBatchStub;
        }

        @Generated
        JDefinedClass getDefaultServiceBatchStub() {
            return this.defaultServiceBatchStub;
        }
    }
}

