/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.DefaultServiceBatchGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.DeprecationUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.JavadocUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchGenerator;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import javax.annotation.Nonnull;
import lombok.Generated;

class DefaultServiceBatchChangeSetGenerator {
    private static final String SERVICE_FIELD_NAME = "service";
    private final JCodeModel codeModel;

    ClassStub createDefaultImplementation(JClassContainer targetPackage, JDefinedClass basicServiceClass, ServiceBatchChangeSetGenerator.InterfaceStub interfaceToImplement, ServiceBatchGenerator.InterfaceStub serviceBatchInterface, DefaultServiceBatchGenerator.ClassStub serviceBatchImplementation, Service service) throws JClassAlreadyExistsException {
        JDefinedClass changeSetInterface = interfaceToImplement.getServiceBatchChangeSetStub();
        JDefinedClass batchInterface = serviceBatchInterface.getServiceBatchStub();
        JDefinedClass batchImplementation = serviceBatchImplementation.getDefaultServiceBatchStub();
        JDefinedClass defaultImplementation = this.createClassHeader(targetPackage, basicServiceClass, batchInterface, changeSetInterface);
        this.createBasicServiceField(defaultImplementation, basicServiceClass, service);
        this.createConstructor(defaultImplementation, batchImplementation, basicServiceClass, service);
        this.implementGetThisMethod(defaultImplementation);
        return new ClassStub(defaultImplementation);
    }

    private JDefinedClass createClassHeader(JClassContainer targetPackage, JDefinedClass basicServiceClass, JDefinedClass batchInterface, JDefinedClass changeSetInterface) throws JClassAlreadyExistsException {
        JDefinedClass defaultImplementation = targetPackage._class(1, this.createClassName(changeSetInterface));
        defaultImplementation._extends(this.codeModel.ref(BatchChangeSetFluentHelperBasic.class).narrow(new JClass[]{batchInterface, changeSetInterface}));
        defaultImplementation._implements((JClass)changeSetInterface);
        defaultImplementation.javadoc().add((Object)String.format("Implementation of the {@link %s} interface, enabling you to combine multiple operations into one changeset. For further information have a look into the {@link %s %s}.", changeSetInterface.name(), basicServiceClass.fullName(), basicServiceClass.name()));
        return defaultImplementation;
    }

    private void createBasicServiceField(JDefinedClass defaultImplementation, JDefinedClass basicServiceClass, Service service) {
        DeprecationUtils.createBasicServiceInterfaceField(defaultImplementation, basicServiceClass, SERVICE_FIELD_NAME, service);
    }

    private void createConstructor(JDefinedClass defaultImplementation, JDefinedClass serviceBatchImplementation, JDefinedClass basicServiceInterface, Service service) {
        String fluentHelperParameterName = "batchFluentHelper";
        if (service.isDeprecated()) {
            this.createConstructorForDeprecatedService(defaultImplementation, serviceBatchImplementation, basicServiceInterface, "batchFluentHelper");
        } else {
            this.createConstructorForSupportedService(defaultImplementation, serviceBatchImplementation, basicServiceInterface, "batchFluentHelper");
        }
    }

    private void createConstructorForSupportedService(JDefinedClass defaultImplementation, JDefinedClass serviceBatchImplementation, JDefinedClass basicServiceInterface, String fluentHelperParameterName) {
        JMethod constructor = defaultImplementation.constructor(0);
        JVar fluentHelperParam = constructor.param(8, (JType)serviceBatchImplementation, fluentHelperParameterName);
        JVar serviceParam = constructor.param(8, (JType)basicServiceInterface, SERVICE_FIELD_NAME);
        serviceParam.annotate(Nonnull.class);
        fluentHelperParam.annotate(Nonnull.class);
        constructor.body().invoke("super").arg((JExpression)fluentHelperParam).arg((JExpression)fluentHelperParam);
        constructor.body().assign((JAssignmentTarget)JExpr.refthis((String)SERVICE_FIELD_NAME), (JExpression)serviceParam);
    }

    private void createConstructorForDeprecatedService(JDefinedClass defaultImplementation, JDefinedClass serviceBatchImplementation, JDefinedClass basicServiceInterface, String fluentHelperParameterName) {
        defaultImplementation.direct("\n    @SuppressWarnings( \"deprecation\" )\n    " + defaultImplementation.name() + "(\n" + "    " + "    " + "@Nonnull final " + serviceBatchImplementation.name() + " " + fluentHelperParameterName + ",\n" + "    " + "    " + "@Nonnull final " + basicServiceInterface.fullName() + " " + SERVICE_FIELD_NAME + " )\n" + "    " + "{\n" + "    " + "    " + "super(" + fluentHelperParameterName + ", " + fluentHelperParameterName + ");\n" + "    " + "    " + "this." + SERVICE_FIELD_NAME + " = " + SERVICE_FIELD_NAME + ";\n" + "    " + "}");
    }

    private void implementGetThisMethod(JDefinedClass defaultImplementation) {
        JMethod createdMethod = defaultImplementation.method(2, (JType)defaultImplementation, "getThis");
        createdMethod.body()._return(JExpr._this());
        createdMethod.annotate(Nonnull.class);
        createdMethod.annotate(Override.class);
        JavadocUtils.inheritJavadoc((JDocCommentable)createdMethod);
    }

    private void addCreateMethodImplementation(JDefinedClass classToBeAdjusted, JMethod basicServiceMethodToCall, JMethod interfaceMethodToOverride) {
        this.addMethodImplementation(classToBeAdjusted, "addRequestCreate", basicServiceMethodToCall, interfaceMethodToOverride);
    }

    private void addUpdateMethodImplementation(JDefinedClass classToBeAdjusted, JMethod basicServiceMethodToCall, JMethod interfaceMethodToOverride) {
        this.addMethodImplementation(classToBeAdjusted, "addRequestUpdate", basicServiceMethodToCall, interfaceMethodToOverride);
    }

    private void addDeleteMethodImplementation(JDefinedClass classToBeAdjusted, JMethod basicServiceMethodToCall, JMethod interfaceMethodToOverride) {
        this.addMethodImplementation(classToBeAdjusted, "addRequestDelete", basicServiceMethodToCall, interfaceMethodToOverride);
    }

    private void addMethodImplementation(JDefinedClass classToBeAdjusted, String wrapperMethod, JMethod basicServiceMethodToCall, JMethod interfaceMethodToOverride) {
        JMethod createdMethod = classToBeAdjusted.method(1, interfaceMethodToOverride.type(), interfaceMethodToOverride.name());
        createdMethod.annotate(Nonnull.class);
        createdMethod.annotate(Override.class);
        if (interfaceMethodToOverride.params().size() != 1) {
            throw new ODataGeneratorException("The list of parameter is expected to only contain the single entity to process, but it contained " + interfaceMethodToOverride.params().size() + " parameter.");
        }
        JVar paramToCopy = (JVar)interfaceMethodToOverride.params().get(0);
        JVar entityParam = createdMethod.param(paramToCopy.mods().getValue(), paramToCopy.type(), paramToCopy.name());
        entityParam.annotate(Nonnull.class);
        createdMethod.body()._return((JExpression)JExpr.invoke((String)wrapperMethod).arg((JExpression)this.createServiceMethodReference(basicServiceMethodToCall)).arg((JExpression)entityParam));
        JavadocUtils.inheritJavadoc((JDocCommentable)createdMethod);
    }

    private JFieldRef createServiceMethodReference(JMethod basicServiceMethodToCall) {
        return JExpr.ref((String)("service::" + basicServiceMethodToCall.name()));
    }

    private String createClassName(JDefinedClass interfaceName) {
        return "Default" + interfaceName.name();
    }

    @Generated
    public DefaultServiceBatchChangeSetGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    final class ClassStub {
        private final JDefinedClass defaultBatchChangeSetStub;

        void addCreateMethodImplementation(JMethod basicServiceMethod, JMethod interfaceMethodToImplement) {
            DefaultServiceBatchChangeSetGenerator.this.addCreateMethodImplementation(this.defaultBatchChangeSetStub, basicServiceMethod, interfaceMethodToImplement);
        }

        void addUpdateMethodImplementation(JMethod basicServiceMethod, JMethod interfaceMethodToImplement) {
            DefaultServiceBatchChangeSetGenerator.this.addUpdateMethodImplementation(this.defaultBatchChangeSetStub, basicServiceMethod, interfaceMethodToImplement);
        }

        void addDeleteMethodImplementation(JMethod basicServiceMethod, JMethod interfaceMethodToImplement) {
            DefaultServiceBatchChangeSetGenerator.this.addDeleteMethodImplementation(this.defaultBatchChangeSetStub, basicServiceMethod, interfaceMethodToImplement);
        }

        @Generated
        private ClassStub(JDefinedClass defaultBatchChangeSetStub) {
            this.defaultBatchChangeSetStub = defaultBatchChangeSetStub;
        }

        @Generated
        JDefinedClass getDefaultBatchChangeSetStub() {
            return this.defaultBatchChangeSetStub;
        }
    }
}

