/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.sap.cloud.sdk.datamodel.odata.generator.ApiFunction;
import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.MetadataFileUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorReadException;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmAnnotationAttribute;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AllowedFunctionsResolver {
    private static final Logger logger = MessageCollector.getLogger(AllowedFunctionsResolver.class);
    private static final String ANNOTATIONS_ELEMENT_NAME = "Annotations";
    private static final String ANNOTATION_ELEMENT_NAME = "Annotation";
    private static final String RECORD_ELEMENT_NAME = "Record";
    private static final String PROPERTYVALUE_ELEMENT_NAME = "PropertyValue";
    private static final Pattern ANNOTATION_TARGET_PATTERN = Pattern.compile("^(.+)\\.([^./]+)(?:/(.+))?$");
    private static final String TARGET_ATTRIBUTE_NAME = "Target";
    private static final String PROPERTY_ATTRIBUTE_NAME = "Property";
    private static final String BOOL_ATTRIBUTE_NAME = "Bool";
    private static final String ADDRESSABLE_ATTRIBUTE_NAME = "addressable";
    private static final String CREATABLE_ATTRIBUTE_NAME = "creatable";
    private static final String DELETABLE_ATTRIBUTE_NAME = "deletable";
    private static final String UPDATABLE_ATTRIBUTE_NAME = "updatable";
    private static final String READABLE_PROPERTY_NAME = "readable";
    private static final String INSERTABLE_PROPERTY_NAME = "insertable";
    private static final String DELETABLE_PROPERTY_NAME = "deletable";
    private static final String UPDATABLE_PROPERTY_NAME = "updatable";
    private final Charset encoding;

    AllowedFunctionsResolver(Charset encoding) {
        this.encoding = encoding;
    }

    @Nonnull
    Multimap<String, ApiFunction> findAllowedFunctions(@Nonnull Edm metadata, @Nullable File swaggerFile, @Nullable File metadataFile) {
        Multimap<String, ApiFunction> allowedFunctionsByEntity = null;
        if (swaggerFile != null && swaggerFile.exists()) {
            allowedFunctionsByEntity = this.readFromSwaggerFile(swaggerFile);
        } else if (swaggerFile != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not find swagger file at " + swaggerFile.getAbsolutePath() + ". Trying to read the allowed functions from the metadata file.");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("No swagger file given. Trying to read the allowed functions from the metadata file.");
        }
        if (allowedFunctionsByEntity == null && metadataFile != null) {
            allowedFunctionsByEntity = this.readOdataSpecFromMetadataFile(metadataFile, metadata);
        }
        if (allowedFunctionsByEntity == null) {
            allowedFunctionsByEntity = this.readSAPSpecFromMetadataFile(metadata);
        }
        return allowedFunctionsByEntity;
    }

    @Nullable
    private Multimap<String, ApiFunction> readOdataSpecFromMetadataFile(@Nonnull File metadataFile, @Nonnull Edm metadataObject) {
        NodeList annotationsList = this.retrieveEdmxAnnotations(metadataFile);
        if (annotationsList.getLength() == 0) {
            return null;
        }
        Map<EntitySetName, Set<DefinedProperty>> definedPropertyPerEntitySet = this.determineDefinedPropertiesPerEntitySet(metadataObject, annotationsList);
        if (AllowedFunctionsResolver.containsNoProperties(definedPropertyPerEntitySet)) {
            return null;
        }
        return this.convertPropertiesToAllowedFunctions(metadataObject, definedPropertyPerEntitySet);
    }

    private NodeList retrieveEdmxAnnotations(@Nonnull File metadataFile) {
        Document doc = MetadataFileUtils.getMetadataDocumentObject(metadataFile);
        return doc.getElementsByTagName(ANNOTATIONS_ELEMENT_NAME);
    }

    private Multimap<String, ApiFunction> convertPropertiesToAllowedFunctions(@Nonnull Edm metadataObject, @Nonnull Map<EntitySetName, Set<DefinedProperty>> definedPropertyPerEntitySet) {
        SetMultimap allowedFunctionsByEntity = MultimapBuilder.hashKeys().hashSetValues().build();
        for (EntitySetName entitySetName : AllowedFunctionsResolver.getEntitySetNames(metadataObject)) {
            Set<ApiFunction> supportedFunctions = definedPropertyPerEntitySet.containsKey(entitySetName) ? this.determineSupportedFunctions((Collection<DefinedProperty>)definedPropertyPerEntitySet.get(entitySetName)) : this.getAllFunctions();
            allowedFunctionsByEntity.putAll((Object)entitySetName.get(), supportedFunctions);
        }
        return allowedFunctionsByEntity;
    }

    private static Set<EntitySetName> getEntitySetNames(Edm metadataObject) {
        try {
            return metadataObject.getEntitySets().stream().map(EntitySetName::of).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        catch (EdmException e) {
            throw new ODataGeneratorReadException("Could not access EntitySets.", e);
        }
    }

    private static boolean containsNoProperties(Map<EntitySetName, Set<DefinedProperty>> definedPropertyPerEntitySet) {
        return definedPropertyPerEntitySet.values().stream().allMatch(Set::isEmpty);
    }

    @Nonnull
    private Map<EntitySetName, Set<DefinedProperty>> determineDefinedPropertiesPerEntitySet(@Nonnull Edm metadataObject, NodeList annotationsList) {
        HashMap<EntitySetName, Set<DefinedProperty>> definedPropertyPerEntitySet = new HashMap<EntitySetName, Set<DefinedProperty>>();
        for (int i = 0; i < annotationsList.getLength(); ++i) {
            Node annotations = annotationsList.item(i);
            NamedNodeMap annotationsAttributeMap = annotations.getAttributes();
            Node entitySetTarget = annotationsAttributeMap.getNamedItem(TARGET_ATTRIBUTE_NAME);
            AnnotationTarget annotationTarget = AnnotationTarget.of(entitySetTarget.getNodeValue(), metadataObject);
            if (!annotationTarget.isTargetingEntitySet()) continue;
            EntitySetName entitySetName = annotationTarget.getEntitySet();
            Set alreadyKnownProperties = definedPropertyPerEntitySet.computeIfAbsent(entitySetName, key -> new LinkedHashSet());
            alreadyKnownProperties.addAll(this.readDefinedProperties(annotations));
        }
        return definedPropertyPerEntitySet;
    }

    private Set<ApiFunction> determineSupportedFunctions(@Nonnull Collection<DefinedProperty> definedProperties) {
        EnumSet<ApiFunction> supportedFunctions = EnumSet.allOf(ApiFunction.class);
        definedProperties.stream().map(DefinedProperty::determineUnsupportedFunction).filter(Option::isDefined).map(Option::get).forEach(supportedFunctions::remove);
        return supportedFunctions;
    }

    private Set<ApiFunction> getAllFunctions() {
        return Sets.newHashSet((Object[])ApiFunction.values());
    }

    @Nonnull
    private Set<DefinedProperty> readDefinedProperties(@Nonnull Node annotationsParent) {
        List<NodeList> annotations = this.getChildrenFromNodeList(ANNOTATION_ELEMENT_NAME, annotationsParent.getChildNodes());
        LinkedHashSet<DefinedProperty> definedProperties = new LinkedHashSet<DefinedProperty>();
        for (NodeList annotation : annotations) {
            List<NodeList> records = this.getChildrenFromNodeList(RECORD_ELEMENT_NAME, annotation);
            for (NodeList record : records) {
                List<NamedNodeMap> attributes = this.getAttributesFromNodeList(PROPERTYVALUE_ELEMENT_NAME, record);
                for (NamedNodeMap attribute : attributes) {
                    Option attributeName = Option.of((Object)attribute.getNamedItem(PROPERTY_ATTRIBUTE_NAME)).flatMap(node -> Option.of((Object)node.getNodeValue())).map(String::toLowerCase);
                    Option attributeValue = Option.of((Object)attribute.getNamedItem(BOOL_ATTRIBUTE_NAME)).flatMap(node -> Option.of((Object)node.getNodeValue())).map(String::toLowerCase);
                    if (!attributeName.isDefined() || !attributeValue.isDefined()) continue;
                    definedProperties.add(DefinedProperty.of((String)attributeName.get(), (String)attributeValue.get()));
                }
            }
        }
        return definedProperties;
    }

    @Nonnull
    private List<NodeList> getChildrenFromNodeList(@Nonnull String childNodeName, @Nonnull NodeList children) {
        return IntStream.range(0, children.getLength()).mapToObj(children::item).filter(annotation -> childNodeName.equalsIgnoreCase(annotation.getNodeName())).filter(Node::hasChildNodes).map(Node::getChildNodes).collect(Collectors.toList());
    }

    @Nonnull
    private List<NamedNodeMap> getAttributesFromNodeList(@Nonnull String childNodeName, @Nonnull NodeList children) {
        return IntStream.range(0, children.getLength()).mapToObj(children::item).filter(annotation -> childNodeName.equalsIgnoreCase(annotation.getNodeName())).filter(Node::hasAttributes).map(Node::getAttributes).collect(Collectors.toList());
    }

    private Multimap<String, ApiFunction> readSAPSpecFromMetadataFile(Edm metadata) {
        SetMultimap allowedFunctionsByEntity = MultimapBuilder.hashKeys().hashSetValues().build();
        try {
            List entitySets = metadata.getEntitySets();
            for (EdmEntitySet entitySet : entitySets) {
                String entityName = entitySet.getName();
                EdmAnnotations annotations = entitySet.getAnnotations();
                allowedFunctionsByEntity.put((Object)entityName, (Object)ApiFunction.READ_BY_KEY);
                if (this.getAttributeValue(ADDRESSABLE_ATTRIBUTE_NAME, annotations)) {
                    allowedFunctionsByEntity.put((Object)entityName, (Object)ApiFunction.READ);
                }
                if (this.getAttributeValue(CREATABLE_ATTRIBUTE_NAME, annotations)) {
                    allowedFunctionsByEntity.put((Object)entityName, (Object)ApiFunction.CREATE);
                }
                if (this.getAttributeValue("deletable", annotations)) {
                    allowedFunctionsByEntity.put((Object)entityName, (Object)ApiFunction.DELETE);
                }
                if (!this.getAttributeValue("updatable", annotations)) continue;
                allowedFunctionsByEntity.put((Object)entityName, (Object)ApiFunction.UPDATE);
            }
        }
        catch (EdmException e) {
            throw new ODataGeneratorReadException(e);
        }
        return allowedFunctionsByEntity;
    }

    private boolean getAttributeValue(String attributeName, EdmAnnotations annotations) {
        String sapNamespace = "http://www.sap.com/Protocols/SAPData";
        EdmAnnotationAttribute attribute = annotations.getAnnotationAttribute(attributeName, "http://www.sap.com/Protocols/SAPData");
        if (attribute != null && "false".equals(attribute.getText())) {
            return false;
        }
        if (attribute == null || "true".equals(attribute.getText())) {
            return true;
        }
        throw new ODataGeneratorReadException("Could not parse attribute '" + attribute + "' with value '" + attribute.getText() + "'");
    }

    private Multimap<String, ApiFunction> readFromSwaggerFile(File swaggerFile) {
        SetMultimap allowedFunctionsByEntity = MultimapBuilder.hashKeys().hashSetValues().build();
        Iterable<Map.Entry<String, JsonElement>> paths = this.readPaths(swaggerFile);
        for (Map.Entry<String, JsonElement> pathsEntry : paths) {
            this.handleSwaggerPath((Multimap<String, ApiFunction>)allowedFunctionsByEntity, pathsEntry);
        }
        return allowedFunctionsByEntity.isEmpty() ? null : allowedFunctionsByEntity;
    }

    private void handleSwaggerPath(Multimap<String, ApiFunction> allowedFunctionsByEntity, Map.Entry<String, JsonElement> pathsEntry) {
        String key = pathsEntry.getKey();
        String[] split = key.substring(1).split("\\(");
        String entity = split[0];
        block22: for (Map.Entry entry : pathsEntry.getValue().getAsJsonObject().entrySet()) {
            switch ((String)entry.getKey()) {
                case "get": {
                    if (split.length > 1) {
                        allowedFunctionsByEntity.put((Object)entity, (Object)ApiFunction.READ_BY_KEY);
                        continue block22;
                    }
                    allowedFunctionsByEntity.put((Object)entity, (Object)ApiFunction.READ);
                    continue block22;
                }
                case "post": {
                    allowedFunctionsByEntity.put((Object)entity, (Object)ApiFunction.CREATE);
                    continue block22;
                }
                case "patch": {
                    allowedFunctionsByEntity.put((Object)entity, (Object)ApiFunction.UPDATE);
                    continue block22;
                }
                case "delete": {
                    allowedFunctionsByEntity.put((Object)entity, (Object)ApiFunction.DELETE);
                    continue block22;
                }
                case "put": 
                case "options": 
                case "head": 
                case "trace": {
                    logger.warn("Skipping unsupported operation '" + (String)entry.getKey() + "'.");
                    continue block22;
                }
                case "summary": 
                case "description": 
                case "parameters": 
                case "servers": {
                    logger.debug("Skipping field '" + (String)entry.getKey() + "' from the Swagger file.");
                    continue block22;
                }
            }
            logger.info("Skipping unexpected field " + (String)entry.getKey() + "' from Swagger file.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Iterable<Map.Entry<String, JsonElement>> readPaths(File swaggerFile) {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(swaggerFile.toPath(), new OpenOption[0]), this.encoding);){
            JsonElement swaggerJson = JsonParser.parseReader((Reader)reader);
            Set set = swaggerJson.getAsJsonObject().get("paths").getAsJsonObject().entrySet();
            return set;
        }
        catch (IOException e) {
            throw new ODataGeneratorReadException(e);
        }
    }

    private static final class EntitySetName {
        private final String entitySetName;

        private EntitySetName(@Nonnull String entitySetName) {
            this.entitySetName = entitySetName;
        }

        String get() {
            return this.entitySetName;
        }

        static EntitySetName of(@Nonnull EdmEntitySet entitySet) {
            try {
                return new EntitySetName(entitySet.getName());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        static EntitySetName of(@Nonnull String entitySetName) {
            return new EntitySetName(entitySetName);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "AllowedFunctionsResolver.EntitySetName(entitySetName=" + this.entitySetName + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntitySetName)) {
                return false;
            }
            EntitySetName other = (EntitySetName)o;
            String this$entitySetName = this.entitySetName;
            String other$entitySetName = other.entitySetName;
            return !(this$entitySetName == null ? other$entitySetName != null : !this$entitySetName.equals(other$entitySetName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $entitySetName = this.entitySetName;
            result = result * 59 + ($entitySetName == null ? 43 : $entitySetName.hashCode());
            return result;
        }
    }

    private static final class DefinedProperty {
        private final String propertyName;
        private final String propertyValue;

        private DefinedProperty(String propertyName, String propertyValue) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        Option<ApiFunction> determineUnsupportedFunction() {
            ApiFunction supportedFunction;
            if (this.booleanValue()) {
                switch (this.propertyName) {
                    case "readable": {
                        supportedFunction = ApiFunction.READ;
                        break;
                    }
                    case "insertable": {
                        supportedFunction = ApiFunction.CREATE;
                        break;
                    }
                    case "deletable": {
                        supportedFunction = ApiFunction.DELETE;
                        break;
                    }
                    case "updatable": {
                        supportedFunction = ApiFunction.UPDATE;
                        break;
                    }
                    default: {
                        supportedFunction = null;
                        break;
                    }
                }
            } else {
                supportedFunction = null;
            }
            return Option.of(supportedFunction);
        }

        boolean booleanValue() {
            return "false".equals(this.propertyValue);
        }

        static DefinedProperty of(String propertyName, String propertyValue) {
            return new DefinedProperty(propertyName, propertyValue);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "AllowedFunctionsResolver.DefinedProperty(propertyName=" + this.propertyName + ", propertyValue=" + this.propertyValue + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefinedProperty)) {
                return false;
            }
            DefinedProperty other = (DefinedProperty)o;
            String this$propertyName = this.propertyName;
            String other$propertyName = other.propertyName;
            if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
                return false;
            }
            String this$propertyValue = this.propertyValue;
            String other$propertyValue = other.propertyValue;
            return !(this$propertyValue == null ? other$propertyValue != null : !this$propertyValue.equals(other$propertyValue));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $propertyName = this.propertyName;
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            String $propertyValue = this.propertyValue;
            result = result * 59 + ($propertyValue == null ? 43 : $propertyValue.hashCode());
            return result;
        }
    }

    private static final class AnnotationTarget {
        private final String namespace;
        private final String entityContainer;
        private final EntitySetName entitySet;
        private final String property;

        boolean isTargetingEntitySet() {
            return !StringUtils.isBlank((CharSequence)this.entitySet.get()) && StringUtils.isBlank((CharSequence)this.property);
        }

        @Nonnull
        static AnnotationTarget of(@Nonnull String annotationTarget, @Nonnull Edm metadata) {
            Matcher matcher = ANNOTATION_TARGET_PATTERN.matcher(annotationTarget);
            if (matcher.matches()) {
                String entityContainer;
                String property;
                EntitySetName entitySet;
                String namespace = matcher.group(1);
                EntitySetName maybeEntitySetName = EntitySetName.of(matcher.group(2));
                if (matcher.groupCount() == 3) {
                    if (AllowedFunctionsResolver.getEntitySetNames(metadata).contains(maybeEntitySetName)) {
                        entitySet = maybeEntitySetName;
                        property = matcher.group(3);
                        entityContainer = null;
                    } else {
                        entityContainer = matcher.group(2);
                        entitySet = EntitySetName.of(matcher.group(3));
                        property = null;
                    }
                } else {
                    entitySet = maybeEntitySetName;
                    entityContainer = null;
                    property = null;
                }
                return new AnnotationTarget(namespace, entityContainer, entitySet, property);
            }
            return new AnnotationTarget(null, null, null, null);
        }

        @Generated
        public AnnotationTarget(String namespace, String entityContainer, EntitySetName entitySet, String property) {
            this.namespace = namespace;
            this.entityContainer = entityContainer;
            this.entitySet = entitySet;
            this.property = property;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getEntityContainer() {
            return this.entityContainer;
        }

        @Generated
        public EntitySetName getEntitySet() {
            return this.entitySet;
        }

        @Generated
        public String getProperty() {
            return this.property;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotationTarget)) {
                return false;
            }
            AnnotationTarget other = (AnnotationTarget)o;
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$entityContainer = this.getEntityContainer();
            String other$entityContainer = other.getEntityContainer();
            if (this$entityContainer == null ? other$entityContainer != null : !this$entityContainer.equals(other$entityContainer)) {
                return false;
            }
            EntitySetName this$entitySet = this.getEntitySet();
            EntitySetName other$entitySet = other.getEntitySet();
            if (this$entitySet == null ? other$entitySet != null : !((Object)this$entitySet).equals(other$entitySet)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $entityContainer = this.getEntityContainer();
            result = result * 59 + ($entityContainer == null ? 43 : $entityContainer.hashCode());
            EntitySetName $entitySet = this.getEntitySet();
            result = result * 59 + ($entitySet == null ? 43 : ((Object)$entitySet).hashCode());
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "AllowedFunctionsResolver.AnnotationTarget(namespace=" + this.getNamespace() + ", entityContainer=" + this.getEntityContainer() + ", entitySet=" + this.getEntitySet() + ", property=" + this.getProperty() + ")";
        }
    }
}

