/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.UriEncodingStrategy;
import io.vavr.control.Option;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataUriFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataUriFactory.class);
    private static final Pattern PATTERN_DELTA_TOKEN = Pattern.compile("\\$deltatoken=([^&]+)", 2);
    private static final Pattern PATTERN_SKIP_TOKEN = Pattern.compile("\\$skiptoken=([^&]+)", 2);
    private static final Predicate<String> VALID_URL_QUERY = Pattern.compile("^[a-zA-Z0-9/?:@\\-._~!$&'()*+,;=%]*$").asPredicate();

    @Nonnull
    static URI createAndEncodeUri(@Nonnull String servicePath, @Nonnull ODataResourcePath resourcePath, @Nullable String encodedQuery, @Nonnull UriEncodingStrategy strategy) {
        return ODataUriFactory.createAndEncodeUri(servicePath, resourcePath.toEncodedPathString(strategy), encodedQuery, strategy);
    }

    @Nonnull
    static URI createAndEncodeUri(@Nonnull String servicePath, @Nonnull String encodedResourcePath, @Nullable String encodedQuery, @Nonnull UriEncodingStrategy strategy) {
        Object encodedPath = ODataUriFactory.encodePath(servicePath, strategy);
        encodedPath = ODataUriFactory.sanitizeUrlPath((String)encodedPath);
        encodedPath = (String)encodedPath + (String)(encodedResourcePath.startsWith("/") ? encodedResourcePath : "/" + encodedResourcePath);
        Option maybeQueryEncoded = Option.of((Object)encodedQuery).filter(s -> !Strings.isNullOrEmpty((String)s));
        if (maybeQueryEncoded.isDefined() && !maybeQueryEncoded.exists(VALID_URL_QUERY)) {
            throw new IllegalArgumentException("The query part of OData request is not correctly encoded: \"" + encodedQuery + "\"");
        }
        String resultUrl = (String)encodedPath + (String)maybeQueryEncoded.map(q -> "?" + q).getOrElse((Object)"");
        try {
            return new URI(resultUrl);
        }
        catch (URISyntaxException e) {
            log.error("Failed to construct URI for OData request with service path '{}', resource path '{}' and query '{}'.", new Object[]{servicePath, encodedResourcePath, encodedQuery, e});
            throw new IllegalArgumentException("Failed to construct URI.", e);
        }
    }

    @Nonnull
    public static String encodePath(@Nonnull String path) {
        return ODataUriFactory.encodePath(path, UriEncodingStrategy.REGULAR);
    }

    @Nonnull
    public static String encodePath(@Nonnull String path, @Nonnull UriEncodingStrategy strategy) {
        return Arrays.stream(path.split("/")).map(arg_0 -> ((Escaper)strategy.getPathPercentEscaper()).escape(arg_0)).collect(Collectors.joining("/"));
    }

    @Nonnull
    public static String encodePathSegment(@Nonnull String path) {
        return ODataUriFactory.encodePathSegment(path, UriEncodingStrategy.REGULAR);
    }

    @Nonnull
    public static String encodePathSegment(@Nonnull String path, @Nonnull UriEncodingStrategy strategy) {
        return strategy.getPathPercentEscaper().escape(path);
    }

    @Nonnull
    public static String encodeQuery(@Nonnull String input) {
        return ODataUriFactory.encodeQuery(input, UriEncodingStrategy.REGULAR);
    }

    @Nonnull
    public static String encodeQuery(@Nonnull String input, @Nonnull UriEncodingStrategy strategy) {
        return strategy.getQueryPercentEscaper().escape(input);
    }

    @Nonnull
    public static Option<String> extractDeltaToken(@Nullable String url) {
        return Option.of((Object)url).map(PATTERN_DELTA_TOKEN::matcher).filter(Matcher::find).map(m -> m.group(1));
    }

    @Nonnull
    public static Option<String> extractSkipToken(@Nullable String url) {
        return Option.of((Object)url).map(PATTERN_SKIP_TOKEN::matcher).filter(Matcher::find).map(m -> m.group(1));
    }

    @Nonnull
    private static String sanitizeUrlPath(@Nonnull String path) {
        String pathWithPrefixingSlash = "/" + path;
        String pathWithoutDoubleSlashes = pathWithPrefixingSlash.replaceAll("//+", "/");
        return pathWithoutDoubleSlashes.replaceAll("/$", "");
    }
}

