/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public interface ODataRequestResult {
    @Nonnull
    public ODataRequestGeneric getODataRequest();

    @Nonnull
    public HttpResponse getHttpResponse();

    @Nullable
    default public StatusLine getStatusLine() {
        return this.getHttpResponse().getStatusLine();
    }

    @Nonnull
    default public Iterable<String> getHeaderNames() {
        return this.getAllHeaderValues().keySet();
    }

    @Nonnull
    default public Iterable<String> getHeaderValues(@Nonnull String headerName) {
        return this.getAllHeaderValues().getOrDefault(headerName, Collections.emptyList());
    }

    @Nonnull
    default public Map<String, Iterable<String>> getAllHeaderValues() {
        Header[] allHeaders = this.getHttpResponse().getAllHeaders();
        TreeMap<String, Collection> result = new TreeMap<String, Collection>(String::compareToIgnoreCase);
        for (Header header : allHeaders) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            if (headerValue == null) continue;
            result.computeIfAbsent(headerName, key -> new ArrayList()).add(headerValue);
        }
        return Collections.unmodifiableMap(result);
    }
}

