/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataRequestException;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHealthyResponseValidator;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultPagination;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ODataRequestResultPaginationIterator
implements Iterator<ODataRequestResultPagination> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestResultPaginationIterator.class);
    @Nullable
    private Supplier<ODataRequestResultPagination> nextPageLazy = () -> firstPage;

    ODataRequestResultPaginationIterator(@Nonnull ODataRequestResultPagination firstPage) {
    }

    @Override
    public boolean hasNext() {
        return this.nextPageLazy != null;
    }

    @Override
    @Nonnull
    public ODataRequestResultPagination next() throws NoSuchElementException, ODataException {
        log.debug("Getting next page of OData request.");
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next page of OData result-set defined.");
        }
        ODataRequestResultPagination page = Objects.requireNonNull(this.nextPageLazy).get();
        log.debug("Retrieved new page from OData service.");
        this.nextPageLazy = page.getNextLink().isDefined() ? () -> this.requestNextPage(page) : null;
        return page;
    }

    @Nonnull
    protected ODataRequestResultPagination requestNextPage(@Nonnull ODataRequestResultPagination page) {
        return (ODataRequestResultPagination)page.tryGetNextPage().andThenTry(ODataHealthyResponseValidator::requireHealthyResponse).getOrElseThrow(e -> new ODataRequestException(page.getODataRequest(), "Failed to handle next page.", (Throwable)e));
    }
}

