/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;

public interface ODataRequestResult {
    @Nonnull
    public ODataRequestGeneric getODataRequest();

    @Nonnull
    public HttpResponse getHttpResponse();

    @Nonnull
    default public Iterable<String> getHeaderNames() {
        return this.getAllHeaderValues().keySet();
    }

    @Nonnull
    default public Iterable<String> getHeaderValues(@Nonnull String headerName) {
        return this.getAllHeaderValues().getOrDefault(headerName, Collections.emptyList());
    }

    @Nonnull
    default public Map<String, Iterable<String>> getAllHeaderValues() {
        Header[] allHeaders = this.getHttpResponse().getAllHeaders();
        ListMultimap result = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), ArrayList::new);
        for (Header header : allHeaders) {
            String headerName = header.getName();
            if (headerName.equalsIgnoreCase("Set-Cookie")) {
                for (String string : header.getValue().split(";")) {
                    result.put((Object)headerName, (Object)string.trim());
                }
                continue;
            }
            for (HeaderElement headerElement : header.getElements()) {
                result.put((Object)headerName, (Object)headerElement.toString());
            }
        }
        return Collections.unmodifiableMap(result.asMap());
    }
}

