/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.expression;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpression;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDate;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDateTimeOffset;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDuration;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueNumeric;
import javax.annotation.Nonnull;

@Beta
public interface FilterExpressionArithmetic {
    @Nonnull
    public static ValueNumeric.Expression add(@Nonnull ValueNumeric operand1, @Nonnull ValueNumeric operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("add", operand1, operand2);
        return new ValueNumeric.Expression(expression);
    }

    @Nonnull
    public static ValueDateTimeOffset.Expression add(@Nonnull ValueDateTimeOffset operand1, @Nonnull ValueDuration operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("add", operand1, operand2);
        return new ValueDateTimeOffset.Expression(expression);
    }

    @Nonnull
    public static ValueDuration.Expression add(@Nonnull ValueDuration operand1, @Nonnull ValueDuration operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("add", operand1, operand2);
        return new ValueDuration.Expression(expression);
    }

    @Nonnull
    public static ValueDate.Expression add(@Nonnull ValueDate operand1, @Nonnull ValueDuration operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("add", operand1, operand2);
        return new ValueDate.Expression(expression);
    }

    @Nonnull
    public static ValueNumeric.Expression subtract(@Nonnull ValueNumeric operand1, @Nonnull ValueNumeric operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("sub", operand1, operand2);
        return new ValueNumeric.Expression(expression);
    }

    @Nonnull
    public static ValueDateTimeOffset.Expression subtract(@Nonnull ValueDateTimeOffset operand1, @Nonnull ValueDuration operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("sub", operand1, operand2);
        return new ValueDateTimeOffset.Expression(expression);
    }

    @Nonnull
    public static ValueDuration.Expression subtract(@Nonnull ValueDuration operand1, @Nonnull ValueDuration operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("sub", operand1, operand2);
        return new ValueDuration.Expression(expression);
    }

    @Nonnull
    public static ValueDate.Expression subtract(@Nonnull ValueDate operand1, @Nonnull ValueDuration operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("sub", operand1, operand2);
        return new ValueDate.Expression(expression);
    }

    @Nonnull
    public static ValueDuration.Expression subtract(@Nonnull ValueDate operand1, @Nonnull ValueDate operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("sub", operand1, operand2);
        return new ValueDuration.Expression(expression);
    }

    @Nonnull
    public static ValueNumeric.Expression negate(@Nonnull ValueNumeric operand) {
        FilterExpression expression = Expressions.createFunctionPrefix("-", operand);
        return new ValueNumeric.Expression(expression);
    }

    @Nonnull
    public static ValueDuration.Expression negate(@Nonnull ValueDuration operand) {
        FilterExpression expression = Expressions.createFunctionPrefix("-", operand);
        return new ValueDuration.Expression(expression);
    }

    @Nonnull
    public static ValueNumeric.Expression multiply(@Nonnull ValueNumeric operand1, @Nonnull ValueNumeric operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("mul", operand1, operand2);
        return new ValueNumeric.Expression(expression);
    }

    @Nonnull
    public static ValueDuration.Expression multiply(@Nonnull ValueDuration operand1, @Nonnull ValueNumeric operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("mul", operand1, operand2);
        return new ValueDuration.Expression(expression);
    }

    @Nonnull
    public static ValueNumeric.Expression divide(@Nonnull ValueNumeric operand1, @Nonnull ValueNumeric operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("divby", operand1, operand2);
        return new ValueNumeric.Expression(expression);
    }

    @Nonnull
    public static ValueNumeric.Expression divideEuclidean(@Nonnull ValueNumeric operand1, @Nonnull ValueNumeric operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("div", operand1, operand2);
        return new ValueNumeric.Expression(expression);
    }

    @Nonnull
    public static ValueDuration.Expression divide(@Nonnull ValueDuration operand1, @Nonnull ValueNumeric operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("div", operand1, operand2);
        return new ValueDuration.Expression(expression);
    }

    @Nonnull
    public static ValueNumeric.Expression modulo(@Nonnull ValueNumeric operand1, @Nonnull ValueNumeric operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("mod", operand1, operand2);
        return new ValueNumeric.Expression(expression);
    }

    @Nonnull
    public static ValueNumeric.Expression ceiling(@Nonnull ValueNumeric operand) {
        FilterExpression expression = Expressions.createFunctionPrefix("ceiling", operand);
        return new ValueNumeric.Expression(expression);
    }

    @Nonnull
    public static ValueNumeric.Expression floor(@Nonnull ValueNumeric operand) {
        FilterExpression expression = Expressions.createFunctionPrefix("floor", operand);
        return new ValueNumeric.Expression(expression);
    }

    @Nonnull
    public static ValueNumeric.Expression round(@Nonnull ValueNumeric operand) {
        FilterExpression expression = Expressions.createFunctionPrefix("round", operand);
        return new ValueNumeric.Expression(expression);
    }
}

