/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.typeconverter;

import com.sap.cloud.sdk.typeconverter.ConvertedObject;
import com.sap.cloud.sdk.typeconverter.TypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTypeConverter<T, DomainT>
implements TypeConverter<T, DomainT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTypeConverter.class);

    @Override
    @Nonnull
    public final ConvertedObject<DomainT> toDomain(@Nullable T object) {
        if (object == null) {
            return ConvertedObject.ofNull();
        }
        try {
            return this.toDomainNonNull(object);
        }
        catch (Exception e) {
            log.debug("Failed to convert to domain object: {}.", object, (Object)e);
            return ConvertedObject.ofNotConvertible();
        }
    }

    @Override
    @Nonnull
    public final ConvertedObject<T> fromDomain(@Nullable DomainT domainObject) {
        if (domainObject == null) {
            return ConvertedObject.ofNull();
        }
        try {
            return this.fromDomainNonNull(domainObject);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to convert domain object of type " + this.getDomainType().getName() + " to " + this.getType().getName() + ": " + String.valueOf(domainObject) + ".", (Throwable)e);
            }
            return ConvertedObject.ofNotConvertible();
        }
    }

    @Nonnull
    public abstract ConvertedObject<DomainT> toDomainNonNull(@Nonnull T var1) throws Exception;

    @Nonnull
    public abstract ConvertedObject<T> fromDomainNonNull(@Nonnull DomainT var1) throws Exception;
}

