/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataInput;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataOutput;
import com.sap.cloud.sdk.datamodel.metadata.generator.InputProperties;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenCoordinate;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenRepositoryAccessor;
import com.sap.cloud.sdk.datamodel.metadata.generator.MetadataGenerationException;
import com.sap.cloud.sdk.datamodel.metadata.generator.ProtocolSpecificMetadataProvider;
import com.sap.cloud.sdk.datamodel.metadata.generator.ServiceStatus;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.annotation.Nonnull;
import lombok.Generated;

class ProtocolAgnosticMetadataProvider {
    private final ProtocolSpecificMetadataProvider metadataProvider;
    private final MavenRepositoryAccessor mavenRepositoryAccessor;
    private final InputProperties inputProperties;

    @Nonnull
    Try<DatamodelMetadataOutput> tryGetDatamodelMetadata(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            DatamodelMetadataOutput.PreGeneratedLibrary preGeneratedLibrary;
            ServiceStatus serviceStatus;
            Option<MavenCoordinate> maybeLibraryInformation = this.metadataProvider.getMavenCoordinate();
            if (maybeLibraryInformation.isDefined() && datamodelMetadataInput.isCodeGenerationSuccessful()) {
                serviceStatus = ServiceStatus.CERTIFIED;
                preGeneratedLibrary = this.getPreGeneratedLibrary(datamodelMetadataInput, (MavenCoordinate)maybeLibraryInformation.get());
            } else {
                serviceStatus = datamodelMetadataInput.isCodeGenerationSuccessful() ? ServiceStatus.VERIFIED : ServiceStatus.FAILED;
                preGeneratedLibrary = null;
            }
            String apiSpecificUsageInstructions = datamodelMetadataInput.isCodeGenerationSuccessful() ? (String)this.metadataProvider.getApiSpecificUsage(datamodelMetadataInput).getOrNull() : null;
            return DatamodelMetadataOutput.builder().serviceStatus(serviceStatus).apiType(this.metadataProvider.getApiType()).pregeneratedLibrary(preGeneratedLibrary).apiSpecificUsage(apiSpecificUsageInstructions).build();
        });
    }

    private DatamodelMetadataOutput.PreGeneratedLibrary getPreGeneratedLibrary(DatamodelMetadataInput datamodelMetadataInput, MavenCoordinate mavenCoordinate) {
        String libraryGroupId = mavenCoordinate.getGroupId();
        String libraryArtifactId = mavenCoordinate.getArtifactId();
        String libraryVersion = (String)this.getLibraryVersion(mavenCoordinate).getOrElseThrow(cause -> new MetadataGenerationException("Failed to determine library version.", (Throwable)cause));
        return DatamodelMetadataOutput.PreGeneratedLibrary.builder().groupId(libraryGroupId).artifactId(libraryArtifactId).version(libraryVersion).compatibilityNotes("").description(datamodelMetadataInput.getDescription()).build();
    }

    private Try<String> getLibraryVersion(MavenCoordinate libraryMavenCoordinate) {
        return this.inputProperties.getLibraryVersion() == null ? this.mavenRepositoryAccessor.getLatestModuleVersion(libraryMavenCoordinate) : Try.success((Object)this.inputProperties.getLibraryVersion());
    }

    @Generated
    public ProtocolAgnosticMetadataProvider(ProtocolSpecificMetadataProvider metadataProvider, MavenRepositoryAccessor mavenRepositoryAccessor, InputProperties inputProperties) {
        this.metadataProvider = metadataProvider;
        this.mavenRepositoryAccessor = mavenRepositoryAccessor;
        this.inputProperties = inputProperties;
    }
}

