/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.sap.cloud.sdk.datamodel.metadata.generator.ApiUsageMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

class MetadataApiSpecificUsage {
    private static final String TEMPLATE_IMPORT = "import %s;";
    private static final String TEMPLATE_VARIABLE = "final %s %s;";
    private static final String TEMPLATE_VARIABLE_SET = "final %s %s = %s;";
    private static final String TEMPLATE_SERVICE_CONSTRUCTOR = "new %s(%s)";
    private static final String SERVICE_VARIABLE = "service";
    private static final String RESULT_VARIABLE = "result";
    private final String usageImports;
    private final String usageUnassignedVars;
    private final String usageAssignedVars;
    private final String usageServiceDeclaration;
    private final String usageServiceCall;

    private MetadataApiSpecificUsage(@Nonnull ApiUsageMetadata data, List<String> enforceImports, List<Declaration> initialValues) {
        this.usageImports = Joiner.on((String)"\n").join(MetadataApiSpecificUsage.getImports(data, enforceImports, initialValues));
        this.usageUnassignedVars = Joiner.on((String)"\n").join(MetadataApiSpecificUsage.getUnassignedDeclarations(data, initialValues));
        this.usageAssignedVars = Joiner.on((String)"\n").join(initialValues);
        this.usageServiceDeclaration = MetadataApiSpecificUsage.getServiceDeclaration(data).toString();
        this.usageServiceCall = MetadataApiSpecificUsage.getServiceCall(data).toString();
    }

    public String getUsage() {
        return Stream.of(this.usageImports + "\n", this.usageAssignedVars, this.usageUnassignedVars, this.usageServiceDeclaration, this.usageServiceCall).filter(s -> !s.isEmpty()).collect(Collectors.joining("\n"));
    }

    private static Declaration getServiceCall(@Nonnull ApiUsageMetadata data) {
        String methodResultType = MetadataApiSpecificUsage.getUnqualified(data.getQualifiedServiceMethodResult());
        Object methodCall = SERVICE_VARIABLE;
        if (!data.getServiceMethodInvocations().isEmpty()) {
            methodCall = (String)methodCall + "." + Joiner.on((String)".").join(data.getServiceMethodInvocations());
        }
        return new Declaration(RESULT_VARIABLE, methodResultType, (String)methodCall);
    }

    private static Declaration getServiceDeclaration(@Nonnull ApiUsageMetadata data) {
        String serviceInterface = MetadataApiSpecificUsage.getUnqualified(data.getQualifiedServiceInterfaceName());
        String serviceClass = MetadataApiSpecificUsage.getUnqualified(data.getQualifiedServiceClassName());
        String constructorArguments = Joiner.on((String)", ").join(data.getServiceConstructorArguments());
        String serviceInit = String.format(TEMPLATE_SERVICE_CONSTRUCTOR, serviceClass, constructorArguments);
        return new Declaration(SERVICE_VARIABLE, serviceInterface, serviceInit);
    }

    @Nonnull
    private static List<Declaration> getUnassignedDeclarations(@Nonnull ApiUsageMetadata data, List<Declaration> initialValues) {
        ArrayList<ApiUsageMetadata.MethodArgument> unassignedValues = new ArrayList<ApiUsageMetadata.MethodArgument>(data.getServiceConstructorArguments());
        for (ApiUsageMetadata.Invocation invocation : data.getServiceMethodInvocations()) {
            unassignedValues.addAll(invocation.getArguments());
        }
        return unassignedValues.stream().filter(ApiUsageMetadata.MethodArgumentDynamic.class::isInstance).map(ApiUsageMetadata.MethodArgumentDynamic.class::cast).filter(arg -> initialValues.stream().noneMatch(v -> arg.getCode().equals(v.getName()))).map(arg -> new Declaration(arg.getCode(), arg.getTypeName(), null)).collect(Collectors.toList());
    }

    private static List<String> getImports(ApiUsageMetadata data, List<String> enforceImports, List<Declaration> initialValues) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>(enforceImports);
        imports.addAll(Lists.transform(initialValues, Declaration::getType));
        imports.add(data.getQualifiedServiceInterfaceName());
        imports.add(data.getQualifiedServiceClassName());
        for (ApiUsageMetadata.MethodArgument arg : data.getServiceConstructorArguments()) {
            if (!(arg instanceof ApiUsageMetadata.MethodArgumentDynamic)) continue;
            imports.addAll(MetadataApiSpecificUsage.getImportableTypes(((ApiUsageMetadata.MethodArgumentDynamic)arg).getTypeName()));
        }
        for (ApiUsageMetadata.Invocation invoke : data.getServiceMethodInvocations()) {
            for (ApiUsageMetadata.MethodArgument arg : invoke.getArguments()) {
                if (!(arg instanceof ApiUsageMetadata.MethodArgumentDynamic)) continue;
                imports.addAll(MetadataApiSpecificUsage.getImportableTypes(((ApiUsageMetadata.MethodArgumentDynamic)arg).getTypeName()));
            }
        }
        imports.addAll(MetadataApiSpecificUsage.getImportableTypes(data.getQualifiedServiceMethodResult()));
        return imports.stream().map(imp -> String.format(TEMPLATE_IMPORT, imp)).collect(Collectors.toList());
    }

    private static String getUnqualified(String qualifiedType) {
        return qualifiedType.replaceAll("\\w+\\.", "");
    }

    private static Collection<String> getImportableTypes(String ... types) {
        Pattern typePattern = Pattern.compile("[\\w.]*");
        ArrayList<String> result = new ArrayList<String>();
        for (String constructorArgType : types) {
            Matcher matcher = typePattern.matcher(constructorArgType);
            while (matcher.find()) {
                String qualifiedType = matcher.group(0);
                if (qualifiedType.isEmpty() || qualifiedType.startsWith("java.lang.")) continue;
                result.add(qualifiedType);
            }
        }
        return result;
    }

    @Nonnull
    @Generated
    public static MetadataApiSpecificUsageBuilder builder() {
        return new MetadataApiSpecificUsageBuilder();
    }

    static final class Declaration {
        @Nonnull
        private final String name;
        @Nonnull
        private final String type;
        @Nullable
        private final String value;

        @Nonnull
        public String toString() {
            String typeUnqualified = MetadataApiSpecificUsage.getUnqualified(this.type);
            return this.value == null ? String.format(MetadataApiSpecificUsage.TEMPLATE_VARIABLE, typeUnqualified, this.name) : String.format(MetadataApiSpecificUsage.TEMPLATE_VARIABLE_SET, typeUnqualified, this.name, this.value);
        }

        @Generated
        public Declaration(@Nonnull String name, @Nonnull String type, @Nullable String value) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.name = name;
            this.type = type;
            this.value = value;
        }

        @Nonnull
        @Generated
        public String getName() {
            return this.name;
        }

        @Nonnull
        @Generated
        public String getType() {
            return this.type;
        }

        @Nullable
        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Declaration)) {
                return false;
            }
            Declaration other = (Declaration)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }

    @Generated
    public static class MetadataApiSpecificUsageBuilder {
        @Generated
        private ApiUsageMetadata data;
        @Generated
        private ArrayList<String> enforceImports;
        @Generated
        private ArrayList<Declaration> initialValues;

        @Generated
        MetadataApiSpecificUsageBuilder() {
        }

        @Nonnull
        @Generated
        public MetadataApiSpecificUsageBuilder data(@Nonnull ApiUsageMetadata data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        @Nonnull
        @Generated
        public MetadataApiSpecificUsageBuilder enforceImport(String enforceImport) {
            if (this.enforceImports == null) {
                this.enforceImports = new ArrayList();
            }
            this.enforceImports.add(enforceImport);
            return this;
        }

        @Nonnull
        @Generated
        public MetadataApiSpecificUsageBuilder enforceImports(@Nonnull Collection<? extends String> enforceImports) {
            if (enforceImports == null) {
                throw new NullPointerException("enforceImports cannot be null");
            }
            if (this.enforceImports == null) {
                this.enforceImports = new ArrayList();
            }
            this.enforceImports.addAll(enforceImports);
            return this;
        }

        @Nonnull
        @Generated
        public MetadataApiSpecificUsageBuilder clearEnforceImports() {
            if (this.enforceImports != null) {
                this.enforceImports.clear();
            }
            return this;
        }

        @Nonnull
        @Generated
        public MetadataApiSpecificUsageBuilder initialValue(Declaration initialValue) {
            if (this.initialValues == null) {
                this.initialValues = new ArrayList();
            }
            this.initialValues.add(initialValue);
            return this;
        }

        @Nonnull
        @Generated
        public MetadataApiSpecificUsageBuilder initialValues(@Nonnull Collection<? extends Declaration> initialValues) {
            if (initialValues == null) {
                throw new NullPointerException("initialValues cannot be null");
            }
            if (this.initialValues == null) {
                this.initialValues = new ArrayList();
            }
            this.initialValues.addAll(initialValues);
            return this;
        }

        @Nonnull
        @Generated
        public MetadataApiSpecificUsageBuilder clearInitialValues() {
            if (this.initialValues != null) {
                this.initialValues.clear();
            }
            return this;
        }

        @Nonnull
        @Generated
        public MetadataApiSpecificUsage build() {
            return new MetadataApiSpecificUsage(this.data, switch (this.enforceImports == null ? 0 : this.enforceImports.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.enforceImports.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.enforceImports));
            }, switch (this.initialValues == null ? 0 : this.initialValues.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.initialValues.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Declaration>(this.initialValues));
            });
        }

        @Nonnull
        @Generated
        public String toString() {
            return "MetadataApiSpecificUsage.MetadataApiSpecificUsageBuilder(data=" + String.valueOf(this.data) + ", enforceImports=" + String.valueOf(this.enforceImports) + ", initialValues=" + String.valueOf(this.initialValues) + ")";
        }
    }
}

