/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.util.StringUtils;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenCoordinate;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenRepositoryAccessor;
import com.sap.cloud.sdk.datamodel.metadata.generator.MetadataGenerationException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMavenRepositoryAccessor
implements MavenRepositoryAccessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMavenRepositoryAccessor.class);
    private static final String MAVEN_CENTRAL_BASE_URL = "https://repo1.maven.org/maven2";
    private String mavenRepositoryBaseUrl = "https://repo1.maven.org/maven2";
    private static final int HTTP_CODE_OK = 200;
    private final Map<MavenCoordinate, String> resultCache = new ConcurrentHashMap<MavenCoordinate, String>();

    DefaultMavenRepositoryAccessor() {
    }

    @Override
    @Nonnull
    public Try<String> getLatestModuleVersion(@Nonnull MavenCoordinate mavenCoordinate) {
        return Try.of((CheckedFunction0 & Serializable)() -> this.resultCache.computeIfAbsent(mavenCoordinate, this::obtainLatestVersionViaHttp));
    }

    private String obtainLatestVersionViaHttp(MavenCoordinate mavenCoordinate) {
        String latestVersion;
        HttpResponse response;
        String relativePath = mavenCoordinate.getGroupId().replace(".", "/") + "/" + mavenCoordinate.getArtifactId() + "/maven-metadata.xml";
        URI targetUri = URI.create(this.mavenRepositoryBaseUrl + "/" + relativePath);
        log.debug("Accessing Maven repository with URI {}.", (Object)targetUri);
        try {
            response = HttpClientAccessor.getHttpClient().execute((HttpUriRequest)new HttpGet(targetUri));
        }
        catch (IOException e) {
            throw new MetadataGenerationException("Failed to determine latest module version for " + String.valueOf(mavenCoordinate) + ".", e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            int statusCode = response.getStatusLine().getStatusCode();
            log.debug("Received HTTP response with status code {} from Maven repository with URI {}.", (Object)statusCode, (Object)targetUri);
            throw new MetadataGenerationException("Received HTTP status code " + statusCode + " while determining the latest module version for " + String.valueOf(mavenCoordinate) + ".");
        }
        try (InputStream stream = response.getEntity().getContent();){
            JsonNode tree = new XmlMapper().readTree(stream);
            latestVersion = tree.path("versioning").path("latest").asText();
        }
        catch (IOException e) {
            throw new MetadataGenerationException("Failed to determine latest module version for " + String.valueOf(mavenCoordinate) + ".", e);
        }
        if (StringUtils.isBlank((String)latestVersion)) {
            throw new MetadataGenerationException("Could not find expected XML field (versioning -> latest) while determining the latest module version for " + String.valueOf(mavenCoordinate) + ".");
        }
        return latestVersion;
    }

    @Generated
    void setMavenRepositoryBaseUrl(String mavenRepositoryBaseUrl) {
        this.mavenRepositoryBaseUrl = mavenRepositoryBaseUrl;
    }
}

