/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataInput;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataOutput;
import com.sap.cloud.sdk.datamodel.metadata.generator.DefaultMavenRepositoryAccessor;
import com.sap.cloud.sdk.datamodel.metadata.generator.InputProperties;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenRepositoryAccessor;
import com.sap.cloud.sdk.datamodel.metadata.generator.MetadataGenerationException;
import com.sap.cloud.sdk.datamodel.metadata.generator.ODataDatamodelMetadataProvider;
import com.sap.cloud.sdk.datamodel.metadata.generator.ProtocolAgnosticMetadataProvider;
import com.sap.cloud.sdk.datamodel.metadata.generator.ProtocolSpecificMetadataProvider;
import com.sap.cloud.sdk.datamodel.metadata.generator.RestDatamodelMetadataProvider;
import com.sap.cloud.sdk.datamodel.metadata.generator.ServiceType;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatamodelMetadataGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatamodelMetadataGenerator.class);
    private static final String METADATA_GENERATOR_INPUT_FILENAME = "metadata-generator-properties.json";
    private static final String METADATA_FILE_SUFFIX = "_CLIENT_JAVA";
    private InputProperties inputProperties;
    private final Path metadataGeneratorPropertiesFile;
    private final MavenRepositoryAccessor mavenRepositoryAccessor;

    public DatamodelMetadataGenerator(@Nonnull Path inputDirectory) {
        this(inputDirectory, new DefaultMavenRepositoryAccessor());
    }

    DatamodelMetadataGenerator(@Nonnull Path inputDirectory, @Nonnull MavenRepositoryAccessor mavenRepositoryAccessor) {
        this.metadataGeneratorPropertiesFile = inputDirectory.resolve(METADATA_GENERATOR_INPUT_FILENAME);
        this.mavenRepositoryAccessor = mavenRepositoryAccessor;
    }

    public boolean isMetadataGenerationEnabled() {
        return this.isMetadataGeneratorPropertiesFileExisting();
    }

    public void generate(@Nonnull List<DatamodelMetadataInput> datamodelMetadataInput, @Nonnull Path outputDirectory) {
        this.inputProperties = this.getInputProperties();
        for (DatamodelMetadataInput datamodelMetadataInputEntry : datamodelMetadataInput) {
            DatamodelMetadataOutput datamodelMetadataOutput = this.getDataModelMetadataOutput(datamodelMetadataInputEntry);
            try {
                Path modifiedOutputDir = Files.createDirectories(outputDirectory.resolve("metadata"), new FileAttribute[0]);
                log.info("Metadata files will be generated into output directory: " + String.valueOf(modifiedOutputDir.toAbsolutePath()));
                this.saveMetadataToFile(datamodelMetadataOutput, datamodelMetadataInputEntry, modifiedOutputDir);
            }
            catch (IOException e) {
                throw new MetadataGenerationException("Failed to save the datamodel metadata.", e);
            }
        }
    }

    private DatamodelMetadataOutput getDataModelMetadataOutput(DatamodelMetadataInput datamodelMetadataInput) {
        return (DatamodelMetadataOutput)new ProtocolAgnosticMetadataProvider(this.getProtocolSpecificMetadataProvider(datamodelMetadataInput.getProtocolSpecificMetadata().getServiceType()), this.mavenRepositoryAccessor, this.inputProperties).tryGetDatamodelMetadata(datamodelMetadataInput).getOrElseThrow(e -> new MetadataGenerationException("Failure generating datamodel metadata.", (Throwable)e));
    }

    private ProtocolSpecificMetadataProvider getProtocolSpecificMetadataProvider(ServiceType serviceType) {
        switch (serviceType) {
            case ODATA_V2: 
            case ODATA_V4: {
                return new ODataDatamodelMetadataProvider(this.inputProperties);
            }
            case REST: {
                return new RestDatamodelMetadataProvider(this.inputProperties);
            }
        }
        throw new IllegalStateException("Service type " + String.valueOf((Object)serviceType) + " not supported.");
    }

    private boolean isMetadataGeneratorPropertiesFileExisting() {
        if (Files.exists(this.metadataGeneratorPropertiesFile, new LinkOption[0])) {
            log.info("Input file required for metadata generation is available and exists at " + String.valueOf(this.metadataGeneratorPropertiesFile.toAbsolutePath()));
            return true;
        }
        return false;
    }

    @Nonnull
    private InputProperties getInputProperties() {
        if (!this.isMetadataGeneratorPropertiesFileExisting()) {
            throw new MetadataGenerationException("Failed to start metadata generation as metadata-generator-properties.json is not available");
        }
        try {
            return (InputProperties)new Gson().fromJson((Reader)Files.newBufferedReader(this.metadataGeneratorPropertiesFile), InputProperties.class);
        }
        catch (IOException e) {
            throw new MetadataGenerationException("Failed to read from input file: " + String.valueOf(this.metadataGeneratorPropertiesFile) + " during metadata generation", e);
        }
    }

    private void saveMetadataToFile(@Nonnull DatamodelMetadataOutput datamodelMetadataOutput, @Nonnull DatamodelMetadataInput datamodelMetadataInput, @Nonnull Path outputDirectory) throws IOException {
        String metadataFileNamePrefix = FilenameUtils.removeExtension((String)datamodelMetadataInput.getApiSpecFilePath().getFileName().toString());
        Path filePath = outputDirectory.resolve(metadataFileNamePrefix + "_CLIENT_JAVA.json");
        String serializedMetadata = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create().toJson((Object)datamodelMetadataOutput);
        log.info("Saving metadata for {} API specification {} to file {}.", new Object[]{datamodelMetadataInput.getProtocolSpecificMetadata().getServiceType(), datamodelMetadataInput.getApiSpecFilePath().getFileName().toString(), filePath});
        Files.write(filePath, serializedMetadata.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

