/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public interface ApiUsageMetadata {
    @Nonnull
    public List<MethodArgument> getServiceConstructorArguments();

    @Nonnull
    public List<Invocation> getServiceMethodInvocations();

    @Nonnull
    public String getQualifiedServiceInterfaceName();

    @Nonnull
    public String getQualifiedServiceClassName();

    @Nonnull
    public String getQualifiedServiceMethodResult();

    @Nonnull
    public static Invocation method(@Nonnull String name) {
        return new Invocation(name, Collections.emptyList());
    }

    @Nonnull
    public static MethodArgument arg(@Nonnull String code) {
        return new MethodArgumentStatic(code);
    }

    @Nonnull
    public static MethodArgument arg(@Nonnull String code, @Nonnull Class<?> type) {
        return new MethodArgumentDynamic(code, type.getName());
    }

    public static final class Invocation {
        @Nonnull
        private final String method;
        @Nonnull
        private final List<MethodArgument> arguments;

        @Nonnull
        public Invocation arg(@Nonnull String name, @Nonnull Class<?> type) {
            ArrayList<MethodArgument> args = new ArrayList<MethodArgument>(this.getArguments());
            args.add(new MethodArgumentDynamic(name, type.getName()));
            return new Invocation(this.getMethod(), args);
        }

        @Nonnull
        public Invocation arg(@Nonnull String name, @Nonnull String typeName) {
            ArrayList<MethodArgument> args = new ArrayList<MethodArgument>(this.getArguments());
            args.add(new MethodArgumentDynamic(name, typeName));
            return new Invocation(this.getMethod(), args);
        }

        @Nonnull
        public Invocation arg(@Nonnull String code) {
            ArrayList<MethodArgument> args = new ArrayList<MethodArgument>(this.getArguments());
            args.add(new MethodArgumentStatic(code));
            return new Invocation(this.getMethod(), args);
        }

        @Nonnull
        public String toString() {
            String args = this.arguments.stream().map(MethodArgument::getCode).collect(Collectors.joining(", "));
            return this.getMethod() + "(" + args + ")";
        }

        @Generated
        public Invocation(@Nonnull String method, @Nonnull List<MethodArgument> arguments) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (arguments == null) {
                throw new NullPointerException("arguments is marked non-null but is null");
            }
            this.method = method;
            this.arguments = arguments;
        }

        @Nonnull
        @Generated
        public String getMethod() {
            return this.method;
        }

        @Nonnull
        @Generated
        public List<MethodArgument> getArguments() {
            return this.arguments;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Invocation)) {
                return false;
            }
            Invocation other = (Invocation)o;
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            List<MethodArgument> this$arguments = this.getArguments();
            List<MethodArgument> other$arguments = other.getArguments();
            return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            List<MethodArgument> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            return result;
        }
    }

    public static final class MethodArgumentStatic
    implements MethodArgument {
        @Nonnull
        private final String code;

        @Nonnull
        public String toString() {
            return this.getCode();
        }

        @Generated
        public MethodArgumentStatic(@Nonnull String code) {
            if (code == null) {
                throw new NullPointerException("code is marked non-null but is null");
            }
            this.code = code;
        }

        @Override
        @Nonnull
        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodArgumentStatic)) {
                return false;
            }
            MethodArgumentStatic other = (MethodArgumentStatic)o;
            String this$code = this.getCode();
            String other$code = other.getCode();
            return !(this$code == null ? other$code != null : !this$code.equals(other$code));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            return result;
        }
    }

    public static final class MethodArgumentDynamic
    implements MethodArgument {
        @Nonnull
        private final String code;
        @Nonnull
        private final String typeName;

        @Nonnull
        public String toString() {
            return this.getCode();
        }

        @Generated
        public MethodArgumentDynamic(@Nonnull String code, @Nonnull String typeName) {
            if (code == null) {
                throw new NullPointerException("code is marked non-null but is null");
            }
            if (typeName == null) {
                throw new NullPointerException("typeName is marked non-null but is null");
            }
            this.code = code;
            this.typeName = typeName;
        }

        @Override
        @Nonnull
        @Generated
        public String getCode() {
            return this.code;
        }

        @Nonnull
        @Generated
        public String getTypeName() {
            return this.typeName;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodArgumentDynamic)) {
                return false;
            }
            MethodArgumentDynamic other = (MethodArgumentDynamic)o;
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            return result;
        }
    }

    public static interface MethodArgument {
        @Nonnull
        public String getCode();
    }
}

