/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataInput;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataOutput;
import com.sap.cloud.sdk.datamodel.metadata.generator.InputProperties;
import com.sap.cloud.sdk.datamodel.metadata.generator.LibraryInformation;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenCoordinate;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenRepositoryAccessor;
import com.sap.cloud.sdk.datamodel.metadata.generator.MetadataApiSpecificUsage;
import com.sap.cloud.sdk.datamodel.metadata.generator.MetadataGenerationException;
import com.sap.cloud.sdk.datamodel.metadata.generator.ProtocolSpecificMetadataProvider;
import com.sap.cloud.sdk.datamodel.metadata.generator.RestApiUsageMetadata;
import io.vavr.control.Option;
import java.net.URI;
import javax.annotation.Nonnull;
import lombok.Generated;

class RestDatamodelMetadataProvider
implements ProtocolSpecificMetadataProvider {
    private final InputProperties inputProperties;
    private final MavenRepositoryAccessor mavenRepositoryAccessor;

    @Override
    @Nonnull
    public Option<LibraryInformation> getLibraryInformation(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return this.getMavenCoordinate().map(mavenCoordinate -> new LibraryInformation((MavenCoordinate)mavenCoordinate, this.getInstallLibrarySnippet()));
    }

    @Nonnull
    private String getInstallLibrarySnippet() {
        String latestVersion = (String)Option.of((Object)this.inputProperties.getLibraryVersion()).getOrElse(() -> (String)this.mavenRepositoryAccessor.getLatestModuleVersion(MavenCoordinate.builder().artifactId(this.inputProperties.getMavenArtifactId()).groupId(this.inputProperties.getMavenGroupId()).build()).getOrElseThrow(cause -> new MetadataGenerationException("Failure determining latest module version.", (Throwable)cause)));
        return "<dependencies>\n    <dependency>\n        <groupId>" + this.inputProperties.getMavenGroupId() + "</groupId>\n        <artifactId>" + this.inputProperties.getMavenArtifactId() + "</artifactId>\n        <version>" + latestVersion + "</version>\n    </dependency>\n</dependencies>\n";
    }

    @Nonnull
    private Option<MavenCoordinate> getMavenCoordinate() {
        if (this.inputProperties.getMavenArtifactId() == null || this.inputProperties.getMavenGroupId() == null) {
            return Option.none();
        }
        return Option.of((Object)MavenCoordinate.builder().groupId(this.inputProperties.getMavenGroupId()).artifactId(this.inputProperties.getMavenArtifactId()).build());
    }

    @Override
    @Nonnull
    public String getGenerationSteps(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return "<p>Before you follow the below instructions to generate a typed OpenAPI client for an API of your choice, make sure you have a Java Maven project set up. You can also create a new Maven project from the <a href=\"https://sap.github.io/cloud-sdk/docs/java/getting-started/#generating-a-project-from-a-Maven-archetype\">SAP Cloud SDK Maven archetypes</a>.</p><ul><li>Download the API specification file from the SAP API Business Hub for the service of your choice and store it in your project for easier access (ideally in the resources folder of your application; E.g. application/src/main/resources).</li><li>Add this <a href=\"https://sap.github.io/cloud-sdk/docs/java/features/rest/generate-rest-client\">dependency</a> into your application pom file.</li><li>Again, in your application pom, add the <a href=\"https://sap.github.io/cloud-sdk/docs/java/features/rest/generate-rest-client#using-the-openapi-generator-maven-plugin\">OpenAPI Generator Maven plugin</a> to the plugins section.</li><li>Adapt the parameters of the Maven plugin. Refer to the <a href=\"https://sap.github.io/cloud-sdk/docs/java/features/rest/generate-rest-client#available-parameters\">parameters documentation</a> for reference.</li><li>Invoke <code>mvn clean install</code> on your project (application source folder).</li><li>Check whether the generation succeeded by consulting your build output. In case you run into issues, double check your service and file names and make sure that the folders are set up correctly. Once the generation succeeds, you can see the client classes generated in the output folder you picked.</li><li>After the generation is completed, you can start using the generated client to easily build up any request to the API, execute it, and access the results.</li></ul>";
    }

    @Override
    @Nonnull
    public String getGenericUsage(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return "Result result = new ApiClass(destination).operation(parameter);";
    }

    @Override
    @Nonnull
    public Option<String> getApiSpecificUsage(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        if (datamodelMetadataInput.getProtocolSpecificMetadata().getApiUsageMetadata() == null) {
            return Option.none();
        }
        if (!(datamodelMetadataInput.getProtocolSpecificMetadata().getApiUsageMetadata() instanceof RestApiUsageMetadata)) {
            throw new IllegalStateException("Instance of " + RestApiUsageMetadata.class + " expected.");
        }
        RestApiUsageMetadata restApiUsageMetadata = (RestApiUsageMetadata)datamodelMetadataInput.getProtocolSpecificMetadata().getApiUsageMetadata();
        String usageSnippet = MetadataApiSpecificUsage.builder().data(restApiUsageMetadata).initialValue(new MetadataApiSpecificUsage.Declaration("destination", HttpDestination.class.getName(), "DestinationAccessor.getDestination(\"MyDestination\").asHttp()")).enforceImport(DestinationAccessor.class.getName()).build().getUsage();
        return Option.of((Object)usageSnippet);
    }

    @Override
    @Nonnull
    public DatamodelMetadataOutput.UrlWithName getGenerationManual(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return DatamodelMetadataOutput.UrlWithName.builder().url(URI.create("https://sap.github.io/cloud-sdk/docs/java/features/rest/generate-rest-client")).name("OpenAPI Client Generation Manual").build();
    }

    @Override
    @Nonnull
    public DatamodelMetadataOutput.UrlWithName getOverviewDocumentationUrlWithName(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return DatamodelMetadataOutput.UrlWithName.builder().url(URI.create("https://sap.github.io/cloud-sdk/docs/java/features/rest/overview")).name("OpenAPI Consumption Manual").build();
    }

    @Generated
    public RestDatamodelMetadataProvider(InputProperties inputProperties, MavenRepositoryAccessor mavenRepositoryAccessor) {
        this.inputProperties = inputProperties;
        this.mavenRepositoryAccessor = mavenRepositoryAccessor;
    }
}

