/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataInput;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataOutput;
import com.sap.cloud.sdk.datamodel.metadata.generator.InputProperties;
import com.sap.cloud.sdk.datamodel.metadata.generator.LibraryInformation;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenCoordinate;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenRepositoryAccessor;
import com.sap.cloud.sdk.datamodel.metadata.generator.MetadataGenerationException;
import com.sap.cloud.sdk.datamodel.metadata.generator.ProtocolSpecificMetadataProvider;
import com.sap.cloud.sdk.datamodel.metadata.generator.ServiceStatus;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import javax.annotation.Nonnull;
import lombok.Generated;

class ProtocolAgnosticMetadataProvider {
    static final String CONSUMPTION_MANUAL = "Consumption Manual";
    static final String GENERATION_MANUAL = "Client Generation Manual";
    private static final String HELPFUL_LINKS = "Helpful Links";
    private static final String GETTING_STARTED_WITH_SDK_FOR_JAVA = "Getting Started with SDK for Java";
    private final ProtocolSpecificMetadataProvider metadataProvider;
    private final MavenRepositoryAccessor mavenRepositoryAccessor;
    private final InputProperties inputProperties;

    @Nonnull
    Try<DatamodelMetadataOutput> tryGetDatamodelMetadata(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            DatamodelMetadataOutput.PreGeneratedLibrary preGeneratedLibrary;
            ServiceStatus serviceStatus;
            Option<LibraryInformation> maybeLibraryInformation = this.metadataProvider.getLibraryInformation(datamodelMetadataInput);
            if (maybeLibraryInformation.isDefined() && datamodelMetadataInput.isCodeGenerationSuccessful()) {
                serviceStatus = ServiceStatus.CERTIFIED;
                preGeneratedLibrary = this.getPreGeneratedLibrary(datamodelMetadataInput, (LibraryInformation)maybeLibraryInformation.get());
            } else {
                serviceStatus = datamodelMetadataInput.isCodeGenerationSuccessful() ? ServiceStatus.VERIFIED : ServiceStatus.FAILED;
                preGeneratedLibrary = null;
            }
            DatamodelMetadataOutput.UrlWithName generationManual = this.metadataProvider.getGenerationManual(datamodelMetadataInput);
            DatamodelMetadataOutput.UrlWithName overviewDocumentation = this.metadataProvider.getOverviewDocumentationUrlWithName(datamodelMetadataInput);
            DatamodelMetadataOutput.Links links = this.getLinks(generationManual, overviewDocumentation);
            DatamodelMetadataOutput.GenerationAndUsage generationAndUsage = this.getGenerationAndUsage(datamodelMetadataInput, links);
            return DatamodelMetadataOutput.builder().language("Java").serviceStatus(serviceStatus).pregeneratedLibrary(preGeneratedLibrary).generationAndUsage(generationAndUsage).build();
        });
    }

    private DatamodelMetadataOutput.PreGeneratedLibrary getPreGeneratedLibrary(DatamodelMetadataInput datamodelMetadataInput, LibraryInformation libraryInformation) {
        String libraryGroupId = libraryInformation.getMavenCoordinate().getGroupId();
        String libraryArtifactId = libraryInformation.getMavenCoordinate().getArtifactId();
        String libraryVersion = (String)this.getLibraryVersion(libraryInformation.getMavenCoordinate()).getOrElseThrow(cause -> new MetadataGenerationException("Failed to determine library version.", (Throwable)cause));
        String installLibrarySnippet = libraryInformation.getInstallLibrarySnippet();
        return DatamodelMetadataOutput.PreGeneratedLibrary.builder().dependencyName(libraryGroupId + ":" + libraryArtifactId).generatedAt("/Date(" + datamodelMetadataInput.getGenerationTime().toInstant().toEpochMilli() + ")/").repository("Maven").repositoryLink(URI.create("https://search.maven.org/search?q=g:" + libraryGroupId + "%20AND%20a:" + libraryArtifactId)).version(libraryVersion).description(datamodelMetadataInput.getDescription()).installLibrarySteps(DatamodelMetadataOutput.InstructionsWithText.builder().instructions(installLibrarySnippet).text("Add this client library as a dependency of your Java project by copying the code snippet below to the dependency section of your \"pom.xml\". For more details take a look at our \"Getting Started with SDK for Java\" guide from the \"Helpful Links\" menu.").header("Installation").build()).compatibilityNotes("").build();
    }

    private Try<String> getLibraryVersion(MavenCoordinate libraryMavenCoordinate) {
        return this.inputProperties.getLibraryVersion() == null ? this.mavenRepositoryAccessor.getLatestModuleVersion(libraryMavenCoordinate) : Try.success((Object)this.inputProperties.getLibraryVersion());
    }

    private Try<String> getGeneratorVersion(MavenCoordinate generatorMavenCoordinate) {
        return this.inputProperties.getGeneratorVersion() == null ? this.mavenRepositoryAccessor.getLatestModuleVersion(generatorMavenCoordinate) : Try.success((Object)this.inputProperties.getGeneratorVersion());
    }

    private DatamodelMetadataOutput.GenerationAndUsage getGenerationAndUsage(DatamodelMetadataInput datamodelMetadataInput, DatamodelMetadataOutput.Links links) {
        String generatorVersion = (String)this.getGeneratorVersion(datamodelMetadataInput.getGeneratorMavenCoordinate()).getOrElseThrow(cause -> new MetadataGenerationException("Failed to determine generator version.", (Throwable)cause));
        String apiSpecificUsageInstructions = datamodelMetadataInput.isCodeGenerationSuccessful() ? (String)this.metadataProvider.getApiSpecificUsage(datamodelMetadataInput).getOrNull() : null;
        return DatamodelMetadataOutput.GenerationAndUsage.builder().apiSpecificUsage(apiSpecificUsageInstructions != null ? DatamodelMetadataOutput.InstructionsWithText.builder().text("To consume the service via the pregenerated typed client library run the code snippet below. For more details about the client libraries chose \"Consumption Manual\" from the \"Helpful Links\" menu.").header("Usage Example").instructions(apiSpecificUsageInstructions).build() : null).generationSteps(DatamodelMetadataOutput.InstructionsWithText.builder().instructions(this.metadataProvider.getGenerationSteps(datamodelMetadataInput)).text("You can generate a typed client for this service yourself. Follow the instructions below to install the tooling and complete the generation steps:").header("Installation & Generation Steps").build()).links(links).genericUsage(DatamodelMetadataOutput.InstructionsWithText.builder().instructions(this.metadataProvider.getGenericUsage(datamodelMetadataInput)).text("To consume the service via the pregenerated typed client library run the code snippet below. For more details about the client libraries chose \"Consumption Manual\" from the \"Helpful Links\" menu.").header("Usage Example").build()).generatorVersion(generatorVersion).generatorRepositoryLink(datamodelMetadataInput.getGeneratorRepositoryLink()).repository("Maven").build();
    }

    private DatamodelMetadataOutput.Links getLinks(DatamodelMetadataOutput.UrlWithName generationManual, DatamodelMetadataOutput.UrlWithName overviewDocumentation) {
        return DatamodelMetadataOutput.Links.builder().gettingStarted(DatamodelMetadataOutput.UrlWithName.builder().url(URI.create("https://sap.github.io/cloud-sdk/docs/java/getting-started")).name(GETTING_STARTED_WITH_SDK_FOR_JAVA).build()).sdkDocumentation(DatamodelMetadataOutput.UrlWithName.builder().url(URI.create("https://sap.github.io/cloud-sdk/")).name("The SAP Cloud SDK Documentation").build()).support(DatamodelMetadataOutput.UrlWithName.builder().url(URI.create("https://sap.github.io/cloud-sdk/docs/overview/get-support")).name("Get support or give feedback").build()).generationManual(generationManual).overviewDocumentation(overviewDocumentation).build();
    }

    @Generated
    public ProtocolAgnosticMetadataProvider(ProtocolSpecificMetadataProvider metadataProvider, MavenRepositoryAccessor mavenRepositoryAccessor, InputProperties inputProperties) {
        this.metadataProvider = metadataProvider;
        this.mavenRepositoryAccessor = mavenRepositoryAccessor;
        this.inputProperties = inputProperties;
    }
}

