/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataInput;
import com.sap.cloud.sdk.datamodel.metadata.generator.DatamodelMetadataOutput;
import com.sap.cloud.sdk.datamodel.metadata.generator.InputProperties;
import com.sap.cloud.sdk.datamodel.metadata.generator.LibraryInformation;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenCoordinate;
import com.sap.cloud.sdk.datamodel.metadata.generator.MavenRepositoryAccessor;
import com.sap.cloud.sdk.datamodel.metadata.generator.MetadataApiSpecificUsage;
import com.sap.cloud.sdk.datamodel.metadata.generator.MetadataGenerationException;
import com.sap.cloud.sdk.datamodel.metadata.generator.ODataApiUsageMetadata;
import com.sap.cloud.sdk.datamodel.metadata.generator.ProtocolSpecificMetadataProvider;
import io.vavr.control.Option;
import java.net.URI;
import javax.annotation.Nonnull;
import lombok.Generated;

class ODataDatamodelMetadataProvider
implements ProtocolSpecificMetadataProvider {
    private final InputProperties inputProperties;
    private final MavenRepositoryAccessor mavenRepositoryAccessor;
    private static final String MINIMAL_MAVEN_VERSION = "3.5.0";
    private static final String GROUP_ID_CORE_LIB = "com.sap.cloud.sdk.datamodel";
    private static final String ARTIFACT_ID_CORE_LIB_V2 = "odata-core";
    private static final String ARTIFACT_ID_CORE_LIB_V4 = "odata-v4-core";
    private static final String ARTIFACT_ID_GENERATOR_V4 = "odata-v4-generator-maven-plugin";
    private static final String ARTIFACT_ID_GENERATOR_V2 = "odata-generator-maven-plugin";

    @Override
    @Nonnull
    public Option<LibraryInformation> getLibraryInformation(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return this.getMavenCoordinate().map(coordinate -> new LibraryInformation((MavenCoordinate)coordinate, this.getInstallLibrarySnippet((MavenCoordinate)coordinate)));
    }

    @Nonnull
    private String getInstallLibrarySnippet(@Nonnull MavenCoordinate mavenCoordinate) {
        String latestVersion = (String)Option.of((Object)this.inputProperties.getLibraryVersion()).getOrElse(() -> (String)this.mavenRepositoryAccessor.getLatestModuleVersion(mavenCoordinate).getOrElseThrow(cause -> new MetadataGenerationException("Failure determining the latest module version.", (Throwable)cause)));
        return "<dependencies>\n    <dependency>\n        <groupId>" + mavenCoordinate.getGroupId() + "</groupId>\n        <artifactId>" + mavenCoordinate.getArtifactId() + "</artifactId>\n        <version>" + latestVersion + "</version>\n    </dependency>\n</dependencies>\n";
    }

    @Nonnull
    private Option<MavenCoordinate> getMavenCoordinate() {
        if (this.inputProperties.getMavenArtifactId() == null || this.inputProperties.getMavenGroupId() == null) {
            return Option.none();
        }
        return Option.of((Object)MavenCoordinate.builder().groupId(this.inputProperties.getMavenGroupId()).artifactId(this.inputProperties.getMavenArtifactId()).build());
    }

    @Override
    @Nonnull
    public String getGenerationSteps(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        String artifactIdGeneratorPlugin;
        String artifactIdCoreLib;
        switch (datamodelMetadataInput.getProtocolSpecificMetadata().getServiceType()) {
            case ODATA_V2: {
                artifactIdCoreLib = ARTIFACT_ID_CORE_LIB_V2;
                artifactIdGeneratorPlugin = ARTIFACT_ID_GENERATOR_V2;
                break;
            }
            case ODATA_V4: {
                artifactIdCoreLib = ARTIFACT_ID_CORE_LIB_V4;
                artifactIdGeneratorPlugin = ARTIFACT_ID_GENERATOR_V4;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected service type " + (Object)((Object)datamodelMetadataInput.getProtocolSpecificMetadata().getServiceType()) + " .");
            }
        }
        String latestGeneratorVersion = (String)Option.of((Object)this.inputProperties.getGeneratorVersion()).getOrElse(() -> (String)this.mavenRepositoryAccessor.getLatestModuleVersion(MavenCoordinate.builder().groupId(GROUP_ID_CORE_LIB).artifactId(artifactIdGeneratorPlugin).build()).getOrElseThrow(cause -> new MetadataGenerationException("Failure determining latest generator version", (Throwable)cause)));
        return "<ul><li>Install Apache Maven version 3.5.0 or above.</li><li><p>Run the command below to initialize a Java Maven project using the SAP Cloud SDK <a href=\"https://sap.github.io/cloud-sdk/docs/java/getting-started/#generating-a-project-from-a-maven-archetype\">Maven Archetype</a>.</p><p><code><b>mvn archetype:generate \"-DarchetypeGroupId=com.sap.cloud.sdk.archetypes\" \n \"-DarchetypeArtifactId=scp-cf-spring\" \n \"-DarchetypeVersion=RELEASE\"</b></code></p></li><li>Download the API specification from <b>Overview</b> -> <b>API Specification</b> section. Chose <i>EDMX</i> format.</li><li>Put the specification inside your project folder to <b>&lt;project_root&gt;/edmx</b></li><li><p>Add these dependencies into your <b>pom.xml</b>.</p><p><code><pre> &lt;dependency&gt;\n      &lt;groupId&gt;com.sap.cloud.sdk.datamodel&lt;/groupId&gt;\n      &lt;artifactId&gt;" + artifactIdCoreLib + "&lt;/artifactId&gt;\n  &lt;/dependency&gt;\n  &lt;dependency&gt;\n      &lt;groupId&gt;org.projectlombok&lt;/groupId&gt;\n      &lt;artifactId&gt;lombok&lt;/artifactId&gt;\n      &lt;scope&gt;provided&lt;/scope&gt;\n  &lt;/dependency&gt;\n  &lt;dependency&gt;\n      &lt;groupId&gt;javax.inject&lt;/groupId&gt;\n      &lt;artifactId&gt;javax.inject&lt;/artifactId&gt;\n      &lt;scope&gt;provided&lt;/scope&gt;\n  &lt;/dependency&gt;</pre></code></p></li><li><p>Under the <i>plugins</i> section in your <b>pom.xml</b> add the generator plugin for OData. Review the <i>configuration</i> section of the plugin to make sure <i>inputDirectory</i> points at the directory where the specification is stored. Generated classes will be stored in the directory specified by <i>outputDirectory</i>. Set other configuration parameters to your preferences or leave them as is.</p><p><code><pre> &lt;plugin&gt;\n      &lt;groupId&gt;" + GROUP_ID_CORE_LIB + "&lt;/groupId&gt;\n      &lt;artifactId&gt;" + artifactIdGeneratorPlugin + "&lt;/artifactId&gt;\n      &lt;!-- Please use always the latest version. You can find it on this page.--&gt;\n      &lt;version&gt;" + latestGeneratorVersion + "&lt;/version&gt;\n      &lt;executions&gt;\n          &lt;execution&gt;\n              &lt;id&gt;generate-consumption&lt;/id&gt;\n              &lt;phase&gt;generate-sources&lt;/phase&gt;\n              &lt;goals&gt;\n                  &lt;goal&gt;generate&lt;/goal&gt;\n              &lt;/goals&gt;\n              &lt;configuration&gt;\n                  &lt;inputDirectory&gt;${project.basedir}/edmx&lt;/inputDirectory&gt;\n                  &lt;outputDirectory&gt;${project.build.directory}/vdm&lt;/outputDirectory&gt;\n                  &lt;deleteOutputDirectory&gt;true&lt;/deleteOutputDirectory&gt;\n                  &lt;packageName&gt;com.mycompany.vdm&lt;/packageName&gt;\n                  &lt;defaultBasePath&gt;odata/v4/&lt;/defaultBasePath&gt;\n                  &lt;compileScope&gt;COMPILE&lt;/compileScope&gt;\n                  &lt;serviceMethodsPerEntitySet&gt;true&lt;/serviceMethodsPerEntitySet&gt;\n              &lt;/configuration&gt;\n          &lt;/execution&gt;\n      &lt;/executions&gt;\n  &lt;/plugin&gt;</pre></code></p></li><li>Run <code><b>mvn clean install</b></code> in the root folder of your project.</li><li>You should now find generated classes in the output directory specified in your generator maven plugin configuration from step 6. By default it is &lt;project_root&gt;/vdm.</li><li>In case of any issues carefully check your configuration and refer to our <a href=\"https://sap.github.io/cloud-sdk/docs/java/features/odata/generate-typed-odata-v2-and-v4-client-for-java\">extended typed client generation manual.</a></li><li>Congratulations! Check the usage example below to import and invoke your typed OData client library.</li></ul>";
    }

    @Override
    @Nonnull
    public String getGenericUsage(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return "result = service.operation()\n.withParameter(...)\n.execute(destination);";
    }

    @Override
    @Nonnull
    public Option<String> getApiSpecificUsage(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        if (datamodelMetadataInput.getProtocolSpecificMetadata().getApiUsageMetadata() == null) {
            return Option.none();
        }
        if (!(datamodelMetadataInput.getProtocolSpecificMetadata().getApiUsageMetadata() instanceof ODataApiUsageMetadata)) {
            throw new IllegalStateException("Instance of " + ODataApiUsageMetadata.class + " expected.");
        }
        ODataApiUsageMetadata oDataApiUsageMetadata = (ODataApiUsageMetadata)datamodelMetadataInput.getProtocolSpecificMetadata().getApiUsageMetadata();
        String usageSnippet = MetadataApiSpecificUsage.builder().initialValue(new MetadataApiSpecificUsage.Declaration("destination", HttpDestination.class.getName(), "DestinationAccessor.getDestination(\"MyDestination\").asHttp()")).enforceImport(DestinationAccessor.class.getName()).data(oDataApiUsageMetadata).build().getUsage();
        return Option.of((Object)usageSnippet);
    }

    @Override
    @Nonnull
    public DatamodelMetadataOutput.UrlWithName getGenerationManual(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return DatamodelMetadataOutput.UrlWithName.builder().url(URI.create("https://sap.github.io/cloud-sdk/docs/java/features/odata/generate-typed-odata-v2-and-v4-client-for-java")).name("OData Client Generation Manual").build();
    }

    @Override
    @Nonnull
    public DatamodelMetadataOutput.UrlWithName getOverviewDocumentationUrlWithName(@Nonnull DatamodelMetadataInput datamodelMetadataInput) {
        return DatamodelMetadataOutput.UrlWithName.builder().url(URI.create("https://sap.github.io/cloud-sdk/docs/java/features/odata/overview")).name("OData Consumption Manual").build();
    }

    @Generated
    public ODataDatamodelMetadataProvider(InputProperties inputProperties, MavenRepositoryAccessor mavenRepositoryAccessor) {
        this.inputProperties = inputProperties;
        this.mavenRepositoryAccessor = mavenRepositoryAccessor;
    }
}

