/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.sap.cloud.sdk.datamodel.metadata.generator.ApiUsageMetadata;
import com.sap.cloud.sdk.datamodel.metadata.generator.JavaClassExplorer;
import com.sap.cloud.sdk.datamodel.metadata.generator.JavaClassFromClasspath;
import com.sap.cloud.sdk.datamodel.metadata.generator.JavaClassFromParser;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaServiceMethodResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaServiceMethodResolver.class);
    @Nonnull
    private final List<ApiUsageMetadata.Invocation> invocations;
    @Nonnull
    private final String resultType;

    @Nonnull
    private static Optional<JavaServiceMethodResolver> resolve(@Nonnull Path sourceDirectory, @Nonnull String qualifiedServiceName, @Nullable String[] priorityByMethodNamePrefix, @Nullable ApiUsageMetadata.Invocation finalMethod, @Nonnull List<AdditionalInvocation> additionalInvocations, @Nonnull Set<String> excludedMethodNames) {
        MethodPrioritySelector prioritySelector;
        JavaClassExplorer explorer = JavaClassExplorer.of(new JavaClassFromClasspath(), new JavaClassFromParser(sourceDirectory));
        JavaClassExplorer.ExploredMethod method = JavaServiceMethodResolver.lookupMethod(explorer, qualifiedServiceName, prioritySelector = new MethodPrioritySelector(priorityByMethodNamePrefix, excludedMethodNames), new ArrayList<JavaClassExplorer.ExploredType>());
        if (method == null) {
            log.debug("No suitable method found.");
            return Optional.empty();
        }
        JavaClassExplorer.ExploredType methodResultType = method.getResultType();
        String resultType = methodResultType.getFullName();
        ArrayList<ApiUsageMetadata.Invocation> invocations = new ArrayList<ApiUsageMetadata.Invocation>();
        invocations.add(JavaServiceMethodResolver.getInvocationFromMethod(method));
        invocations.addAll(JavaServiceMethodResolver.getInvocationsByPrefix(prioritySelector.getMethodPrefix(method), additionalInvocations));
        if (finalMethod != null) {
            MethodBySignatureSelector signatureSelector = new MethodBySignatureSelector(finalMethod);
            JavaClassExplorer.ExploredMethod finalMethodLookup = JavaServiceMethodResolver.lookupMethod(explorer, methodResultType.getName(), signatureSelector, methodResultType.getParameters());
            if (finalMethodLookup != null) {
                invocations.add(finalMethod);
                resultType = finalMethodLookup.getResultType().getFullName();
            }
        }
        return Optional.of(new JavaServiceMethodResolver(invocations, resultType));
    }

    private static ApiUsageMetadata.Invocation getInvocationFromMethod(JavaClassExplorer.ExploredMethod method) {
        ApiUsageMetadata.Invocation invocation = ApiUsageMetadata.method(method.getName());
        for (Map.Entry<String, JavaClassExplorer.ExploredType> argEntry : method.getArguments().entrySet()) {
            invocation = invocation.arg(argEntry.getKey(), argEntry.getValue().getFullName());
        }
        return invocation;
    }

    @Nullable
    private static JavaClassExplorer.ExploredMethod lookupMethod(JavaClassExplorer javaExplorer, String qualifiedServiceName, MethodSelector selector, List<JavaClassExplorer.ExploredType> typeArguments) {
        Optional<JavaClassExplorer.ExploredClass> cl = javaExplorer.getClassByName(qualifiedServiceName, typeArguments);
        List methods = cl.map(JavaClassExplorer.ExploredClass::getMethods).orElseGet(Collections::emptyList);
        return selector.select(methods);
    }

    @Nonnull
    private static List<ApiUsageMetadata.Invocation> getInvocationsByPrefix(@Nullable String methodPrefix, @Nonnull List<AdditionalInvocation> additionalInvocations) {
        return methodPrefix == null ? Collections.emptyList() : additionalInvocations.stream().filter(inv -> Objects.equals(((AdditionalInvocation)inv).prefix, methodPrefix)).flatMap(a -> ((AdditionalInvocation)a).invocations.stream()).collect(Collectors.toList());
    }

    @Nonnull
    public static AdditionalInvocation forPrefix(@Nonnull String prefix) {
        return new AdditionalInvocation(prefix);
    }

    @Nonnull
    @Generated
    public static OptionalBuilder builder() {
        return new OptionalBuilder();
    }

    @Generated
    private JavaServiceMethodResolver(@Nonnull List<ApiUsageMetadata.Invocation> invocations, @Nonnull String resultType) {
        if (invocations == null) {
            throw new NullPointerException("invocations is marked non-null but is null");
        }
        if (resultType == null) {
            throw new NullPointerException("resultType is marked non-null but is null");
        }
        this.invocations = invocations;
        this.resultType = resultType;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "JavaServiceMethodResolver(invocations=" + this.getInvocations() + ", resultType=" + this.getResultType() + ")";
    }

    @Nonnull
    @Generated
    public List<ApiUsageMetadata.Invocation> getInvocations() {
        return this.invocations;
    }

    @Nonnull
    @Generated
    public String getResultType() {
        return this.resultType;
    }

    @Generated
    public static class OptionalBuilder {
        @Generated
        private Path sourceDirectory;
        @Generated
        private String qualifiedServiceName;
        @Generated
        private String[] priorityByMethodNamePrefix;
        @Generated
        private ApiUsageMetadata.Invocation finalMethod;
        @Generated
        private ArrayList<AdditionalInvocation> additionalInvocations;
        @Generated
        private ArrayList<String> excludedMethodNames;

        @Generated
        OptionalBuilder() {
        }

        @Nonnull
        @Generated
        public OptionalBuilder sourceDirectory(@Nonnull Path sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        @Nonnull
        @Generated
        public OptionalBuilder qualifiedServiceName(@Nonnull String qualifiedServiceName) {
            this.qualifiedServiceName = qualifiedServiceName;
            return this;
        }

        @Nonnull
        @Generated
        public OptionalBuilder priorityByMethodNamePrefix(@Nullable String[] priorityByMethodNamePrefix) {
            this.priorityByMethodNamePrefix = priorityByMethodNamePrefix;
            return this;
        }

        @Nonnull
        @Generated
        public OptionalBuilder finalMethod(@Nullable ApiUsageMetadata.Invocation finalMethod) {
            this.finalMethod = finalMethod;
            return this;
        }

        @Nonnull
        @Generated
        public OptionalBuilder additionalInvocation(AdditionalInvocation additionalInvocation) {
            if (this.additionalInvocations == null) {
                this.additionalInvocations = new ArrayList();
            }
            this.additionalInvocations.add(additionalInvocation);
            return this;
        }

        @Nonnull
        @Generated
        public OptionalBuilder additionalInvocations(@Nonnull Collection<? extends AdditionalInvocation> additionalInvocations) {
            if (additionalInvocations == null) {
                throw new NullPointerException("additionalInvocations cannot be null");
            }
            if (this.additionalInvocations == null) {
                this.additionalInvocations = new ArrayList();
            }
            this.additionalInvocations.addAll(additionalInvocations);
            return this;
        }

        @Nonnull
        @Generated
        public OptionalBuilder clearAdditionalInvocations() {
            if (this.additionalInvocations != null) {
                this.additionalInvocations.clear();
            }
            return this;
        }

        @Nonnull
        @Generated
        public OptionalBuilder excludedMethodName(String excludedMethodName) {
            if (this.excludedMethodNames == null) {
                this.excludedMethodNames = new ArrayList();
            }
            this.excludedMethodNames.add(excludedMethodName);
            return this;
        }

        @Nonnull
        @Generated
        public OptionalBuilder excludedMethodNames(@Nonnull Collection<? extends String> excludedMethodNames) {
            if (excludedMethodNames == null) {
                throw new NullPointerException("excludedMethodNames cannot be null");
            }
            if (this.excludedMethodNames == null) {
                this.excludedMethodNames = new ArrayList();
            }
            this.excludedMethodNames.addAll(excludedMethodNames);
            return this;
        }

        @Nonnull
        @Generated
        public OptionalBuilder clearExcludedMethodNames() {
            if (this.excludedMethodNames != null) {
                this.excludedMethodNames.clear();
            }
            return this;
        }

        @Generated
        public Optional<JavaServiceMethodResolver> build() {
            Set<Object> excludedMethodNames;
            List<Object> additionalInvocations;
            switch (this.additionalInvocations == null ? 0 : this.additionalInvocations.size()) {
                case 0: {
                    additionalInvocations = Collections.emptyList();
                    break;
                }
                case 1: {
                    additionalInvocations = Collections.singletonList(this.additionalInvocations.get(0));
                    break;
                }
                default: {
                    additionalInvocations = Collections.unmodifiableList(new ArrayList<AdditionalInvocation>(this.additionalInvocations));
                }
            }
            switch (this.excludedMethodNames == null ? 0 : this.excludedMethodNames.size()) {
                case 0: {
                    excludedMethodNames = Collections.emptySet();
                    break;
                }
                case 1: {
                    excludedMethodNames = Collections.singleton(this.excludedMethodNames.get(0));
                    break;
                }
                default: {
                    excludedMethodNames = new LinkedHashSet(this.excludedMethodNames.size() < 0x40000000 ? 1 + this.excludedMethodNames.size() + (this.excludedMethodNames.size() - 3) / 3 : Integer.MAX_VALUE);
                    excludedMethodNames.addAll(this.excludedMethodNames);
                    excludedMethodNames = Collections.unmodifiableSet(excludedMethodNames);
                }
            }
            return JavaServiceMethodResolver.resolve(this.sourceDirectory, this.qualifiedServiceName, this.priorityByMethodNamePrefix, this.finalMethod, additionalInvocations, excludedMethodNames);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "JavaServiceMethodResolver.OptionalBuilder(sourceDirectory=" + this.sourceDirectory + ", qualifiedServiceName=" + this.qualifiedServiceName + ", priorityByMethodNamePrefix=" + Arrays.deepToString(this.priorityByMethodNamePrefix) + ", finalMethod=" + this.finalMethod + ", additionalInvocations=" + this.additionalInvocations + ", excludedMethodNames=" + this.excludedMethodNames + ")";
        }
    }

    private static final class MethodBySignatureSelector
    implements MethodSelector {
        @Nullable
        private final ApiUsageMetadata.Invocation target;

        @Override
        @Nullable
        public JavaClassExplorer.ExploredMethod select(@Nonnull Collection<JavaClassExplorer.ExploredMethod> candidates) {
            if (this.target == null) {
                return null;
            }
            int argumentSize = this.target.getArguments().size();
            return candidates.stream().filter(m -> this.target.getMethod().equals(m.getName())).filter(m -> m.getArguments().size() == argumentSize).filter(m -> IntStream.range(0, argumentSize).allMatch(i -> this.isAssignableArgument((JavaClassExplorer.ExploredMethod)m, i))).min(this::compareResultTypes).orElse(null);
        }

        private int compareResultTypes(JavaClassExplorer.ExploredMethod a, JavaClassExplorer.ExploredMethod b) {
            if (Objects.equals(a.getResultType(), b.getResultType())) {
                return 0;
            }
            Try aTry = Try.of((CheckedFunction0 & Serializable)() -> Class.forName(a.getResultType().getName()));
            if (aTry.contains(Object.class)) {
                return 1;
            }
            Try bTry = Try.of((CheckedFunction0 & Serializable)() -> Class.forName(b.getResultType().getName()));
            if (bTry.contains(Object.class)) {
                return -1;
            }
            if (aTry.isSuccess() && bTry.isSuccess()) {
                return ((Class)aTry.get()).isAssignableFrom((Class)bTry.get()) ? 1 : -1;
            }
            return 0;
        }

        private boolean isAssignableArgument(JavaClassExplorer.ExploredMethod m, int i) {
            if (this.target == null) {
                return false;
            }
            ApiUsageMetadata.MethodArgumentDynamic finalMethodArg = (ApiUsageMetadata.MethodArgumentDynamic)this.target.getArguments().get(i);
            String searchMethodArgType = new ArrayList<JavaClassExplorer.ExploredType>(m.getArguments().values()).get(i).getName();
            Try aTry = Try.of((CheckedFunction0 & Serializable)() -> Class.forName(searchMethodArgType));
            Try bTry = Try.of((CheckedFunction0 & Serializable)() -> Class.forName(finalMethodArg.getTypeName()));
            return aTry.isSuccess() && bTry.isSuccess() && ((Class)aTry.get()).isAssignableFrom((Class)bTry.get());
        }

        @Generated
        public MethodBySignatureSelector(@Nullable ApiUsageMetadata.Invocation target) {
            this.target = target;
        }

        @Nullable
        @Generated
        public ApiUsageMetadata.Invocation getTarget() {
            return this.target;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodBySignatureSelector)) {
                return false;
            }
            MethodBySignatureSelector other = (MethodBySignatureSelector)o;
            ApiUsageMetadata.Invocation this$target = this.getTarget();
            ApiUsageMetadata.Invocation other$target = other.getTarget();
            return !(this$target == null ? other$target != null : !((Object)this$target).equals(other$target));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ApiUsageMetadata.Invocation $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "JavaServiceMethodResolver.MethodBySignatureSelector(target=" + this.getTarget() + ")";
        }
    }

    private static final class MethodPrioritySelector
    implements MethodSelector {
        private static ToIntFunction<JavaClassExplorer.ExploredMethod> methodToArgumentSize = m -> m.getArguments().size();
        private static ToIntFunction<JavaClassExplorer.ExploredMethod> methodToNameLength = m -> m.getName().length();
        @Nullable
        private final String[] priorityByMethodNamePrefix;
        @Nonnull
        private final Set<String> excludedMethodNames;

        @Override
        @Nullable
        public JavaClassExplorer.ExploredMethod select(@Nonnull Collection<JavaClassExplorer.ExploredMethod> methods) {
            Comparator<JavaClassExplorer.ExploredMethod> methodComparator = Comparator.comparingInt(this::getMethodNamePriorityIndex).thenComparingInt(methodToArgumentSize).thenComparingInt(methodToNameLength);
            ArrayList<JavaClassExplorer.ExploredMethod> filteredMethods = new ArrayList<JavaClassExplorer.ExploredMethod>(methods);
            filteredMethods.removeIf(m -> this.excludedMethodNames.contains(m.getName()));
            return filteredMethods.isEmpty() ? null : Collections.min(filteredMethods, methodComparator);
        }

        private int getMethodNamePriorityIndex(JavaClassExplorer.ExploredMethod method) {
            if (this.priorityByMethodNamePrefix == null) {
                return 0;
            }
            return IntStream.range(0, this.priorityByMethodNamePrefix.length).filter(i -> method.getName().startsWith(this.priorityByMethodNamePrefix[i])).findFirst().orElse(Integer.MAX_VALUE);
        }

        private String getMethodPrefix(JavaClassExplorer.ExploredMethod method) {
            if (this.priorityByMethodNamePrefix == null) {
                return null;
            }
            int index = this.getMethodNamePriorityIndex(method);
            return index < this.priorityByMethodNamePrefix.length ? this.priorityByMethodNamePrefix[index] : null;
        }

        @Generated
        public MethodPrioritySelector(@Nullable String[] priorityByMethodNamePrefix, @Nonnull Set<String> excludedMethodNames) {
            if (excludedMethodNames == null) {
                throw new NullPointerException("excludedMethodNames is marked non-null but is null");
            }
            this.priorityByMethodNamePrefix = priorityByMethodNamePrefix;
            this.excludedMethodNames = excludedMethodNames;
        }

        @Nullable
        @Generated
        public String[] getPriorityByMethodNamePrefix() {
            return this.priorityByMethodNamePrefix;
        }

        @Nonnull
        @Generated
        public Set<String> getExcludedMethodNames() {
            return this.excludedMethodNames;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodPrioritySelector)) {
                return false;
            }
            MethodPrioritySelector other = (MethodPrioritySelector)o;
            if (!Arrays.deepEquals(this.getPriorityByMethodNamePrefix(), other.getPriorityByMethodNamePrefix())) {
                return false;
            }
            Set<String> this$excludedMethodNames = this.getExcludedMethodNames();
            Set<String> other$excludedMethodNames = other.getExcludedMethodNames();
            return !(this$excludedMethodNames == null ? other$excludedMethodNames != null : !((Object)this$excludedMethodNames).equals(other$excludedMethodNames));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getPriorityByMethodNamePrefix());
            Set<String> $excludedMethodNames = this.getExcludedMethodNames();
            result = result * 59 + ($excludedMethodNames == null ? 43 : ((Object)$excludedMethodNames).hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "JavaServiceMethodResolver.MethodPrioritySelector(priorityByMethodNamePrefix=" + Arrays.deepToString(this.getPriorityByMethodNamePrefix()) + ", excludedMethodNames=" + this.getExcludedMethodNames() + ")";
        }
    }

    public static class AdditionalInvocation {
        private final String prefix;
        private final List<ApiUsageMetadata.Invocation> invocations = new ArrayList<ApiUsageMetadata.Invocation>();

        @Nonnull
        public AdditionalInvocation add(@Nonnull ApiUsageMetadata.Invocation invocation) {
            this.invocations.add(invocation);
            return this;
        }

        @Generated
        private AdditionalInvocation(String prefix) {
            this.prefix = prefix;
        }
    }

    static interface MethodSelector {
        @Nullable
        public JavaClassExplorer.ExploredMethod select(@Nonnull Collection<JavaClassExplorer.ExploredMethod> var1);
    }
}

