/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.sap.cloud.sdk.datamodel.metadata.generator.JavaClassExplorer;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaParameterizedType;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.JavaWildcardType;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaClassFromParser
implements JavaClassExplorer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaClassFromParser.class);
    @Nonnull
    private final Path sourcePath;

    @Override
    @Nonnull
    public Optional<JavaClassExplorer.ExploredClass> getClassByName(@Nonnull String name, @Nonnull List<JavaClassExplorer.ExploredType> genericTypeValues, @Nonnull JavaClassExplorer callback) {
        Try javaClass = Try.of((CheckedFunction0 & Serializable)() -> this.parseClass(this.sourcePath, name));
        if (javaClass.isFailure()) {
            return Optional.empty();
        }
        Map<String, JavaClassExplorer.ExploredType> genericMapping = JavaClassFromParser.getGenericMapping((JavaClass)javaClass.get(), genericTypeValues);
        if (genericMapping == null) {
            return Optional.empty();
        }
        JavaClassExplorer.ExploredClass exploredClass = JavaClassFromParser.getClassFromReference((JavaClass)javaClass.get(), genericTypeValues, genericMapping);
        JavaClassExplorer.ExploredClass exploredSuperClass = JavaClassFromParser.exploreSuperClass((JavaClass)javaClass.get(), genericMapping, callback);
        JavaClassExplorer.ExploredClass mergedClass = JavaClassExplorer.mergeMethods(exploredClass, exploredSuperClass);
        return Optional.of(mergedClass);
    }

    @Nullable
    private static JavaClassExplorer.ExploredClass exploreSuperClass(@Nonnull JavaClass child, @Nonnull Map<String, JavaClassExplorer.ExploredType> genericMapping, @Nonnull JavaClassExplorer callback) {
        JavaType classReference = child.getSuperClass();
        if (classReference == null) {
            return null;
        }
        JavaClassExplorer.ExploredType type = JavaClassFromParser.getActualTypeArguments(child.getPackageName(), classReference, genericMapping);
        Optional<JavaClassExplorer.ExploredClass> exploredClass = callback.getClassByName(type.getName(), type.getParameters());
        return exploredClass.orElseGet(() -> {
            log.warn("Parent class {} could not be loaded.", (Object)type.getName());
            return null;
        });
    }

    @Nonnull
    private static JavaClassExplorer.ExploredClass getClassFromReference(@Nonnull JavaClass javaClass, @Nonnull List<JavaClassExplorer.ExploredType> genericTypeValues, @Nonnull Map<String, JavaClassExplorer.ExploredType> genericMapping) {
        String name = javaClass.getFullyQualifiedName();
        List<JavaClassExplorer.ExploredMethod> methods = javaClass.getMethods().stream().filter(m -> javaClass.isInterface() || m.getModifiers().contains("public")).map(m -> JavaClassFromParser.createMethod(javaClass, genericMapping, m)).collect(Collectors.toList());
        return new JavaClassExplorer.ExploredClass(new JavaClassExplorer.ExploredType(name, genericTypeValues), methods);
    }

    @Nonnull
    private static JavaClassExplorer.ExploredMethod createMethod(JavaClass javaClass, Map<String, JavaClassExplorer.ExploredType> genericMapping, JavaMethod m) {
        String packageName = javaClass.getPackageName();
        JavaClassExplorer.ExploredType returnType = JavaClassFromParser.createType(m.getReturnType(), packageName, genericMapping);
        Function<JavaParameter, JavaClassExplorer.ExploredType> parseParameterType = p -> JavaClassFromParser.createType(p.getType(), packageName, genericMapping);
        LinkedHashMap arguments = m.getParameters().stream().collect(Collectors.toMap(JavaParameter::getName, parseParameterType, (o1, o2) -> o1, LinkedHashMap::new));
        return new JavaClassExplorer.ExploredMethod(m.getName(), returnType, arguments);
    }

    @Nonnull
    private JavaClass parseClass(Path path, String fullName) throws IOException {
        String relativeLegacyClassPath = fullName.replace(".", File.separator) + ".java";
        File legacyClassFile = path.resolve(relativeLegacyClassPath).toFile();
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        return (JavaClass)javaProjectBuilder.addSource(legacyClassFile).getClasses().get(0);
    }

    @Nonnull
    private static JavaClassExplorer.ExploredType createType(JavaType returnType, String packageName, Map<String, JavaClassExplorer.ExploredType> genericMapping) {
        if (returnType instanceof JavaParameterizedType) {
            return JavaClassFromParser.getActualTypeArguments(packageName, returnType, genericMapping);
        }
        if (returnType instanceof JavaTypeVariable) {
            JavaClassExplorer.ExploredType returnCandidate = genericMapping.get(((JavaTypeVariable)returnType).getName());
            return returnCandidate != null ? returnCandidate : new JavaClassExplorer.ExploredType(Object.class.getName());
        }
        if (returnType instanceof JavaWildcardType) {
            return new JavaClassExplorer.ExploredType("?");
        }
        return new JavaClassExplorer.ExploredType(returnType.getGenericFullyQualifiedName());
    }

    private static JavaClassExplorer.ExploredType getActualTypeArguments(String packageName, JavaType type, Map<String, JavaClassExplorer.ExploredType> map) {
        String name = JavaClassExplorer.ensureNamespace(packageName, type.getFullyQualifiedName());
        if (!(type instanceof JavaParameterizedType)) {
            return new JavaClassExplorer.ExploredType(name);
        }
        List<JavaClassExplorer.ExploredType> params = ((JavaParameterizedType)type).getActualTypeArguments().stream().map(t -> map.containsKey(t.getValue()) ? (JavaClassExplorer.ExploredType)map.get(t.getValue()) : new JavaClassExplorer.ExploredType(JavaClassExplorer.ensureNamespace(packageName, t.getGenericFullyQualifiedName()))).collect(Collectors.toList());
        return new JavaClassExplorer.ExploredType(name, params);
    }

    @Nullable
    private static Map<String, JavaClassExplorer.ExploredType> getGenericMapping(@Nonnull JavaClass cl, @Nonnull List<JavaClassExplorer.ExploredType> genericValues) {
        List typeParameters = cl.getTypeParameters();
        if (typeParameters.size() != genericValues.size()) {
            log.debug("Number of generic type parameters {} does not fit the caller signature: {}", (Object)typeParameters.size(), genericValues);
            return null;
        }
        HashMap<String, JavaClassExplorer.ExploredType> genericMapping = new HashMap<String, JavaClassExplorer.ExploredType>();
        for (int i = 0; i < typeParameters.size(); ++i) {
            genericMapping.put(((JavaTypeVariable)typeParameters.get(i)).getName(), genericValues.get(i));
        }
        return genericMapping;
    }

    @Generated
    public JavaClassFromParser(@Nonnull Path sourcePath) {
        if (sourcePath == null) {
            throw new NullPointerException("sourcePath is marked non-null but is null");
        }
        this.sourcePath = sourcePath;
    }

    @Nonnull
    @Generated
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaClassFromParser)) {
            return false;
        }
        JavaClassFromParser other = (JavaClassFromParser)o;
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        return !(this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "JavaClassFromParser(sourcePath=" + this.getSourcePath() + ")";
    }
}

