/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import com.sap.cloud.sdk.datamodel.metadata.generator.JavaClassExplorer;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaClassFromClasspath
implements JavaClassExplorer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaClassFromClasspath.class);

    @Override
    @Nonnull
    public Optional<JavaClassExplorer.ExploredClass> getClassByName(@Nonnull String name, @Nonnull List<JavaClassExplorer.ExploredType> genericTypeValues, @Nonnull JavaClassExplorer callback) {
        String binaryName = name.replaceAll("([A-Z].*?)\\.", "$1\\$");
        Try loadedClass = Try.of((CheckedFunction0 & Serializable)() -> Class.forName(binaryName));
        if (loadedClass.isFailure()) {
            return Optional.empty();
        }
        Map<String, JavaClassExplorer.ExploredType> genericMapping = JavaClassFromClasspath.getGenericMapping((Class)loadedClass.get(), genericTypeValues);
        if (genericMapping == null) {
            return Optional.empty();
        }
        JavaClassExplorer.ExploredClass exploredClass = JavaClassFromClasspath.getClassFromReference((Class)loadedClass.get(), genericTypeValues, genericMapping);
        JavaClassExplorer.ExploredClass exploredSuperClass = JavaClassFromClasspath.exploreSuperClass((Class)loadedClass.get(), genericMapping, callback);
        JavaClassExplorer.ExploredClass mergedClass = JavaClassExplorer.mergeMethods(exploredClass, exploredSuperClass);
        return Optional.of(mergedClass);
    }

    @Nonnull
    private static JavaClassExplorer.ExploredClass getClassFromReference(@Nonnull Class<?> type, @Nonnull List<JavaClassExplorer.ExploredType> genericTypeValues, @Nonnull Map<String, JavaClassExplorer.ExploredType> genericMapping) {
        String name = type.getCanonicalName();
        List<JavaClassExplorer.ExploredMethod> methods = Stream.of(type.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).map(m -> JavaClassFromClasspath.createMethod(m, genericMapping)).collect(Collectors.toList());
        return new JavaClassExplorer.ExploredClass(new JavaClassExplorer.ExploredType(name, genericTypeValues), methods);
    }

    @Nullable
    private static JavaClassExplorer.ExploredClass exploreSuperClass(@Nonnull Class<?> child, @Nonnull Map<String, JavaClassExplorer.ExploredType> genericMapping, @Nonnull JavaClassExplorer callback) {
        Type classReference = child.getGenericSuperclass();
        if (classReference == null || classReference == Object.class) {
            return null;
        }
        JavaClassExplorer.ExploredType type = JavaClassFromClasspath.getActualTypeArguments(classReference, genericMapping);
        Optional<JavaClassExplorer.ExploredClass> exploredClass = callback.getClassByName(type.getName(), type.getParameters());
        return exploredClass.orElseGet(() -> {
            log.warn("Parent class {} could not be loaded.", (Object)type.getName());
            return null;
        });
    }

    @Nonnull
    private static JavaClassExplorer.ExploredMethod createMethod(@Nonnull Method method, @Nonnull Map<String, JavaClassExplorer.ExploredType> genericMapping) {
        JavaClassExplorer.ExploredType returnType = JavaClassFromClasspath.createType(method.getGenericReturnType(), genericMapping);
        Function<Parameter, JavaClassExplorer.ExploredType> parameterToType = p -> JavaClassFromClasspath.createType(p.getType(), genericMapping);
        LinkedHashMap arguments = Stream.of(method.getParameters()).collect(Collectors.toMap(Parameter::getName, parameterToType, (o1, o2) -> o1, LinkedHashMap::new));
        return new JavaClassExplorer.ExploredMethod(method.getName(), returnType, arguments);
    }

    @Nonnull
    private static JavaClassExplorer.ExploredType createType(@Nonnull Type returnType, @Nonnull Map<String, JavaClassExplorer.ExploredType> genericMapping) {
        if (returnType instanceof ParameterizedType) {
            return JavaClassFromClasspath.getActualTypeArguments(returnType, genericMapping);
        }
        if (returnType instanceof TypeVariable) {
            String variableName = ((TypeVariable)returnType).getName();
            JavaClassExplorer.ExploredType returnCandidate = genericMapping.get(variableName);
            return returnCandidate != null ? returnCandidate : new JavaClassExplorer.ExploredType(Object.class.getName());
        }
        if (returnType instanceof WildcardType) {
            return new JavaClassExplorer.ExploredType("?");
        }
        return new JavaClassExplorer.ExploredType(returnType.getTypeName().replace('$', '.'));
    }

    @Nonnull
    private static JavaClassExplorer.ExploredType getActualTypeArguments(@Nonnull Type type, @Nonnull Map<String, JavaClassExplorer.ExploredType> genericMapping) {
        if (!(type instanceof ParameterizedType)) {
            return new JavaClassExplorer.ExploredType(type.getTypeName());
        }
        List<JavaClassExplorer.ExploredType> params = Stream.of(((ParameterizedType)type).getActualTypeArguments()).map(t -> t instanceof TypeVariable ? (JavaClassExplorer.ExploredType)genericMapping.get(((TypeVariable)t).getName()) : new JavaClassExplorer.ExploredType(t.getTypeName())).collect(Collectors.toList());
        return new JavaClassExplorer.ExploredType(((ParameterizedType)type).getRawType().getTypeName().replace('$', '.'), params);
    }

    @Nullable
    private static Map<String, JavaClassExplorer.ExploredType> getGenericMapping(@Nonnull Class<?> cl, @Nonnull List<JavaClassExplorer.ExploredType> genericValues) {
        TypeVariable<Class<?>>[] typeParameters = cl.getTypeParameters();
        if (typeParameters.length != genericValues.size()) {
            log.debug("Number of generic type parameters {} does not fit the caller signature: {}", (Object)typeParameters.length, genericValues);
            return null;
        }
        HashMap<String, JavaClassExplorer.ExploredType> genericMapping = new HashMap<String, JavaClassExplorer.ExploredType>();
        for (int i = 0; i < typeParameters.length; ++i) {
            genericMapping.put(typeParameters[i].getName(), genericValues.get(i));
        }
        return genericMapping;
    }

    @Generated
    public JavaClassFromClasspath() {
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof JavaClassFromClasspath;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "JavaClassFromClasspath()";
    }
}

