/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.metadata.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@FunctionalInterface
interface JavaClassExplorer {
    @Nonnull
    public Optional<ExploredClass> getClassByName(@Nonnull String var1, @Nonnull List<ExploredType> var2, @Nonnull JavaClassExplorer var3);

    @Nonnull
    default public Optional<ExploredClass> getClassByName(@Nonnull String name, @Nonnull List<ExploredType> genericTypeValues) {
        return this.getClassByName(name, genericTypeValues, this);
    }

    @Nonnull
    public static JavaClassExplorer of(JavaClassExplorer ... explorers) {
        return (name, typeValues, callback) -> Stream.of(explorers).map(ex -> ex.getClassByName(name, typeValues, callback)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Nonnull
    public static String ensureNamespace(@Nonnull String packageName, @Nonnull String className) {
        return className.contains(".") || packageName.isEmpty() ? className : packageName + "." + className;
    }

    @Nonnull
    public static ExploredClass mergeMethods(@Nonnull ExploredClass thisClass, @Nullable ExploredClass otherClass) {
        if (otherClass == null) {
            return thisClass;
        }
        ArrayList<ExploredMethod> methods = new ArrayList<ExploredMethod>(thisClass.getMethods());
        methods.addAll(otherClass.getMethods());
        return new ExploredClass(thisClass.getType(), methods);
    }

    public static final class ExploredClass {
        @Nonnull
        private final ExploredType type;
        @Nonnull
        private final List<ExploredMethod> methods;

        @Generated
        public ExploredClass(@Nonnull ExploredType type, @Nonnull List<ExploredMethod> methods) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (methods == null) {
                throw new NullPointerException("methods is marked non-null but is null");
            }
            this.type = type;
            this.methods = methods;
        }

        @Nonnull
        @Generated
        public ExploredType getType() {
            return this.type;
        }

        @Nonnull
        @Generated
        public List<ExploredMethod> getMethods() {
            return this.methods;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExploredClass)) {
                return false;
            }
            ExploredClass other = (ExploredClass)o;
            ExploredType this$type = this.getType();
            ExploredType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            List<ExploredMethod> this$methods = this.getMethods();
            List<ExploredMethod> other$methods = other.getMethods();
            return !(this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExploredType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            List<ExploredMethod> $methods = this.getMethods();
            result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "JavaClassExplorer.ExploredClass(type=" + this.getType() + ", methods=" + this.getMethods() + ")";
        }
    }

    public static final class ExploredMethod {
        @Nonnull
        private final String name;
        @Nonnull
        private final ExploredType resultType;
        @Nonnull
        private final LinkedHashMap<String, ExploredType> arguments;

        @Generated
        public ExploredMethod(@Nonnull String name, @Nonnull ExploredType resultType, @Nonnull LinkedHashMap<String, ExploredType> arguments) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (resultType == null) {
                throw new NullPointerException("resultType is marked non-null but is null");
            }
            if (arguments == null) {
                throw new NullPointerException("arguments is marked non-null but is null");
            }
            this.name = name;
            this.resultType = resultType;
            this.arguments = arguments;
        }

        @Nonnull
        @Generated
        public String getName() {
            return this.name;
        }

        @Nonnull
        @Generated
        public ExploredType getResultType() {
            return this.resultType;
        }

        @Nonnull
        @Generated
        public LinkedHashMap<String, ExploredType> getArguments() {
            return this.arguments;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExploredMethod)) {
                return false;
            }
            ExploredMethod other = (ExploredMethod)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ExploredType this$resultType = this.getResultType();
            ExploredType other$resultType = other.getResultType();
            if (this$resultType == null ? other$resultType != null : !((Object)this$resultType).equals(other$resultType)) {
                return false;
            }
            LinkedHashMap<String, ExploredType> this$arguments = this.getArguments();
            LinkedHashMap<String, ExploredType> other$arguments = other.getArguments();
            return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ExploredType $resultType = this.getResultType();
            result = result * 59 + ($resultType == null ? 43 : ((Object)$resultType).hashCode());
            LinkedHashMap<String, ExploredType> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "JavaClassExplorer.ExploredMethod(name=" + this.getName() + ", resultType=" + this.getResultType() + ", arguments=" + this.getArguments() + ")";
        }
    }

    public static final class ExploredType {
        @Nonnull
        private final String name;
        @Nonnull
        private final List<ExploredType> parameters;

        public ExploredType(@Nonnull String name) {
            this(name, Collections.emptyList());
        }

        @Nonnull
        public String getFullName() {
            List<ExploredType> params = this.getParameters();
            return params.isEmpty() ? this.getName() : this.getName() + "<" + params.stream().map(ExploredType::getFullName).collect(Collectors.joining(", ")) + ">";
        }

        @Nonnull
        @Generated
        public String getName() {
            return this.name;
        }

        @Nonnull
        @Generated
        public List<ExploredType> getParameters() {
            return this.parameters;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExploredType)) {
                return false;
            }
            ExploredType other = (ExploredType)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<ExploredType> this$parameters = this.getParameters();
            List<ExploredType> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<ExploredType> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "JavaClassExplorer.ExploredType(name=" + this.getName() + ", parameters=" + this.getParameters() + ")";
        }

        @Generated
        public ExploredType(@Nonnull String name, @Nonnull List<ExploredType> parameters) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (parameters == null) {
                throw new NullPointerException("parameters is marked non-null but is null");
            }
            this.name = name;
            this.parameters = parameters;
        }
    }
}

