/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TenantThreadContextListener
implements ThreadContextListener {
    public static final String PROPERTY_TENANT = TenantThreadContextListener.class.getName() + ":tenant";
    @Nullable
    private final Tenant tenant;

    public TenantThreadContextListener() {
        this.tenant = null;
    }

    public TenantThreadContextListener(@Nonnull Tenant tenant) {
        this.tenant = tenant;
    }

    public int getPriority() {
        return -2;
    }

    public void afterInitialize(@Nonnull ThreadContext threadContext) {
        if (this.tenant != null) {
            threadContext.setProperty(PROPERTY_TENANT, Property.of((Object)this.tenant));
        } else {
            threadContext.setPropertyIfAbsent(PROPERTY_TENANT, Property.decorateCallable(TenantAccessor::getCurrentTenant));
        }
    }
}

