/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.principal.DefaultPrincipal;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth2AuthTokenPrincipalExtractor
implements PrincipalExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2AuthTokenPrincipalExtractor.class);
    private static final String JWT_CLIENT_ID_CLAIM = "client_id";
    private static final String JWT_USER_NAME_CLAIM = "user_name";
    private static final String JWT_GRANT_TYPE_CLAIM = "grant_type";
    private final Map<String, CheckedFunction1<DecodedJWT, String>> grantTypeToPrincipalIdExtractor = new HashMap<String, CheckedFunction1<DecodedJWT, String>>();

    OAuth2AuthTokenPrincipalExtractor() {
        this.grantTypeToPrincipalIdExtractor.put("password", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put("client_credentials", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_CLIENT_ID_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put("authorization_code", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put("user_token", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put("urn:ietf:params:oauth:grant-type:saml2-bearer", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
        this.grantTypeToPrincipalIdExtractor.put("urn:ietf:params:oauth:grant-type:jwt-bearer", (CheckedFunction1<DecodedJWT, String>)(CheckedFunction1 & Serializable)jwt -> jwt.getClaim(JWT_USER_NAME_CLAIM).asString());
    }

    void setIdExtractorFunction(@Nonnull String grantType, @Nonnull CheckedFunction1<DecodedJWT, String> principalIdExtractor) {
        CheckedFunction1<DecodedJWT, String> previousExtractorFunction = this.grantTypeToPrincipalIdExtractor.put(grantType, principalIdExtractor);
        if (log.isDebugEnabled()) {
            if (previousExtractorFunction != null) {
                log.debug("Replaced the logic for grant type '" + grantType + "' with a new one.");
            } else {
                log.debug("Added initial logic for grant type '" + grantType + "'.");
            }
        }
    }

    @Nonnull
    private Try<String> getPrincipalId(@Nonnull DecodedJWT jwt) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            String principalId;
            String grantType;
            CheckedFunction1<DecodedJWT, String> idSupplier;
            Claim grantTypeClaim = jwt.getClaim(JWT_GRANT_TYPE_CLAIM);
            if (grantTypeClaim.isMissing() || grantTypeClaim.isNull()) {
                throw new PrincipalAccessException("The current JWT does not contain any grant type.");
            }
            if (log.isDebugEnabled()) {
                if (this.grantTypeToPrincipalIdExtractor.isEmpty()) {
                    log.debug("There is no logic registered for any grant type, so no principal will get extracted from the JWT.");
                } else {
                    log.debug("To extract a principal from JWT the following grant types will get handled: {}", this.grantTypeToPrincipalIdExtractor.keySet());
                }
            }
            if ((idSupplier = this.grantTypeToPrincipalIdExtractor.get(grantType = grantTypeClaim.asString())) == null) {
                throw new PrincipalAccessException("There is no reader registered for grant type '" + grantType + "'.");
            }
            try {
                principalId = (String)idSupplier.apply((Object)jwt);
            }
            catch (Throwable t) {
                throw new PrincipalAccessException("Could not read id for grant type " + grantType + " from JWT.", t);
            }
            if (principalId == null) {
                throw new PrincipalAccessException("The principalId for grant type " + grantType + " must not be null.");
            }
            log.debug("Extracted principal '{}' from the current JWT.", (Object)principalId);
            return principalId;
        });
    }

    @Override
    @Nonnull
    public Try<Principal> tryGetCurrentPrincipal() {
        Try jwtTry = AuthTokenAccessor.tryGetCurrentToken().map(AuthToken::getJwt);
        if (jwtTry.isFailure()) {
            return Try.failure((Throwable)jwtTry.getCause());
        }
        DecodedJWT jwt = (DecodedJWT)jwtTry.get();
        Try<String> principalId = this.getPrincipalId(jwt);
        if (principalId.isFailure()) {
            return Try.failure((Throwable)principalId.getCause());
        }
        return Try.of((CheckedFunction0 & Serializable)() -> new DefaultPrincipal((String)principalId.get()));
    }
}

