/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.exception.ObjectLookupFailedException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.ExecutableAuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.thread.Executable;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthTokenAccessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthTokenAccessor.class);
    @Nonnull
    private static AuthTokenFacade authTokenFacade = AuthTokenAccessor.getDefaultAuthTokenFacade();
    @Nullable
    private static Supplier<AuthToken> fallbackToken = null;

    public static void setAuthTokenFacade(@Nullable AuthTokenFacade requestFacade) {
        authTokenFacade = requestFacade == null ? AuthTokenAccessor.getDefaultAuthTokenFacade() : requestFacade;
    }

    @Nonnull
    private static AuthTokenFacade getDefaultAuthTokenFacade() {
        Collection facades = FacadeLocator.getFacades(AuthTokenFacade.class);
        if (facades.size() > 1) {
            String classes = facades.stream().map(f -> f.getClass().getName()).collect(Collectors.joining(", "));
            throw new ObjectLookupFailedException(String.format("Too many implementations of %s found. Make sure to only have a single platform specific implementation of the interface on your classpath: %s", AuthTokenFacade.class.getName(), classes));
        }
        if (facades.size() == 1) {
            return (AuthTokenFacade)facades.iterator().next();
        }
        authTokenFacade = AuthTokenFacade.NULL;
        return authTokenFacade;
    }

    @Nonnull
    public static AuthToken getCurrentToken() throws AuthTokenAccessException {
        return (AuthToken)AuthTokenAccessor.tryGetCurrentToken().getOrElseThrow(failure -> {
            if (failure instanceof AuthTokenAccessException) {
                throw (AuthTokenAccessException)failure;
            }
            throw new AuthTokenAccessException("Failed to get current authorization token.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<AuthToken> tryGetCurrentToken() {
        Try<AuthToken> authTokenTry = authTokenFacade.tryGetCurrentToken();
        if (authTokenTry.isFailure() && fallbackToken != null) {
            return authTokenTry.recover(failure -> {
                AuthToken fallback = fallbackToken.get();
                log.warn("Recovering with fallback token: {}.", (Object)fallback, failure);
                return fallback;
            });
        }
        return authTokenTry;
    }

    @Nullable
    public static <T> T executeWithAuthToken(@Nonnull AuthToken authToken, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        AuthTokenFacade facade = AuthTokenAccessor.getAuthTokenFacade();
        if (!ExecutableAuthTokenFacade.class.isAssignableFrom(facade.getClass())) {
            throw new ThreadContextExecutionException(String.format("The 'executeWith...' API is currently supported only when using the Cloud SDK's 'DefaultFacade' implementations (e.g. '%s'). This is an issue especially when using the CAP integration ('cds-integration-cloud-sdk'). To workaround this shortcoming, please refer to the CAP documentation about how to manipulate the request context: https://cap.cloud.sap/docs/java/request-contexts#defining-requestcontext.", ExecutableAuthTokenFacade.class.getName()));
        }
        return ((ExecutableAuthTokenFacade)facade).executeWithAuthToken(authToken, callable);
    }

    public static void executeWithAuthToken(@Nonnull AuthToken authToken, @Nonnull Executable executable) throws ThreadContextExecutionException {
        AuthTokenAccessor.executeWithAuthToken(authToken, () -> {
            executable.execute();
            return null;
        });
    }

    @Nullable
    public static <T> T executeWithFallbackAuthToken(@Nonnull Supplier<AuthToken> fallbackAuthToken, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        Try<AuthToken> tokenTry = AuthTokenAccessor.tryGetCurrentToken();
        if (tokenTry.isSuccess()) {
            try {
                return callable.call();
            }
            catch (ThreadContextExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ThreadContextExecutionException((Throwable)e);
            }
        }
        return AuthTokenAccessor.executeWithAuthToken(fallbackAuthToken.get(), callable);
    }

    public static void executeWithFallbackAuthToken(@Nonnull Supplier<AuthToken> fallbackAuthToken, @Nonnull Executable executable) throws ThreadContextExecutionException {
        AuthTokenAccessor.executeWithFallbackAuthToken(fallbackAuthToken, () -> {
            executable.execute();
            return null;
        });
    }

    @Generated
    private AuthTokenAccessor() {
    }

    @Nonnull
    @Generated
    public static AuthTokenFacade getAuthTokenFacade() {
        return authTokenFacade;
    }

    @Nullable
    @Generated
    public static Supplier<AuthToken> getFallbackToken() {
        return fallbackToken;
    }

    @Generated
    public static void setFallbackToken(@Nullable Supplier<AuthToken> fallbackToken) {
        AuthTokenAccessor.fallbackToken = fallbackToken;
    }
}

