/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.security.Audience;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.principal.AudienceAuthorizationUtil;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAttribute;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAttributeException;
import io.vavr.control.Try;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class DefaultPrincipal
implements Principal {
    @Nonnull
    private final String principalId;
    @Nonnull
    private final Set<Authorization> localAuthorizations;
    @Nonnull
    private final Map<String, PrincipalAttribute> attributes;
    @Nonnull
    Map<Audience, Set<Authorization>> authorizationsByAudience = Maps.newHashMap();

    @Beta
    public DefaultPrincipal(@Nonnull String principalId, @Nonnull Set<Authorization> localAuthorizations, @Nonnull Set<Authorization> allAuthorizations, @Nonnull Set<Audience> audiences, @Nonnull Map<String, PrincipalAttribute> attributes) {
        this.principalId = principalId;
        this.localAuthorizations = localAuthorizations;
        this.attributes = attributes;
        this.authorizationsByAudience = AudienceAuthorizationUtil.getAuthorizationsByAudience(audiences, allAuthorizations);
    }

    @Override
    @Nonnull
    public Set<Authorization> getAuthorizations() {
        return Sets.newHashSet(this.localAuthorizations);
    }

    @Override
    @Nonnull
    public Map<Audience, Set<Authorization>> getAuthorizationsByAudience() {
        return Maps.newHashMap(this.authorizationsByAudience);
    }

    @Override
    @Nonnull
    public Try<PrincipalAttribute> getAttribute(@Nonnull String attributeName) {
        PrincipalAttribute attribute = this.attributes.get(attributeName);
        if (attribute == null) {
            return Try.failure((Throwable)new PrincipalAttributeException("No attribute found with name '" + attributeName + "'."));
        }
        return Try.success((Object)attribute);
    }

    @Nonnull
    @Generated
    public Set<Authorization> getLocalAuthorizations() {
        return this.localAuthorizations;
    }

    @Nonnull
    @Generated
    public Map<String, PrincipalAttribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAuthorizationsByAudience(@Nonnull Map<Audience, Set<Authorization>> authorizationsByAudience) {
        if (authorizationsByAudience == null) {
            throw new NullPointerException("authorizationsByAudience is marked non-null but is null");
        }
        this.authorizationsByAudience = authorizationsByAudience;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultPrincipal)) {
            return false;
        }
        DefaultPrincipal other = (DefaultPrincipal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$principalId = this.getPrincipalId();
        String other$principalId = other.getPrincipalId();
        if (this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId)) {
            return false;
        }
        Set<Authorization> this$localAuthorizations = this.getLocalAuthorizations();
        Set<Authorization> other$localAuthorizations = other.getLocalAuthorizations();
        if (this$localAuthorizations == null ? other$localAuthorizations != null : !((Object)this$localAuthorizations).equals(other$localAuthorizations)) {
            return false;
        }
        Map<String, PrincipalAttribute> this$attributes = this.getAttributes();
        Map<String, PrincipalAttribute> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Map<Audience, Set<Authorization>> this$authorizationsByAudience = this.getAuthorizationsByAudience();
        Map<Audience, Set<Authorization>> other$authorizationsByAudience = other.getAuthorizationsByAudience();
        return !(this$authorizationsByAudience == null ? other$authorizationsByAudience != null : !((Object)this$authorizationsByAudience).equals(other$authorizationsByAudience));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DefaultPrincipal;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $principalId = this.getPrincipalId();
        result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
        Set<Authorization> $localAuthorizations = this.getLocalAuthorizations();
        result = result * 59 + ($localAuthorizations == null ? 43 : ((Object)$localAuthorizations).hashCode());
        Map<String, PrincipalAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Map<Audience, Set<Authorization>> $authorizationsByAudience = this.getAuthorizationsByAudience();
        result = result * 59 + ($authorizationsByAudience == null ? 43 : ((Object)$authorizationsByAudience).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "DefaultPrincipal(principalId=" + this.getPrincipalId() + ", localAuthorizations=" + this.getLocalAuthorizations() + ", attributes=" + this.getAttributes() + ", authorizationsByAudience=" + this.getAuthorizationsByAudience() + ")";
    }

    @Generated
    public DefaultPrincipal(@Nonnull String principalId, @Nonnull Set<Authorization> localAuthorizations, @Nonnull Map<String, PrincipalAttribute> attributes) {
        if (principalId == null) {
            throw new NullPointerException("principalId is marked non-null but is null");
        }
        if (localAuthorizations == null) {
            throw new NullPointerException("localAuthorizations is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.principalId = principalId;
        this.localAuthorizations = localAuthorizations;
        this.attributes = attributes;
    }

    @Override
    @Nonnull
    @Generated
    public String getPrincipalId() {
        return this.principalId;
    }
}

