/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.connectivity.QueryParamGetter;
import com.sap.cloud.sdk.cloudplatform.connectivity.UriPathMerger;
import com.sap.cloud.sdk.cloudplatform.connectivity.UriQueryMerger;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClientWrapper
extends CloseableHttpClient
implements UriQueryMerger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClientWrapper.class);
    private final CloseableHttpClient httpClient;
    private final HttpDestinationProperties destination;

    public void close() {
        this.getConnectionManager().shutdown();
    }

    HttpClientWrapper(CloseableHttpClient httpClient, HttpDestinationProperties destination) {
        this.httpClient = httpClient;
        if (destination.getProxyType().contains((Object)ProxyType.ON_PREMISE) && destination.getProxyConfiguration().isEmpty()) {
            throw new DestinationAccessException("Unable to create an HttpClient from the provided destination. The destination is supposed to target an on-premise system but lacks the correct proxy configuration. Please check the application logs for further details.");
        }
        this.destination = destination;
    }

    HttpClientWrapper withDestination(HttpDestinationProperties destination) {
        if (!destination.equals(this.destination)) {
            throw new ShouldNotHappenException("This method must not be used outside of updating an instance of HttpClientWrapper for http clients served from the HttpClientCache.");
        }
        if (destination == this.destination) {
            return this;
        }
        return new HttpClientWrapper(this.httpClient, destination);
    }

    @Override
    @Nonnull
    public URI mergeRequestUri(@Nonnull URI requestUri) {
        UriPathMerger merger = new UriPathMerger();
        URI mergedUri = merger.merge(this.destination.getUri(), requestUri);
        String queryString = String.join((CharSequence)"&", QueryParamGetter.getQueryParameters(this.destination));
        return merger.merge(mergedUri, URI.create("/?" + queryString));
    }

    HttpUriRequest wrapRequest(HttpUriRequest request) {
        RequestBuilder requestBuilder = RequestBuilder.copy((HttpRequest)request);
        URI requestUri = this.mergeRequestUri(request.getURI());
        requestBuilder.setUri(requestUri);
        for (Header header : this.destination.getHeaders(requestUri)) {
            requestBuilder.addHeader((org.apache.http.Header)new ApacheHttpHeader(header));
            log.debug("Added HTTP header with key {} originating from a {} with target URI {} for new outbound HTTP request.", new Object[]{header.getName(), this.destination.getClass().getSimpleName(), this.destination.getUri()});
        }
        return requestBuilder.build();
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
        HttpUriRequest httpUriRequest = this.wrapRequest(request);
        return this.httpClient.execute(httpUriRequest);
    }

    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        HttpUriRequest httpUriRequest = this.wrapRequest(request);
        return this.httpClient.execute(httpUriRequest, context);
    }

    public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        return this.httpClient.execute(target, request);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        HttpUriRequest httpUriRequest = this.wrapRequest(request);
        return (T)this.httpClient.execute(httpUriRequest, responseHandler);
    }

    protected CloseableHttpResponse doExecute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        return this.httpClient.execute(httpHost, httpRequest, httpContext);
    }

    public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return this.httpClient.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        return (T)this.httpClient.execute(this.wrapRequest(request), responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.httpClient.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        return (T)this.httpClient.execute(target, request, responseHandler, context);
    }

    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    @Generated
    HttpDestinationProperties getDestination() {
        return this.destination;
    }

    static class ApacheHttpHeader
    implements org.apache.http.Header {
        @Nonnull
        private final Header header;

        public String getName() {
            return this.header.getName();
        }

        public String getValue() {
            return this.header.getValue();
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[0];
        }

        @Nonnull
        public String toString() {
            return this.getClass().getSimpleName() + "(header=Header(name=" + this.getName() + ", value=(hidden)))";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApacheHttpHeader)) {
                return false;
            }
            ApacheHttpHeader other = (ApacheHttpHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Header this$header = this.header;
            Header other$header = other.header;
            return !(this$header == null ? other$header != null : !this$header.equals(other$header));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ApacheHttpHeader;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Header $header = this.header;
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            return result;
        }

        @Generated
        public ApacheHttpHeader(@Nonnull Header header) {
            if (header == null) {
                throw new NullPointerException("header is marked non-null but is null");
            }
            this.header = header;
        }
    }
}

