/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpClientCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import io.vavr.control.Try;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;

public final class HttpClientAccessor {
    @Nonnull
    private static HttpClientCache httpClientCache = new DefaultHttpClientCache();
    @Nonnull
    private static HttpClientFactory httpClientFactory = new DefaultHttpClientFactory();

    @Nonnull
    public static HttpClientFactory getHttpClientFactory() {
        return httpClientFactory;
    }

    public static void setHttpClientFactory(@Nullable HttpClientFactory httpClientFactory) {
        HttpClientAccessor.httpClientFactory = httpClientFactory == null ? new DefaultHttpClientFactory() : httpClientFactory;
    }

    public static void setHttpClientCache(@Nullable HttpClientCache httpClientCache) {
        HttpClientAccessor.httpClientCache = httpClientCache == null ? new DefaultHttpClientCache() : httpClientCache;
    }

    @Nonnull
    public static HttpClient getHttpClient() throws HttpClientInstantiationException {
        return (HttpClient)HttpClientAccessor.tryGetHttpClient().getOrElseThrow(failure -> {
            if (failure instanceof DestinationAccessException) {
                throw (DestinationAccessException)failure;
            }
            if (failure instanceof HttpClientInstantiationException) {
                throw (HttpClientInstantiationException)((Object)failure);
            }
            throw new HttpClientInstantiationException("Failed to get HttpClient.", failure);
        });
    }

    @Nonnull
    public static Try<HttpClient> tryGetHttpClient() {
        return httpClientCache.tryGetHttpClient(httpClientFactory);
    }

    @Nonnull
    public static HttpClient getHttpClient(@Nonnull HttpDestinationProperties destination) throws DestinationAccessException, HttpClientInstantiationException {
        return HttpClientAccessor.getHttpClient((Destination)destination);
    }

    @Nonnull
    public static HttpClient getHttpClient(@Nonnull Destination destination) throws DestinationAccessException, HttpClientInstantiationException {
        return (HttpClient)HttpClientAccessor.tryGetHttpClient(destination).getOrElseThrow(failure -> {
            if (failure instanceof DestinationAccessException) {
                throw (DestinationAccessException)failure;
            }
            if (failure instanceof HttpClientInstantiationException) {
                throw (HttpClientInstantiationException)((Object)failure);
            }
            throw new HttpClientInstantiationException("Failed to get HttpClient for destination.", failure);
        });
    }

    @Nonnull
    public static Try<HttpClient> tryGetHttpClient(@Nonnull Destination destination) {
        if (!destination.isHttp()) {
            return Try.failure((Throwable)new DestinationAccessException("The given destination is not an HTTP destination."));
        }
        return httpClientCache.tryGetHttpClient((HttpDestinationProperties)destination.asHttp(), httpClientFactory);
    }

    @Generated
    private HttpClientAccessor() {
    }

    @Nonnull
    @Generated
    public static HttpClientCache getHttpClientCache() {
        return httpClientCache;
    }
}

