/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AsciiUtils;
import com.sap.cloud.sdk.cloudplatform.connectivity.CsrfToken;
import com.sap.cloud.sdk.cloudplatform.connectivity.CsrfTokenRetriever;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.CsrfTokenRetrievalException;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCsrfTokenRetriever
implements CsrfTokenRetriever {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCsrfTokenRetriever.class);
    public static final String X_CSRF_TOKEN_HEADER_KEY = "x-csrf-token";
    private static final String X_CSRF_TOKEN_HEADER_FETCH_VALUE = "fetch";

    @Override
    @Nonnull
    public CsrfToken retrieveCsrfToken(@Nonnull HttpClient httpClient, @Nonnull String servicePath) {
        return this.retrieveCsrfToken(httpClient, servicePath, Collections.emptyMap());
    }

    @Override
    @Nonnull
    public CsrfToken retrieveCsrfToken(@Nonnull HttpClient httpClient, @Nonnull String servicePath, @Nonnull Map<String, Collection<String>> headers) {
        try {
            Header csrfHeader = this.retrieveCsrfTokenResponseHeader(httpClient, servicePath, headers);
            CsrfToken token = this.convertHeaderToCsrfToken(csrfHeader);
            log.debug("Successfully retrieved CSRF token {} from service path {}", (Object)token, (Object)servicePath);
            return token;
        }
        catch (NoSuchElementException e) {
            String msgErrorFormat = "CSRF token retrieval failed: The server did not respond with the %s header.";
            String msgError = String.format("CSRF token retrieval failed: The server did not respond with the %s header.", X_CSRF_TOKEN_HEADER_KEY);
            String msgDebug = "{} The subsequent request to service path {} is bound to fail if the OData service requires a CSRF token in request header.";
            log.debug("{} The subsequent request to service path {} is bound to fail if the OData service requires a CSRF token in request header.", (Object)msgError, (Object)servicePath);
            throw new CsrfTokenRetrievalException(msgError, e);
        }
        catch (Exception e) {
            String msgError = "CSRF token retrieval failed: The HTTP request was not successful.";
            log.debug("{} The affected service path is: {}", new Object[]{"CSRF token retrieval failed: The HTTP request was not successful.", servicePath, e});
            throw new CsrfTokenRetrievalException("CSRF token retrieval failed: The HTTP request was not successful.", e);
        }
    }

    @Nonnull
    private Header retrieveCsrfTokenResponseHeader(@Nonnull HttpClient httpClient, @Nonnull String servicePath, @Nonnull Map<String, Collection<String>> headers) throws NoSuchElementException, IOException {
        HttpHead csrfTokenRequest = new HttpHead(URI.create(servicePath));
        csrfTokenRequest.setHeader(X_CSRF_TOKEN_HEADER_KEY, X_CSRF_TOKEN_HEADER_FETCH_VALUE);
        headers.forEach((arg_0, arg_1) -> DefaultCsrfTokenRetriever.lambda$retrieveCsrfTokenResponseHeader$1((HttpUriRequest)csrfTokenRequest, arg_0, arg_1));
        HttpResponse csrfResponse = httpClient.execute((HttpUriRequest)csrfTokenRequest);
        Header header = csrfResponse.getFirstHeader(X_CSRF_TOKEN_HEADER_KEY);
        if (csrfResponse.getEntity() != null) {
            log.warn("The HTTP HEAD request for CSRF token retrieval resulted in an unexpected response payload.");
            EntityUtils.consume((HttpEntity)csrfResponse.getEntity());
        }
        if (header == null || header.getValue() == null) {
            throw new NoSuchElementException("No CSRF token could be found in the response header.");
        }
        return header;
    }

    @Nonnull
    private CsrfToken convertHeaderToCsrfToken(@Nonnull Header csrfHeader) {
        String printableCsrfToken = new AsciiUtils().removeNonPrintableCharacters(csrfHeader.getValue());
        return new CsrfToken(printableCsrfToken);
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultCsrfTokenRetriever)) {
            return false;
        }
        DefaultCsrfTokenRetriever other = (DefaultCsrfTokenRetriever)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DefaultCsrfTokenRetriever;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static /* synthetic */ void lambda$retrieveCsrfTokenResponseHeader$1(HttpUriRequest csrfTokenRequest, String k, Collection values) {
        values.forEach(v -> csrfTokenRequest.addHeader(k, v));
    }
}

