/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.github.benmanes.caffeine.cache.Cache;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientWrapper;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import io.vavr.control.Try;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClientCache
implements HttpClientCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpClientCache.class);

    @Override
    @Nonnull
    public Try<HttpClient> tryGetHttpClient(@Nonnull HttpDestinationProperties destination, @Nonnull HttpClientFactory httpClientFactory) {
        return this.tryGetOrCreateHttpClient(httpClientFactory, destination);
    }

    @Override
    @Nonnull
    public Try<HttpClient> tryGetHttpClient(@Nonnull HttpClientFactory httpClientFactory) {
        return this.tryGetOrCreateHttpClient(httpClientFactory, null);
    }

    private Try<HttpClient> tryGetOrCreateHttpClient(@Nonnull HttpClientFactory httpClientFactory, @Nullable HttpDestinationProperties destination) {
        HttpClient httpClient;
        Try<CacheKey> maybeKey;
        Supplier<HttpClient> createHttpClient = () -> {
            log.debug("HttpClient with given cache key is not yet in the cache.");
            return destination != null ? httpClientFactory.createHttpClient(destination) : httpClientFactory.createHttpClient();
        };
        Try<Cache<CacheKey, HttpClient>> maybeCache = this.getCache();
        if (maybeCache.isFailure()) {
            return Try.failure((Throwable)new HttpClientInstantiationException("Failed to get HttpClientCache.", maybeCache.getCause()));
        }
        Try<CacheKey> try_ = maybeKey = destination != null ? this.getCacheKey(destination) : this.getCacheKey();
        if (maybeKey.isFailure()) {
            return Try.failure((Throwable)new HttpClientInstantiationException("Failed to create cache key for HttpClient", maybeKey.getCause()));
        }
        Cache cache = (Cache)maybeCache.get();
        CacheKey cacheKey = (CacheKey)maybeKey.get();
        try {
            httpClient = (HttpClient)cache.get((Object)cacheKey, anyKey -> (HttpClient)createHttpClient.get());
            Objects.requireNonNull(httpClient, "Failed to create HttpClient: The registered HttpClientFactory unexpectedly returned null.");
        }
        catch (HttpClientInstantiationException e) {
            return Try.failure((Throwable)e);
        }
        catch (RuntimeException e) {
            return Try.failure((Throwable)new HttpClientInstantiationException((Throwable)e));
        }
        if (destination != null && httpClient instanceof HttpClientWrapper) {
            return Try.success((Object)((HttpClientWrapper)httpClient).withDestination(destination));
        }
        return Try.success((Object)httpClient);
    }

    @Nonnull
    protected abstract Try<Cache<CacheKey, HttpClient>> getCache();

    @Nonnull
    protected abstract Try<CacheKey> getCacheKey(@Nonnull HttpDestinationProperties var1);

    @Nonnull
    protected abstract Try<CacheKey> getCacheKey();
}

