/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil.rules;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.s4hana.connectivity.ErpDestination;
import com.sap.cloud.sdk.testutil.MockUtil;
import java.beans.ConstructorProperties;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ForEachSystemRule
implements TestRule {
    private final MockUtil mockUtil;
    private final List<SystemRepetition> systemRepetitions = Lists.newArrayList();

    public FluentHelper withSystem(String systemAlias) {
        return new FluentHelper(this, systemAlias);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                for (SystemRepetition systemRepetition : ForEachSystemRule.this.systemRepetitions) {
                    String systemAlias = systemRepetition.getSystemAlias();
                    DestinationType destinationType = systemRepetition.getDestinationType();
                    String destinationName = systemRepetition.getDestinationName();
                    switch (destinationType) {
                        case DESTINATION: {
                            ForEachSystemRule.this.mockUtil.mockDestination(destinationName, systemAlias);
                            break;
                        }
                        case ERP_DESTINATION: {
                            ForEachSystemRule.this.mockUtil.mockErpDestination(destinationName, systemAlias);
                            break;
                        }
                        case RFC_DESTINATION: {
                            ForEachSystemRule.this.mockUtil.mockRfcDestination(destinationName, systemAlias);
                        }
                    }
                    base.evaluate();
                }
            }
        };
    }

    @ConstructorProperties(value={"mockUtil"})
    public ForEachSystemRule(MockUtil mockUtil) {
        this.mockUtil = mockUtil;
    }

    public final class FluentHelper {
        private final ForEachSystemRule rule;
        private final LinkedHashSet<String> systemAliases = Sets.newLinkedHashSet();

        private FluentHelper(ForEachSystemRule rule, String systemAlias) {
            this.rule = rule;
            this.systemAliases.add(systemAlias);
        }

        private ForEachSystemRule using(DestinationType destinationType, String destinationName) {
            for (String systemAlias : this.systemAliases) {
                ForEachSystemRule.this.systemRepetitions.add(new SystemRepetition(systemAlias, destinationType, destinationName));
            }
            return this.rule;
        }

        public ForEachSystemRule usingDestination(String destinationName) {
            return this.using(DestinationType.DESTINATION, destinationName);
        }

        public ForEachSystemRule usingErpDestination() {
            return this.usingErpDestination(ErpDestination.getDefaultName());
        }

        public ForEachSystemRule usingErpDestination(String destinationName) {
            return this.using(DestinationType.ERP_DESTINATION, destinationName);
        }

        public ForEachSystemRule usingRfcDestination() {
            return this.usingRfcDestination(ErpDestination.getDefaultName());
        }

        public ForEachSystemRule usingRfcDestination(String destinationName) {
            return this.using(DestinationType.RFC_DESTINATION, destinationName);
        }

        public FluentHelper withSystem(String systemAlias) {
            this.systemAliases.add(systemAlias);
            return this;
        }
    }

    private static final class SystemRepetition {
        private final String systemAlias;
        private final DestinationType destinationType;
        private final String destinationName;

        @ConstructorProperties(value={"systemAlias", "destinationType", "destinationName"})
        public SystemRepetition(String systemAlias, DestinationType destinationType, String destinationName) {
            this.systemAlias = systemAlias;
            this.destinationType = destinationType;
            this.destinationName = destinationName;
        }

        public String getSystemAlias() {
            return this.systemAlias;
        }

        public DestinationType getDestinationType() {
            return this.destinationType;
        }

        public String getDestinationName() {
            return this.destinationName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SystemRepetition)) {
                return false;
            }
            SystemRepetition other = (SystemRepetition)o;
            String this$systemAlias = this.getSystemAlias();
            String other$systemAlias = other.getSystemAlias();
            if (this$systemAlias == null ? other$systemAlias != null : !this$systemAlias.equals(other$systemAlias)) {
                return false;
            }
            DestinationType this$destinationType = this.getDestinationType();
            DestinationType other$destinationType = other.getDestinationType();
            if (this$destinationType == null ? other$destinationType != null : !((Object)((Object)this$destinationType)).equals((Object)other$destinationType)) {
                return false;
            }
            String this$destinationName = this.getDestinationName();
            String other$destinationName = other.getDestinationName();
            return !(this$destinationName == null ? other$destinationName != null : !this$destinationName.equals(other$destinationName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $systemAlias = this.getSystemAlias();
            result = result * 59 + ($systemAlias == null ? 43 : $systemAlias.hashCode());
            DestinationType $destinationType = this.getDestinationType();
            result = result * 59 + ($destinationType == null ? 43 : ((Object)((Object)$destinationType)).hashCode());
            String $destinationName = this.getDestinationName();
            result = result * 59 + ($destinationName == null ? 43 : $destinationName.hashCode());
            return result;
        }

        public String toString() {
            return "ForEachSystemRule.SystemRepetition(systemAlias=" + this.getSystemAlias() + ", destinationType=" + (Object)((Object)this.getDestinationType()) + ", destinationName=" + this.getDestinationName() + ")";
        }
    }

    private static enum DestinationType {
        DESTINATION,
        ERP_DESTINATION,
        RFC_DESTINATION;

    }
}

