/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.netflix.hystrix.Hystrix;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformFacade;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLog;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogFacade;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogger;
import com.sap.cloud.sdk.cloudplatform.auditlog.DefaultLoggerAuditLog;
import com.sap.cloud.sdk.cloudplatform.cache.CacheManager;
import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationFacade;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationsRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.connectivity.RfcDestination;
import com.sap.cloud.sdk.cloudplatform.naming.JndiLookupAccessor;
import com.sap.cloud.sdk.cloudplatform.naming.JndiLookupFacade;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStore;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStoreAccessor;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStoreFacade;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAccessor;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAttribute;
import com.sap.cloud.sdk.cloudplatform.security.user.UserFacade;
import com.sap.cloud.sdk.cloudplatform.servlet.LocaleAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.LocaleFacade;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextFacade;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import com.sap.cloud.sdk.frameworks.hystrix.HystrixRequestContextFacade;
import com.sap.cloud.sdk.s4hana.connectivity.signing.SigningServiceDestination;
import com.sap.cloud.sdk.s4hana.connectivity.signing.TrustSignatureKey;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import com.sap.cloud.sdk.testutil.CredentialsProvider;
import com.sap.cloud.sdk.testutil.DefaultCredentialsProvider;
import com.sap.cloud.sdk.testutil.DefaultDestinationMocker;
import com.sap.cloud.sdk.testutil.DefaultErpDestinationMocker;
import com.sap.cloud.sdk.testutil.DefaultRfcDestinationMocker;
import com.sap.cloud.sdk.testutil.DefaultSecretStoreMocker;
import com.sap.cloud.sdk.testutil.DefaultServerMocker;
import com.sap.cloud.sdk.testutil.DefaultTenantMocker;
import com.sap.cloud.sdk.testutil.DefaultTestSystemsProvider;
import com.sap.cloud.sdk.testutil.DefaultUserMocker;
import com.sap.cloud.sdk.testutil.DestinationMocker;
import com.sap.cloud.sdk.testutil.ErpDestinationMocker;
import com.sap.cloud.sdk.testutil.ErpSystem;
import com.sap.cloud.sdk.testutil.GetDestinationMockitoAnswer;
import com.sap.cloud.sdk.testutil.GetDestinationTypeMockitoAnswer;
import com.sap.cloud.sdk.testutil.GetDestinationsMockitoAnswer;
import com.sap.cloud.sdk.testutil.MockDestination;
import com.sap.cloud.sdk.testutil.MockErpDestination;
import com.sap.cloud.sdk.testutil.MockRfcDestination;
import com.sap.cloud.sdk.testutil.RfcDestinationMocker;
import com.sap.cloud.sdk.testutil.SecretStoreMocker;
import com.sap.cloud.sdk.testutil.ServerMocker;
import com.sap.cloud.sdk.testutil.TenantMocker;
import com.sap.cloud.sdk.testutil.TestConfigurationError;
import com.sap.cloud.sdk.testutil.TestSystem;
import com.sap.cloud.sdk.testutil.TestSystemsProvider;
import com.sap.cloud.sdk.testutil.UserMocker;
import java.io.File;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.assertj.core.util.Lists;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockserver.integration.ClientAndServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockUtil
implements TestSystemsProvider,
CredentialsProvider,
TenantMocker,
UserMocker,
SecretStoreMocker,
DestinationMocker,
ErpDestinationMocker,
RfcDestinationMocker,
ServerMocker {
    private static final Logger log = LoggerFactory.getLogger(MockUtil.class);
    static final String TEST_SYSTEMS_RESOURCE_FILE = "systems";
    static final String CREDENTIALS_RESOURCE_FILE = "credentials";
    static final String PROPERTY_TEST_SYSTEMS = "test.systems";
    static final String PROPERTY_CREDENTIALS = "test.credentials";
    static final List<String> CONFIG_FILE_EXTENSIONS = ImmutableList.of((Object)".yml", (Object)".yaml", (Object)".json");
    static final String PROPERTY_ERP_ALIAS = "erp";
    static final String PROPERTY_ERP_USERNAME = "erp.username";
    static final String PROPERTY_ERP_PASSWORD = "erp.password";
    static final String MOCKED_CLOUD_APP_NAME = "testapp";
    static final String MOCKED_TENANT = "00000000-0000-0000-0000-000000000000";
    static final String MOCKED_USER = "MockedUser";
    @Nullable
    private ProxyConfiguration proxyConfiguration;
    private FacadeLocator.MockableInstance facadeLocator;
    private JndiLookupFacade jndiLookupFacade;
    private TenantFacade tenantFacade;
    private UserFacade userFacade;
    private DestinationFacade destinationFacade;
    private SecretStoreFacade secretStoreFacade;
    private final DefaultTestSystemsProvider testSystemsProvider = new DefaultTestSystemsProvider();
    private final DefaultCredentialsProvider credentialsProvider = new DefaultCredentialsProvider();
    private final DefaultTenantMocker tenantMocker = new DefaultTenantMocker(this);
    private final DefaultUserMocker userMocker = new DefaultUserMocker(this);
    private final DefaultSecretStoreMocker secretStoreMocker = new DefaultSecretStoreMocker(this);
    private final DefaultDestinationMocker destinationMocker = new DefaultDestinationMocker(this);
    private final ErpDestinationMocker erpDestinationMocker = new DefaultErpDestinationMocker(this);
    private final RfcDestinationMocker rfcDestinationMocker = new DefaultRfcDestinationMocker(this);
    private final ServerMocker serverMocker = new DefaultServerMocker(this);
    private static final String TRUSTCERT_KEYSTORE_NAME = "trustcert.jks";
    private static final String TRUSTCERT_KEYSTORE_TYPE = "JKS";
    private static final String TRUSTCERT_MOCKED_PASSWORD = "Initial1";

    public MockUtil() {
        this.testSystemsProvider.loadTestSystems();
        this.credentialsProvider.loadCredentials();
        this.testSystemsProvider.readErpAliasProperty();
        this.credentialsProvider.readErpCredentialsProperties();
        RequestContextAccessor.setRequestContextFacade((RequestContextFacade)new HystrixRequestContextFacade());
        CacheManager.invalidateAll();
        Hystrix.reset();
    }

    public MockUtil withProxy(@Nullable ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this;
    }

    public void mockDefaults() {
        this.resetFacadeLocator();
        this.resetJndiLookupFacade();
        this.resetTenantFacade();
        this.resetUserFacade();
        this.resetDestinationFacade();
        this.resetSecretStoreFacade();
        this.mockCurrentCloudPlatform();
        this.mockCurrentLocales();
        this.mockCurrentTenant();
        this.mockCurrentUser();
        this.mockAuditLog();
    }

    void resetFacadeLocator() {
        if (this.facadeLocator == null) {
            this.facadeLocator = (FacadeLocator.MockableInstance)Mockito.mock(FacadeLocator.MockableInstance.class);
            this.disableFacade(this.facadeLocator, RequestContextFacade.class);
            this.disableFacade(this.facadeLocator, JndiLookupFacade.class);
            this.disableFacade(this.facadeLocator, AuditLogFacade.class);
            this.disableFacade(this.facadeLocator, CloudPlatformFacade.class);
            this.disableFacade(this.facadeLocator, TenantFacade.class);
            this.disableFacade(this.facadeLocator, UserFacade.class);
            this.disableFacade(this.facadeLocator, DestinationFacade.class);
            this.disableFacade(this.facadeLocator, SecretStoreFacade.class);
        }
        FacadeLocator.setMockableInstance((FacadeLocator.MockableInstance)this.facadeLocator);
    }

    private void disableFacade(FacadeLocator.MockableInstance facadeLocator, Class<?> facadeType) {
        ((FacadeLocator.MockableInstance)Mockito.doReturn(null).when((Object)facadeLocator)).getFacade(facadeType);
        ((FacadeLocator.MockableInstance)Mockito.doReturn(Collections.emptyList()).when((Object)facadeLocator)).getFacades(facadeType);
    }

    private void resetJndiLookupFacade() {
        this.resetFacadeLocator();
        if (this.jndiLookupFacade == null) {
            this.jndiLookupFacade = (JndiLookupFacade)Mockito.mock(JndiLookupFacade.class);
        }
        JndiLookupAccessor.setJndiLookupFacade((JndiLookupFacade)this.jndiLookupFacade);
    }

    void resetTenantFacade() {
        this.resetFacadeLocator();
        if (this.tenantFacade == null) {
            this.tenantFacade = (TenantFacade)Mockito.mock(TenantFacade.class);
            ((TenantFacade)Mockito.doAnswer((Answer)new Answer<Tenant>(){

                public Tenant answer(InvocationOnMock invocation) {
                    Tenant currentTenant = MockUtil.this.tenantMocker.getCurrentTenant();
                    if (currentTenant == null) {
                        throw new TestConfigurationError("Current tenant not mocked.");
                    }
                    return currentTenant;
                }
            }).when((Object)this.tenantFacade)).getCurrentTenant();
        }
        TenantAccessor.setTenantFacade((TenantFacade)this.tenantFacade);
    }

    void resetUserFacade() {
        this.resetFacadeLocator();
        if (this.userFacade == null) {
            this.userFacade = (UserFacade)Mockito.mock(UserFacade.class);
            ((UserFacade)Mockito.doAnswer((Answer)new Answer<User>(){

                public User answer(InvocationOnMock invocation) {
                    User currentUser = MockUtil.this.userMocker.getCurrentUser();
                    if (currentUser == null) {
                        throw new TestConfigurationError("Current user not mocked.");
                    }
                    return currentUser;
                }
            }).when((Object)this.userFacade)).getCurrentUser();
            ((UserFacade)Mockito.doAnswer((Answer)new Answer<Optional<User>>(){

                public Optional<User> answer(InvocationOnMock invocation) {
                    String userName = (String)invocation.getArgument(0);
                    Map<String, User> users = MockUtil.this.userMocker.getUsers();
                    if (users.containsKey(userName)) {
                        return Optional.of((Object)users.get(userName));
                    }
                    return Optional.absent();
                }
            }).when((Object)this.userFacade)).getUserByName((String)ArgumentMatchers.nullable(String.class));
        }
        UserAccessor.setUserFacade((UserFacade)this.userFacade);
    }

    void resetDestinationFacade() {
        this.resetFacadeLocator();
        if (this.destinationFacade == null) {
            this.destinationFacade = (DestinationFacade)Mockito.mock(DestinationFacade.class);
            ((DestinationFacade)Mockito.doNothing().when((Object)this.destinationFacade)).declareDestinations(ArgumentMatchers.anyCollection());
            ((DestinationFacade)Mockito.doAnswer((Answer)new GetDestinationTypeMockitoAnswer(this.destinationMocker)).when((Object)this.destinationFacade)).getDestinationType(ArgumentMatchers.anyString());
            ((DestinationFacade)Mockito.doAnswer(new GetDestinationMockitoAnswer<GenericDestination>(this.destinationMocker, GenericDestination.class)).when((Object)this.destinationFacade)).getGenericDestination(ArgumentMatchers.anyString());
            ((DestinationFacade)Mockito.doAnswer(new GetDestinationMockitoAnswer<Destination>(this.destinationMocker, Destination.class)).when((Object)this.destinationFacade)).getDestination(ArgumentMatchers.anyString());
            ((DestinationFacade)Mockito.doAnswer(new GetDestinationMockitoAnswer<RfcDestination>(this.destinationMocker, RfcDestination.class)).when((Object)this.destinationFacade)).getRfcDestination(ArgumentMatchers.anyString());
            ((DestinationFacade)Mockito.doAnswer(new GetDestinationsMockitoAnswer<GenericDestination>(this.destinationMocker, GenericDestination.class)).when((Object)this.destinationFacade)).getGenericDestinationsByName();
            ((DestinationFacade)Mockito.doAnswer(new GetDestinationsMockitoAnswer<Destination>(this.destinationMocker, Destination.class)).when((Object)this.destinationFacade)).getDestinationsByName();
            ((DestinationFacade)Mockito.doAnswer(new GetDestinationsMockitoAnswer<RfcDestination>(this.destinationMocker, RfcDestination.class)).when((Object)this.destinationFacade)).getRfcDestinationsByName();
        }
        DestinationAccessor.setDestinationFacade((DestinationFacade)this.destinationFacade);
    }

    void resetSecretStoreFacade() {
        this.resetFacadeLocator();
        if (this.secretStoreFacade == null) {
            this.secretStoreFacade = (SecretStoreFacade)Mockito.mock(SecretStoreFacade.class);
            ((SecretStoreFacade)Mockito.doAnswer((Answer)new Answer<SecretStore>(){

                public SecretStore answer(InvocationOnMock invocation) throws Throwable {
                    String name = (String)invocation.getArgument(0);
                    return MockUtil.this.secretStoreMocker.getSecretStores().get(name);
                }
            }).when((Object)this.secretStoreFacade)).getSecretStore(ArgumentMatchers.anyString());
            ((SecretStoreFacade)Mockito.doAnswer((Answer)new Answer<KeyStore>(){

                public KeyStore answer(InvocationOnMock invocation) throws Throwable {
                    String name = (String)invocation.getArgument(0);
                    SecretStore password = (SecretStore)invocation.getArgument(1);
                    return (KeyStore)MockUtil.this.secretStoreMocker.getKeyStores().get((Object)name, (Object)password);
                }
            }).when((Object)this.secretStoreFacade)).getKeyStore(ArgumentMatchers.anyString(), (SecretStore)ArgumentMatchers.any(SecretStore.class));
        }
        SecretStoreAccessor.setSecretStoreFacade((SecretStoreFacade)this.secretStoreFacade);
    }

    public void mockJndiLookup(Object obj, String name) {
        this.resetJndiLookupFacade();
        ((JndiLookupFacade)Mockito.doReturn((Object)obj).when((Object)this.jndiLookupFacade)).lookup(name);
    }

    public <T> T mockJndiLookup(Class<T> cls, String name) {
        Object mocked = Mockito.mock(cls);
        this.mockJndiLookup(mocked, name);
        return (T)mocked;
    }

    public CloudPlatform mockCurrentCloudPlatform() {
        return this.mockCurrentCloudPlatform(MOCKED_CLOUD_APP_NAME);
    }

    public CloudPlatform mockCurrentCloudPlatform(String applicationName) {
        this.resetFacadeLocator();
        CloudPlatformFacade cloudPlatformFacade = (CloudPlatformFacade)Mockito.mock(CloudPlatformFacade.class);
        CloudPlatformAccessor.setCloudPlatformFacade((CloudPlatformFacade)cloudPlatformFacade);
        CloudPlatform cloudPlatform = (CloudPlatform)Mockito.mock(CloudPlatform.class);
        Mockito.when((Object)cloudPlatform.getApplicationName()).thenReturn((Object)applicationName);
        ((CloudPlatformFacade)Mockito.doReturn((Object)cloudPlatform).when((Object)cloudPlatformFacade)).getCloudPlatform();
        return cloudPlatform;
    }

    public void mockCurrentLocales() {
        this.mockCurrentLocales(Locale.US, new Locale[0]);
    }

    public void mockCurrentLocales(Locale locale, Locale ... additionalLocales) {
        this.resetFacadeLocator();
        LocaleFacade localeFacade = (LocaleFacade)Mockito.mock(LocaleFacade.class);
        LocaleAccessor.setLocaleFacade((LocaleFacade)localeFacade);
        ((LocaleFacade)Mockito.doReturn((Object)locale).when((Object)localeFacade)).getCurrentLocale();
        ArrayList locales = Lists.newArrayList((Object[])new Locale[]{locale});
        locales.addAll(Arrays.asList(additionalLocales));
        ((LocaleFacade)Mockito.doReturn((Object)locales).when((Object)localeFacade)).getCurrentLocales();
    }

    public AuditLog mockAuditLog() {
        this.resetFacadeLocator();
        AuditLogFacade auditLogFacade = (AuditLogFacade)Mockito.mock(AuditLogFacade.class);
        AuditLogger.setAuditLogFacade((AuditLogFacade)auditLogFacade);
        DefaultLoggerAuditLog auditLog = new DefaultLoggerAuditLog();
        ((AuditLogFacade)Mockito.doReturn((Object)auditLog).when((Object)auditLogFacade)).getAuditLog();
        return auditLog;
    }

    @Override
    public TestSystem<?> getTestSystem(String systemAlias) {
        return this.testSystemsProvider.getTestSystem(systemAlias);
    }

    @Override
    public ErpSystem getErpSystem() {
        return this.testSystemsProvider.getErpSystem();
    }

    @Override
    public ErpSystem getErpSystem(String systemAlias) {
        return this.testSystemsProvider.getErpSystem(systemAlias);
    }

    @Override
    public void loadTestSystems(String resourceFileName) {
        this.testSystemsProvider.loadTestSystems(resourceFileName);
    }

    @Override
    public void loadTestSystems(@Nullable File file) {
        this.testSystemsProvider.loadTestSystems(file);
    }

    @Override
    public void addTestSystem(TestSystem<?> testSystem) {
        this.testSystemsProvider.addTestSystem(testSystem);
    }

    @Override
    public void removeTestSystem(TestSystem<?> testSystem) {
        this.testSystemsProvider.removeTestSystem(testSystem);
    }

    @Override
    public void removeTestSystem(String systemAlias) {
        this.testSystemsProvider.removeTestSystem(systemAlias);
    }

    @Override
    public void addDefaultErpSystem(ErpSystem erpSystem) {
        this.testSystemsProvider.addDefaultErpSystem(erpSystem);
    }

    @Override
    public void clearTestSystems() {
        this.testSystemsProvider.clearTestSystems();
    }

    @Override
    public Credentials getCredentials(TestSystem<?> testSystem) {
        return this.credentialsProvider.getCredentials(testSystem);
    }

    @Override
    public Credentials getCredentials(String systemAlias) {
        return this.credentialsProvider.getCredentials(systemAlias);
    }

    @Override
    public void loadCredentials(String resourceFileName) {
        this.credentialsProvider.loadCredentials(resourceFileName);
    }

    @Override
    public void loadCredentials(@Nullable File file) {
        this.credentialsProvider.loadCredentials(file);
    }

    @Override
    public void addCredentials(String systemAlias, Credentials credentials) {
        this.credentialsProvider.addCredentials(systemAlias, credentials);
    }

    @Override
    public void removeCredentials(String systemAlias) {
        this.credentialsProvider.removeCredentials(systemAlias);
    }

    @Override
    public void clearCredentials() {
        this.credentialsProvider.clearCredentials();
    }

    @Override
    public Tenant mockTenant(String tenantId) {
        return this.tenantMocker.mockTenant(tenantId);
    }

    @Override
    public Tenant mockCurrentTenant() {
        return this.tenantMocker.mockCurrentTenant();
    }

    @Override
    public Tenant mockCurrentTenant(String tenantId) {
        return this.tenantMocker.mockCurrentTenant(tenantId);
    }

    @Override
    public void setCurrentTenant(@Nullable String tenantId) {
        this.tenantMocker.setCurrentTenant(tenantId);
    }

    @Override
    public void clearTenants() {
        this.tenantMocker.clearTenants();
    }

    @Override
    public User mockUser(String userName) {
        return this.userMocker.mockUser(userName);
    }

    @Override
    public User mockUser(String userName, @Nullable Locale locale, @Nullable Collection<? extends Authorization> authorizations, @Nullable Map<String, ? extends UserAttribute> attributes) {
        return this.userMocker.mockUser(userName, locale, authorizations, attributes);
    }

    @Override
    public User mockCurrentUser() {
        return this.userMocker.mockCurrentUser();
    }

    @Override
    public User mockCurrentUser(String userName) {
        return this.userMocker.mockCurrentUser(userName);
    }

    @Override
    public User mockCurrentUser(String userName, @Nullable Locale locale, @Nullable Collection<? extends Authorization> authorizations, @Nullable Map<String, ? extends UserAttribute> attributes) {
        return this.userMocker.mockCurrentUser(userName, locale, authorizations, attributes);
    }

    @Override
    public void setCurrentUser(@Nullable String userName) {
        this.userMocker.setCurrentUser(userName);
    }

    @Override
    public void clearUsers() {
        this.userMocker.clearUsers();
    }

    @Override
    public void mockSecretStore(String name, SecretStore secretStore) {
        this.secretStoreMocker.mockSecretStore(name, secretStore);
    }

    @Override
    public void mockSecretStore(String name, String password) {
        this.secretStoreMocker.mockSecretStore(name, password);
    }

    @Override
    public void mockKeyStore(String name, SecretStore password, KeyStore keyStore) {
        this.secretStoreMocker.mockKeyStore(name, password, keyStore);
    }

    @Override
    public void mockKeyStore(String name, String password, KeyStore keyStore) {
        this.secretStoreMocker.mockKeyStore(name, password, keyStore);
    }

    @Override
    public void mockKeyStore(String name, SecretStore password, String keyStoreFileName, String keyStoreType) {
        this.secretStoreMocker.mockKeyStore(name, password, keyStoreFileName, keyStoreType);
    }

    @Override
    public void mockKeyStore(String name, String password, String keyStoreFileName, String keyStoreType) {
        this.secretStoreMocker.mockKeyStore(name, password, keyStoreFileName, keyStoreType);
    }

    @Override
    public void clearSecretStores() {
        this.secretStoreMocker.clearSecretStores();
    }

    @Override
    public void clearKeyStores() {
        this.secretStoreMocker.clearKeyStores();
    }

    @Override
    public Destination mockDestination(String name, String systemAlias) {
        return this.destinationMocker.mockDestination(name, systemAlias);
    }

    @Override
    public Destination mockDestination(String name, TestSystem<?> testSystem) {
        return this.destinationMocker.mockDestination(name, testSystem);
    }

    @Override
    public Destination mockDestination(String name, URI uri) {
        return this.destinationMocker.mockDestination(name, uri);
    }

    @Override
    public Destination mockDestination(String name, URI uri, @Nullable Credentials credentials) {
        return this.destinationMocker.mockDestination(name, uri, credentials);
    }

    @Override
    public Destination mockDestination(String name, URI uri, @Nullable Credentials credentials, @Nullable ProxyConfiguration proxyConfiguration) {
        return this.destinationMocker.mockDestination(name, uri, credentials, proxyConfiguration);
    }

    @Override
    public Destination mockDestination(String name, URI uri, @Nullable AuthenticationType authenticationType, @Nullable ProxyType proxyType, @Nullable ProxyConfiguration proxyConfiguration, @Nullable List<Header> headers, @Nullable KeyStore trustStore, @Nullable Boolean isTrustingAllCertificates, @Nullable KeyStore keyStore, @Nullable String keyStorePassword, @Nullable Map<String, String> propertiesByName) {
        return this.destinationMocker.mockDestination(name, uri, authenticationType, proxyType, proxyConfiguration, headers, trustStore, isTrustingAllCertificates, keyStore, keyStorePassword, propertiesByName);
    }

    @Override
    public Destination mockDestination(MockDestination destination) {
        return this.destinationMocker.mockDestination(destination);
    }

    @Override
    public void clearDestinations() {
        this.destinationMocker.clearDestinations();
    }

    @Override
    public Destination mockErpDestination() {
        return this.erpDestinationMocker.mockErpDestination();
    }

    @Override
    public Destination mockErpDestination(String systemAlias) {
        return this.erpDestinationMocker.mockErpDestination(systemAlias);
    }

    @Override
    public Destination mockErpDestination(@Nullable ErpSystem erpSystem) {
        return this.erpDestinationMocker.mockErpDestination(erpSystem);
    }

    @Override
    public Destination mockErpDestination(@Nullable ErpSystem erpSystem, @Nullable Credentials credentials) {
        return this.erpDestinationMocker.mockErpDestination(erpSystem, credentials);
    }

    @Override
    public Destination mockErpDestination(@Nullable String destinationName, String systemAlias) {
        return this.erpDestinationMocker.mockErpDestination(destinationName, systemAlias);
    }

    @Override
    public Destination mockErpDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem) {
        return this.erpDestinationMocker.mockErpDestination(destinationName, erpSystem);
    }

    @Override
    public Destination mockErpDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem, @Nullable Credentials credentials) {
        return this.erpDestinationMocker.mockErpDestination(destinationName, erpSystem, credentials);
    }

    @Override
    public Destination mockErpDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem, @Nullable Credentials credentials, @Nullable AuthenticationType authenticationType, @Nullable ProxyType proxyType, @Nullable ProxyConfiguration proxyConfiguration, @Nullable List<Header> headers, @Nullable KeyStore trustStore, @Nullable Boolean isTrustingAllCertificates, @Nullable KeyStore keyStore, @Nullable String keyStorePassword, @Nullable Map<String, String> propertiesByName) {
        return this.erpDestinationMocker.mockErpDestination(destinationName, erpSystem, credentials, authenticationType, proxyType, proxyConfiguration, headers, trustStore, isTrustingAllCertificates, keyStore, keyStorePassword, propertiesByName);
    }

    @Override
    public Destination mockErpDestination(MockErpDestination destination) {
        return this.erpDestinationMocker.mockErpDestination(destination);
    }

    public RequestContextExecutor requestContextExecutor() {
        return new RequestContextExecutor().withoutDefaultListeners().withListeners(new RequestContextListener[]{new DestinationsRequestContextListener(), new TenantRequestContextListener()});
    }

    @Override
    public RfcDestination mockRfcDestination() {
        return this.rfcDestinationMocker.mockRfcDestination();
    }

    @Override
    public RfcDestination mockRfcDestination(String systemAlias) {
        return this.rfcDestinationMocker.mockRfcDestination(systemAlias);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable ErpSystem erpSystem) {
        return this.rfcDestinationMocker.mockRfcDestination(erpSystem);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable ErpSystem erpSystem, @Nullable Credentials credentials) {
        return this.rfcDestinationMocker.mockRfcDestination(erpSystem, credentials);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable String destinationName, String systemAlias) {
        return this.rfcDestinationMocker.mockRfcDestination(destinationName, systemAlias);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem) {
        return this.rfcDestinationMocker.mockRfcDestination(destinationName, erpSystem);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem, @Nullable Credentials credentials) {
        return this.rfcDestinationMocker.mockRfcDestination(destinationName, erpSystem, credentials);
    }

    @Override
    public RfcDestination mockRfcDestination(@Nullable String destinationName, @Nullable ErpSystem erpSystem, @Nullable Credentials credentials, @Nullable Map<String, String> propertiesByName) {
        return this.rfcDestinationMocker.mockRfcDestination(destinationName, erpSystem, credentials, propertiesByName);
    }

    @Override
    public RfcDestination mockRfcDestination(MockRfcDestination destination) {
        return this.rfcDestinationMocker.mockRfcDestination(destination);
    }

    @Override
    public ClientAndServer mockServer(String destinationName, @Nullable String relativePath) {
        return this.serverMocker.mockServer(destinationName, relativePath);
    }

    @Override
    public ClientAndServer mockServer(String destinationName) {
        return this.serverMocker.mockServer(destinationName);
    }

    @Override
    public ClientAndServer mockErpServer(SapClient sapClient, @Nullable String relativePath) {
        return this.serverMocker.mockErpServer(sapClient, relativePath);
    }

    @Override
    public ClientAndServer mockErpServer(SapClient sapClient) {
        return this.serverMocker.mockErpServer(sapClient);
    }

    void mockSigningService() {
        this.mockSecretStore("trustcert", TRUSTCERT_MOCKED_PASSWORD);
        this.mockKeyStore("trustcert", TRUSTCERT_MOCKED_PASSWORD, TRUSTCERT_KEYSTORE_NAME, TRUSTCERT_KEYSTORE_TYPE);
        TrustSignatureKey.initialize();
        this.mockDestination(SigningServiceDestination.getDefaultName(), URI.create(""));
    }

    @Nullable
    ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    DefaultTestSystemsProvider getTestSystemsProvider() {
        return this.testSystemsProvider;
    }

    DefaultCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    DefaultDestinationMocker getDestinationMocker() {
        return this.destinationMocker;
    }
}

