/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.testutil.SecurityUtil;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;

public class MockDestination {
    @NonNull
    private final String name;
    @NonNull
    private final URI uri;
    @Nullable
    private AuthenticationType authenticationType;
    @Nullable
    private ProxyType proxyType;
    @Nullable
    private ProxyConfiguration proxyConfiguration;
    @Nullable
    private List<Header> headers;
    @Nullable
    private KeyStore trustStore;
    @Nullable
    private Boolean isTrustingAllCertificates;
    @Nullable
    private KeyStore keyStore;
    @Nullable
    private String keyStorePassword;
    @Nullable
    private Map<String, String> properties;

    public static MockDestinationBuilder builder() {
        return new MockDestinationBuilder();
    }

    public static MockDestinationBuilder builder(String name, URI uri) {
        return new MockDestinationBuilder().name(name).uri(uri);
    }

    private static AuthenticationType $default$authenticationType() {
        return null;
    }

    private static ProxyType $default$proxyType() {
        return null;
    }

    private static ProxyConfiguration $default$proxyConfiguration() {
        return null;
    }

    private static KeyStore $default$trustStore() {
        return null;
    }

    private static Boolean $default$isTrustingAllCertificates() {
        return null;
    }

    private static KeyStore $default$keyStore() {
        return null;
    }

    private static String $default$keyStorePassword() {
        return null;
    }

    @ConstructorProperties(value={"name", "uri", "authenticationType", "proxyType", "proxyConfiguration", "headers", "trustStore", "isTrustingAllCertificates", "keyStore", "keyStorePassword", "properties"})
    MockDestination(@NonNull String name, @NonNull URI uri, @Nullable AuthenticationType authenticationType, @Nullable ProxyType proxyType, @Nullable ProxyConfiguration proxyConfiguration, @Nullable List<Header> headers, @Nullable KeyStore trustStore, @Nullable Boolean isTrustingAllCertificates, @Nullable KeyStore keyStore, @Nullable String keyStorePassword, @Nullable Map<String, String> properties) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.name = name;
        this.uri = uri;
        this.authenticationType = authenticationType;
        this.proxyType = proxyType;
        this.proxyConfiguration = proxyConfiguration;
        this.headers = headers;
        this.trustStore = trustStore;
        this.isTrustingAllCertificates = isTrustingAllCertificates;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.properties = properties;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @Nullable
    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Nullable
    public ProxyType getProxyType() {
        return this.proxyType;
    }

    @Nullable
    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    @Nullable
    public List<Header> getHeaders() {
        return this.headers;
    }

    @Nullable
    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    @Nullable
    public Boolean getIsTrustingAllCertificates() {
        return this.isTrustingAllCertificates;
    }

    @Nullable
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Nullable
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setAuthenticationType(@Nullable AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public void setProxyType(@Nullable ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    public void setProxyConfiguration(@Nullable ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    public void setHeaders(@Nullable List<Header> headers) {
        this.headers = headers;
    }

    public void setTrustStore(@Nullable KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public void setIsTrustingAllCertificates(@Nullable Boolean isTrustingAllCertificates) {
        this.isTrustingAllCertificates = isTrustingAllCertificates;
    }

    public void setKeyStore(@Nullable KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePassword(@Nullable String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockDestination)) {
            return false;
        }
        MockDestination other = (MockDestination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        AuthenticationType this$authenticationType = this.getAuthenticationType();
        AuthenticationType other$authenticationType = other.getAuthenticationType();
        if (this$authenticationType == null ? other$authenticationType != null : !this$authenticationType.equals(other$authenticationType)) {
            return false;
        }
        ProxyType this$proxyType = this.getProxyType();
        ProxyType other$proxyType = other.getProxyType();
        if (this$proxyType == null ? other$proxyType != null : !this$proxyType.equals(other$proxyType)) {
            return false;
        }
        ProxyConfiguration this$proxyConfiguration = this.getProxyConfiguration();
        ProxyConfiguration other$proxyConfiguration = other.getProxyConfiguration();
        if (this$proxyConfiguration == null ? other$proxyConfiguration != null : !this$proxyConfiguration.equals(other$proxyConfiguration)) {
            return false;
        }
        List<Header> this$headers = this.getHeaders();
        List<Header> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        KeyStore this$trustStore = this.getTrustStore();
        KeyStore other$trustStore = other.getTrustStore();
        if (this$trustStore == null ? other$trustStore != null : !this$trustStore.equals(other$trustStore)) {
            return false;
        }
        Boolean this$isTrustingAllCertificates = this.getIsTrustingAllCertificates();
        Boolean other$isTrustingAllCertificates = other.getIsTrustingAllCertificates();
        if (this$isTrustingAllCertificates == null ? other$isTrustingAllCertificates != null : !((Object)this$isTrustingAllCertificates).equals(other$isTrustingAllCertificates)) {
            return false;
        }
        KeyStore this$keyStore = this.getKeyStore();
        KeyStore other$keyStore = other.getKeyStore();
        if (this$keyStore == null ? other$keyStore != null : !this$keyStore.equals(other$keyStore)) {
            return false;
        }
        String this$keyStorePassword = this.getKeyStorePassword();
        String other$keyStorePassword = other.getKeyStorePassword();
        if (this$keyStorePassword == null ? other$keyStorePassword != null : !this$keyStorePassword.equals(other$keyStorePassword)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MockDestination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        AuthenticationType $authenticationType = this.getAuthenticationType();
        result = result * 59 + ($authenticationType == null ? 43 : $authenticationType.hashCode());
        ProxyType $proxyType = this.getProxyType();
        result = result * 59 + ($proxyType == null ? 43 : $proxyType.hashCode());
        ProxyConfiguration $proxyConfiguration = this.getProxyConfiguration();
        result = result * 59 + ($proxyConfiguration == null ? 43 : $proxyConfiguration.hashCode());
        List<Header> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        KeyStore $trustStore = this.getTrustStore();
        result = result * 59 + ($trustStore == null ? 43 : $trustStore.hashCode());
        Boolean $isTrustingAllCertificates = this.getIsTrustingAllCertificates();
        result = result * 59 + ($isTrustingAllCertificates == null ? 43 : ((Object)$isTrustingAllCertificates).hashCode());
        KeyStore $keyStore = this.getKeyStore();
        result = result * 59 + ($keyStore == null ? 43 : $keyStore.hashCode());
        String $keyStorePassword = this.getKeyStorePassword();
        result = result * 59 + ($keyStorePassword == null ? 43 : $keyStorePassword.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "MockDestination(name=" + this.getName() + ", uri=" + this.getUri() + ", authenticationType=" + this.getAuthenticationType() + ", proxyType=" + this.getProxyType() + ", proxyConfiguration=" + this.getProxyConfiguration() + ", headers=" + this.getHeaders() + ", trustStore=" + this.getTrustStore() + ", isTrustingAllCertificates=" + this.getIsTrustingAllCertificates() + ", keyStore=" + this.getKeyStore() + ", keyStorePassword=" + this.getKeyStorePassword() + ", properties=" + this.getProperties() + ")";
    }

    public static class MockDestinationBuilder {
        private String name;
        private URI uri;
        private boolean authenticationType$set;
        private AuthenticationType authenticationType;
        private boolean proxyType$set;
        private ProxyType proxyType;
        private boolean proxyConfiguration$set;
        private ProxyConfiguration proxyConfiguration;
        private ArrayList<Header> headers;
        private boolean trustStore$set;
        private KeyStore trustStore;
        private boolean isTrustingAllCertificates$set;
        private Boolean isTrustingAllCertificates;
        private boolean keyStore$set;
        private KeyStore keyStore;
        private boolean keyStorePassword$set;
        private String keyStorePassword;
        private ArrayList<String> properties$key;
        private ArrayList<String> properties$value;

        public MockDestinationBuilder basicAuthentication(@NonNull BasicCredentials credentials) {
            if (credentials == null) {
                throw new NullPointerException("credentials");
            }
            this.authenticationType(AuthenticationType.BASIC_AUTHENTICATION);
            this.header(SecurityUtil.newBasicHeader(credentials));
            return this;
        }

        MockDestinationBuilder() {
        }

        public MockDestinationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MockDestinationBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public MockDestinationBuilder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            this.authenticationType$set = true;
            return this;
        }

        public MockDestinationBuilder proxyType(ProxyType proxyType) {
            this.proxyType = proxyType;
            this.proxyType$set = true;
            return this;
        }

        public MockDestinationBuilder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            this.proxyConfiguration$set = true;
            return this;
        }

        public MockDestinationBuilder header(Header header) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(header);
            return this;
        }

        public MockDestinationBuilder headers(Collection<? extends Header> headers) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.addAll(headers);
            return this;
        }

        public MockDestinationBuilder clearHeaders() {
            if (this.headers != null) {
                this.headers.clear();
            }
            return this;
        }

        public MockDestinationBuilder trustStore(KeyStore trustStore) {
            this.trustStore = trustStore;
            this.trustStore$set = true;
            return this;
        }

        public MockDestinationBuilder isTrustingAllCertificates(Boolean isTrustingAllCertificates) {
            this.isTrustingAllCertificates = isTrustingAllCertificates;
            this.isTrustingAllCertificates$set = true;
            return this;
        }

        public MockDestinationBuilder keyStore(KeyStore keyStore) {
            this.keyStore = keyStore;
            this.keyStore$set = true;
            return this;
        }

        public MockDestinationBuilder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            this.keyStorePassword$set = true;
            return this;
        }

        public MockDestinationBuilder property(String propertyKey, String propertyValue) {
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            this.properties$key.add(propertyKey);
            this.properties$value.add(propertyValue);
            return this;
        }

        public MockDestinationBuilder properties(Map<? extends String, ? extends String> properties) {
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : properties.entrySet()) {
                this.properties$key.add($lombokEntry.getKey());
                this.properties$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public MockDestinationBuilder clearProperties() {
            if (this.properties$key != null) {
                this.properties$key.clear();
                this.properties$value.clear();
            }
            return this;
        }

        public MockDestination build() {
            Map<Object, Object> properties;
            List<Header> headers;
            switch (this.headers == null ? 0 : this.headers.size()) {
                case 0: {
                    headers = Collections.emptyList();
                    break;
                }
                case 1: {
                    headers = Collections.singletonList(this.headers.get(0));
                    break;
                }
                default: {
                    headers = Collections.unmodifiableList(new ArrayList<Header>(this.headers));
                }
            }
            switch (this.properties$key == null ? 0 : this.properties$key.size()) {
                case 0: {
                    properties = Collections.emptyMap();
                    break;
                }
                case 1: {
                    properties = Collections.singletonMap(this.properties$key.get(0), this.properties$value.get(0));
                    break;
                }
                default: {
                    properties = new LinkedHashMap(this.properties$key.size() < 0x40000000 ? 1 + this.properties$key.size() + (this.properties$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.properties$key.size(); ++$i) {
                        properties.put(this.properties$key.get($i), this.properties$value.get($i));
                    }
                    properties = Collections.unmodifiableMap(properties);
                }
            }
            return new MockDestination(this.name, this.uri, this.authenticationType$set ? this.authenticationType : MockDestination.$default$authenticationType(), this.proxyType$set ? this.proxyType : MockDestination.$default$proxyType(), this.proxyConfiguration$set ? this.proxyConfiguration : MockDestination.$default$proxyConfiguration(), headers, this.trustStore$set ? this.trustStore : MockDestination.$default$trustStore(), this.isTrustingAllCertificates$set ? this.isTrustingAllCertificates : MockDestination.$default$isTrustingAllCertificates(), this.keyStore$set ? this.keyStore : MockDestination.$default$keyStore(), this.keyStorePassword$set ? this.keyStorePassword : MockDestination.$default$keyStorePassword(), properties);
        }

        public String toString() {
            return "MockDestination.MockDestinationBuilder(name=" + this.name + ", uri=" + this.uri + ", authenticationType=" + this.authenticationType + ", proxyType=" + this.proxyType + ", proxyConfiguration=" + this.proxyConfiguration + ", headers=" + this.headers + ", trustStore=" + this.trustStore + ", isTrustingAllCertificates=" + this.isTrustingAllCertificates + ", keyStore=" + this.keyStore + ", keyStorePassword=" + this.keyStorePassword + ", properties$key=" + this.properties$key + ", properties$value=" + this.properties$value + ")";
        }
    }
}

