/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.base.Optional;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEdition;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import com.sap.cloud.sdk.testutil.TestSystem;
import java.net.URI;
import java.util.Locale;
import javax.annotation.Nullable;
import lombok.NonNull;

public class ErpSystem
implements TestSystem<ErpSystem> {
    @NonNull
    private final String alias;
    @NonNull
    private final URI uri;
    @NonNull
    private final String systemId;
    @NonNull
    private final SapClient sapClient;
    @NonNull
    private final Locale locale;
    @NonNull
    private final ErpEdition erpEdition;
    @Nullable
    private final ProxyConfiguration proxyConfiguration;
    @NonNull
    private final String applicationServer;
    @NonNull
    private final String instanceNumber;

    public ErpSystem(URI uri, @Nullable String systemId, @Nullable SapClient sapClient) {
        this(systemId + "_" + sapClient, uri, systemId, sapClient);
    }

    public ErpSystem(String alias, URI uri, @Nullable String systemId, @Nullable SapClient sapClient) {
        this(alias, uri, systemId, sapClient, null, null, null, null, null);
    }

    public ErpSystem(String alias, URI uri, @Nullable String systemId, @Nullable SapClient sapClient, @Nullable ProxyConfiguration proxyConfiguration, @Nullable ErpEdition erpEdition) {
        this(alias, uri, systemId, sapClient, null, erpEdition, proxyConfiguration, null, null);
    }

    public ErpSystem(String alias, URI uri, @Nullable String systemId, @Nullable SapClient sapClient, @Nullable Locale locale, @Nullable ErpEdition erpEdition, @Nullable ProxyConfiguration proxyConfiguration, @Nullable String applicationServer, @Nullable String instanceNumber) {
        this.alias = alias;
        this.uri = uri;
        this.systemId = systemId != null ? systemId : "";
        this.sapClient = sapClient != null ? sapClient : SapClient.DEFAULT;
        this.locale = locale != null ? locale : Locale.US;
        this.erpEdition = erpEdition != null ? erpEdition : ErpEdition.CLOUD;
        this.proxyConfiguration = proxyConfiguration;
        this.applicationServer = applicationServer != null ? applicationServer : uri.getHost();
        this.instanceNumber = instanceNumber != null ? instanceNumber : "00";
    }

    @Override
    public Class<ErpSystem> getType() {
        return ErpSystem.class;
    }

    @Override
    public Optional<ProxyConfiguration> getProxyConfiguration() {
        return Optional.fromNullable((Object)this.proxyConfiguration);
    }

    public static ErpSystemBuilder builder() {
        return new ErpSystemBuilder();
    }

    public static ErpSystemBuilder builder(String alias, URI uri) {
        return new ErpSystemBuilder().alias(alias).uri(uri);
    }

    @Override
    @NonNull
    public String getAlias() {
        return this.alias;
    }

    @Override
    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public String getSystemId() {
        return this.systemId;
    }

    @NonNull
    public SapClient getSapClient() {
        return this.sapClient;
    }

    @NonNull
    public Locale getLocale() {
        return this.locale;
    }

    @NonNull
    public ErpEdition getErpEdition() {
        return this.erpEdition;
    }

    @NonNull
    public String getApplicationServer() {
        return this.applicationServer;
    }

    @NonNull
    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErpSystem)) {
            return false;
        }
        ErpSystem other = (ErpSystem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        String this$systemId = this.getSystemId();
        String other$systemId = other.getSystemId();
        if (this$systemId == null ? other$systemId != null : !this$systemId.equals(other$systemId)) {
            return false;
        }
        SapClient this$sapClient = this.getSapClient();
        SapClient other$sapClient = other.getSapClient();
        if (this$sapClient == null ? other$sapClient != null : !this$sapClient.equals(other$sapClient)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        ErpEdition this$erpEdition = this.getErpEdition();
        ErpEdition other$erpEdition = other.getErpEdition();
        if (this$erpEdition == null ? other$erpEdition != null : !this$erpEdition.equals(other$erpEdition)) {
            return false;
        }
        Optional<ProxyConfiguration> this$proxyConfiguration = this.getProxyConfiguration();
        Optional<ProxyConfiguration> other$proxyConfiguration = other.getProxyConfiguration();
        if (this$proxyConfiguration == null ? other$proxyConfiguration != null : !this$proxyConfiguration.equals(other$proxyConfiguration)) {
            return false;
        }
        String this$applicationServer = this.getApplicationServer();
        String other$applicationServer = other.getApplicationServer();
        if (this$applicationServer == null ? other$applicationServer != null : !this$applicationServer.equals(other$applicationServer)) {
            return false;
        }
        String this$instanceNumber = this.getInstanceNumber();
        String other$instanceNumber = other.getInstanceNumber();
        return !(this$instanceNumber == null ? other$instanceNumber != null : !this$instanceNumber.equals(other$instanceNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErpSystem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        String $systemId = this.getSystemId();
        result = result * 59 + ($systemId == null ? 43 : $systemId.hashCode());
        SapClient $sapClient = this.getSapClient();
        result = result * 59 + ($sapClient == null ? 43 : $sapClient.hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        ErpEdition $erpEdition = this.getErpEdition();
        result = result * 59 + ($erpEdition == null ? 43 : $erpEdition.hashCode());
        Optional<ProxyConfiguration> $proxyConfiguration = this.getProxyConfiguration();
        result = result * 59 + ($proxyConfiguration == null ? 43 : $proxyConfiguration.hashCode());
        String $applicationServer = this.getApplicationServer();
        result = result * 59 + ($applicationServer == null ? 43 : $applicationServer.hashCode());
        String $instanceNumber = this.getInstanceNumber();
        result = result * 59 + ($instanceNumber == null ? 43 : $instanceNumber.hashCode());
        return result;
    }

    public String toString() {
        return "ErpSystem(alias=" + this.getAlias() + ", uri=" + this.getUri() + ", systemId=" + this.getSystemId() + ", sapClient=" + this.getSapClient() + ", locale=" + this.getLocale() + ", erpEdition=" + this.getErpEdition() + ", proxyConfiguration=" + this.getProxyConfiguration() + ", applicationServer=" + this.getApplicationServer() + ", instanceNumber=" + this.getInstanceNumber() + ")";
    }

    public static class ErpSystemBuilder {
        private String alias;
        private URI uri;
        private String systemId;
        private SapClient sapClient;
        private Locale locale;
        private ErpEdition erpEdition;
        private ProxyConfiguration proxyConfiguration;
        private String applicationServer;
        private String instanceNumber;

        ErpSystemBuilder() {
        }

        public ErpSystemBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ErpSystemBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public ErpSystemBuilder systemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        public ErpSystemBuilder sapClient(SapClient sapClient) {
            this.sapClient = sapClient;
            return this;
        }

        public ErpSystemBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public ErpSystemBuilder erpEdition(ErpEdition erpEdition) {
            this.erpEdition = erpEdition;
            return this;
        }

        public ErpSystemBuilder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public ErpSystemBuilder applicationServer(String applicationServer) {
            this.applicationServer = applicationServer;
            return this;
        }

        public ErpSystemBuilder instanceNumber(String instanceNumber) {
            this.instanceNumber = instanceNumber;
            return this;
        }

        public ErpSystem build() {
            return new ErpSystem(this.alias, this.uri, this.systemId, this.sapClient, this.locale, this.erpEdition, this.proxyConfiguration, this.applicationServer, this.instanceNumber);
        }

        public String toString() {
            return "ErpSystem.ErpSystemBuilder(alias=" + this.alias + ", uri=" + this.uri + ", systemId=" + this.systemId + ", sapClient=" + this.sapClient + ", locale=" + this.locale + ", erpEdition=" + this.erpEdition + ", proxyConfiguration=" + this.proxyConfiguration + ", applicationServer=" + this.applicationServer + ", instanceNumber=" + this.instanceNumber + ")";
        }
    }
}

