/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAttribute;
import com.sap.cloud.sdk.testutil.MockUtil;
import com.sap.cloud.sdk.testutil.TestConfigurationError;
import com.sap.cloud.sdk.testutil.UserMocker;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.assertj.core.util.Sets;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DefaultUserMocker
implements UserMocker {
    private final MockUtil mockUtil;
    private final Map<String, User> users = Maps.newHashMap();
    @Nullable
    private User currentUser;

    @Override
    public User mockUser(String userName) {
        return this.mockUser(userName, null, null, null);
    }

    @Override
    public User mockUser(String userName, @Nullable Locale locale, @Nullable Collection<? extends Authorization> authorizations, @Nullable Map<String, ? extends UserAttribute> attributes) {
        this.mockUtil.resetUserFacade();
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getName()).thenReturn((Object)userName);
        Mockito.when((Object)user.getLocale()).thenReturn((Object)Optional.fromNullable((Object)locale));
        if (authorizations != null) {
            Mockito.when((Object)user.getAuthorizations()).thenReturn((Object)Sets.newHashSet(authorizations));
            Mockito.when((Object)user.hasAuthorization((Authorization)ArgumentMatchers.any(Authorization.class))).thenAnswer((Answer)new HasAuthorizationMockitoAnswer(authorizations));
        } else {
            Mockito.when((Object)user.getAuthorizations()).thenReturn(Collections.emptySet());
            Mockito.when((Object)user.hasAuthorization((Authorization)ArgumentMatchers.any(Authorization.class))).thenReturn((Object)false);
        }
        if (attributes != null) {
            Mockito.when((Object)user.getAttribute(ArgumentMatchers.anyString())).thenAnswer((Answer)new GetAttributeMockitoAnswer(attributes));
        } else {
            Mockito.when((Object)user.getAttribute(ArgumentMatchers.anyString())).thenReturn((Object)Optional.absent());
        }
        this.users.put(userName, user);
        return user;
    }

    @Override
    public User mockCurrentUser() {
        return this.mockCurrentUser("MockedUser");
    }

    @Override
    public User mockCurrentUser(String userName) {
        return this.mockCurrentUser(userName, null, null, null);
    }

    @Override
    public User mockCurrentUser(String userName, @Nullable Locale locale, @Nullable Collection<? extends Authorization> authorizations, @Nullable Map<String, ? extends UserAttribute> attributes) {
        User user;
        this.currentUser = user = this.mockUser(userName, locale, authorizations, attributes);
        return user;
    }

    @Override
    public void setCurrentUser(@Nullable String userName) {
        if (userName == null) {
            this.currentUser = null;
        } else {
            User user = this.users.get(userName);
            if (user == null) {
                throw new TestConfigurationError("No user mocked with name " + userName + ". Make sure to mock the respective user before calling this method.");
            }
            this.currentUser = user;
        }
    }

    @Override
    public void clearUsers() {
        this.mockUtil.resetUserFacade();
        this.currentUser = null;
        this.users.clear();
    }

    @ConstructorProperties(value={"mockUtil"})
    public DefaultUserMocker(MockUtil mockUtil) {
        this.mockUtil = mockUtil;
    }

    Map<String, User> getUsers() {
        return this.users;
    }

    @Nullable
    User getCurrentUser() {
        return this.currentUser;
    }

    private static class GetAttributeMockitoAnswer
    implements Answer<Optional<? extends UserAttribute>> {
        private final Map<String, ? extends UserAttribute> attributes;

        public Optional<? extends UserAttribute> answer(InvocationOnMock invocation) throws Throwable {
            String name = (String)invocation.getArgument(0);
            return this.attributes.containsKey(name) ? Optional.of((Object)this.attributes.get(name)) : Optional.absent();
        }

        @ConstructorProperties(value={"attributes"})
        public GetAttributeMockitoAnswer(Map<String, ? extends UserAttribute> attributes) {
            this.attributes = attributes;
        }
    }

    private static class HasAuthorizationMockitoAnswer
    implements Answer<Boolean> {
        private final Collection<? extends Authorization> authorizations;

        public Boolean answer(InvocationOnMock invocation) throws Throwable {
            Authorization authorization = (Authorization)invocation.getArgument(0);
            return this.authorizations.contains(authorization);
        }

        @ConstructorProperties(value={"authorizations"})
        public HasAuthorizationMockitoAnswer(Collection<? extends Authorization> authorizations) {
            this.authorizations = authorizations;
        }
    }
}

