/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.testutil;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEdition;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import com.sap.cloud.sdk.testutil.ConfigFileUtil;
import com.sap.cloud.sdk.testutil.ErpSystem;
import com.sap.cloud.sdk.testutil.GenericSystem;
import com.sap.cloud.sdk.testutil.SerializedErpSystem;
import com.sap.cloud.sdk.testutil.SerializedErpSystems;
import com.sap.cloud.sdk.testutil.SerializedTestSystem;
import com.sap.cloud.sdk.testutil.SerializedTestSystems;
import com.sap.cloud.sdk.testutil.TestConfigurationError;
import com.sap.cloud.sdk.testutil.TestSystem;
import com.sap.cloud.sdk.testutil.TestSystemsProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

class DefaultTestSystemsProvider
implements TestSystemsProvider {
    private final Map<String, TestSystem<?>> testSystems = Maps.newHashMap();
    @Nullable
    private String erpAlias = null;

    @Override
    public void loadTestSystems(@NonNull String resourceFileName) {
        if (resourceFileName == null) {
            throw new NullPointerException("resourceFileName");
        }
        this.loadTestSystems(ConfigFileUtil.getResourceFile(resourceFileName));
    }

    @Override
    public void loadTestSystems(@Nullable File file) {
        if (file != null) {
            try {
                this.parseTestSystems(Files.toString((File)file, (Charset)Charset.defaultCharset()));
            }
            catch (IOException e) {
                throw new TestConfigurationError(e);
            }
        }
    }

    @Override
    public void addTestSystem(@NonNull TestSystem<?> testSystem) {
        if (testSystem == null) {
            throw new NullPointerException("testSystem");
        }
        this.testSystems.put(testSystem.getAlias(), testSystem);
    }

    @Override
    public void removeTestSystem(@NonNull TestSystem<?> testSystem) {
        if (testSystem == null) {
            throw new NullPointerException("testSystem");
        }
        this.removeTestSystem(testSystem.getAlias());
    }

    @Override
    public void removeTestSystem(@NonNull String systemAlias) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        this.testSystems.remove(systemAlias);
    }

    @Override
    public TestSystem<?> getTestSystem(@NonNull String systemAlias) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        TestSystem<?> testSystem = this.testSystems.get(systemAlias);
        if (testSystem == null) {
            StringBuilder knownAliases = new StringBuilder();
            Iterator<String> it = this.testSystems.keySet().iterator();
            while (it.hasNext()) {
                String alias = it.next();
                knownAliases.append("\"").append(alias).append("\"");
                if (!it.hasNext()) continue;
                knownAliases.append(", ");
            }
            throw new TestConfigurationError("Cannot find " + TestSystem.class.getSimpleName() + " with alias \"" + systemAlias + "\". Known aliases: " + knownAliases + ". Make sure to define the alias in either the Java system property \"" + "test.systems" + "\" or in " + ConfigFileUtil.buildMissingResourceFileMessage("systems") + ": \n\n" + this.getTestSystemsExampleYaml() + "\n\n" + this.getTestSystemsExampleJson());
        }
        return testSystem;
    }

    @Override
    public void addDefaultErpSystem(@NonNull ErpSystem erpSystem) {
        if (erpSystem == null) {
            throw new NullPointerException("erpSystem");
        }
        this.addTestSystem(erpSystem);
        this.erpAlias = erpSystem.getAlias();
    }

    @Override
    public ErpSystem getErpSystem() {
        return this.getErpSystem(this.getErpAlias());
    }

    @Override
    public ErpSystem getErpSystem(@NonNull String systemAlias) {
        if (systemAlias == null) {
            throw new NullPointerException("systemAlias");
        }
        TestSystem<?> testSystem = this.getTestSystem(systemAlias);
        if (!(testSystem instanceof ErpSystem)) {
            throw new TestConfigurationError(TestSystem.class.getSimpleName() + " with alias \"" + systemAlias + "\" is not of type " + ErpSystem.class.getSimpleName() + ".");
        }
        return (ErpSystem)testSystem;
    }

    @Override
    public void clearTestSystems() {
        this.testSystems.clear();
    }

    void readErpAliasProperty() {
        String alias = System.getProperty("erp");
        if (alias != null) {
            this.erpAlias = alias;
        }
    }

    void loadTestSystems() {
        String property = System.getProperty("test.systems");
        if (StringUtils.isNotBlank((CharSequence)property)) {
            File file = ConfigFileUtil.getUniqueFileForExtensions(new File(property));
            if (file != null && file.exists()) {
                this.loadTestSystems(file);
            } else if (property.trim().startsWith("{") || property.trim().startsWith("---")) {
                this.parseTestSystems(property);
            } else {
                ConfigFileUtil.throwFailedToParseProperty("test.systems", property);
            }
        } else {
            this.loadTestSystems(ConfigFileUtil.getUniqueResourceFileForExtensions("systems"));
        }
    }

    private void parseTestSystems(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        try {
            SerializedErpSystems erpSystems;
            SerializedTestSystems serializedTestSystems = (SerializedTestSystems)ConfigFileUtil.newObjectMapper(str).readValue(str, SerializedTestSystems.class);
            List<SerializedTestSystem> genericSystems = serializedTestSystems.getSystems();
            if (genericSystems != null) {
                for (SerializedTestSystem genericSystem : genericSystems) {
                    this.addTestSystem(new GenericSystem(genericSystem.getAlias(), genericSystem.getUri(), this.parseProxyConfiguration(genericSystem.getProxyUri())));
                }
            }
            if ((erpSystems = serializedTestSystems.getErpSystems()) != null) {
                this.erpAlias = erpSystems.getDefaultAlias();
                List<SerializedErpSystem> systems = erpSystems.getSystems();
                if (systems != null) {
                    for (SerializedErpSystem system : systems) {
                        String erpEditionName = system.getErpEdition();
                        ErpSystem erpSystem = ErpSystem.builder().alias(system.getAlias()).uri(system.getUri()).systemId(system.getSystemId()).sapClient(SapClient.of((String)system.getSapClient())).proxyConfiguration(this.parseProxyConfiguration(system.getProxyUri())).erpEdition(this.parseErpEdition(erpEditionName)).locale(this.parseLocale(system.getLocale())).applicationServer(system.getApplicationServer()).instanceNumber(system.getInstanceNumber()).build();
                        this.addTestSystem(erpSystem);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new TestConfigurationError(e);
        }
    }

    @Nullable
    private ProxyConfiguration parseProxyConfiguration(@Nullable URI proxyUri) {
        return proxyUri != null ? new ProxyConfiguration(proxyUri) : null;
    }

    @Nullable
    private Locale parseLocale(@Nullable String language) {
        return language != null ? new Locale(language) : null;
    }

    @Nullable
    private ErpEdition parseErpEdition(@Nullable String erpEditionName) {
        if (StringUtils.isBlank((CharSequence)erpEditionName)) {
            return null;
        }
        if (ErpEdition.ON_PREMISE.name().equalsIgnoreCase(erpEditionName) || "onpremise".equalsIgnoreCase(erpEditionName) || "on_premise".equalsIgnoreCase(erpEditionName) || "on-premise".equalsIgnoreCase(erpEditionName)) {
            return ErpEdition.ON_PREMISE;
        }
        return ErpEdition.CLOUD;
    }

    private String getErpAlias() {
        if (this.erpAlias == null) {
            throw new TestConfigurationError("No default ERP system alias defined. Make sure to set the default alias in either the Java system property \"test.systems\" or in " + ConfigFileUtil.buildMissingResourceFileMessage("systems") + ": \n\n" + this.getTestSystemsExampleYaml() + "\n\n" + this.getTestSystemsExampleJson());
        }
        return this.erpAlias;
    }

    private String getTestSystemsExampleYaml() {
        return "Example (YAML, recommended for hand-written files):\n---\nsystems:\n  - alias: \"ANY_SYSTEM\"\n    uri: \"https://any-system.com\"\n    proxy: \"http://my-proxy:8080\"\n\nerp:\n  default: \"ERP_001\"\n  systems:\n    - alias: \"ERP_001\"\n      uri: \"https://my-erp.com\"\n      systemId: \"ERP\"                  # optional, defaults to \"\"\n      sapClient: \"001\"                 # optional, defaults to default SAP client\n      locale: \"en\"                     # optional, defaults to English (US)\n      erpEdition: \"cloud\"              # optional, defaults to \"cloud\"\n      proxy: \"http://my-proxy:8080\"    # optional\n      applicationServer: \"my-erp.com\"  # optional, defaults to URI host\n      instanceNumber: \"00\"             # optional, defaults to \"00\"\n";
    }

    private String getTestSystemsExampleJson() {
        return "Example (JSON, recommended for generated files):\n{\n  \"systems\": [\n    {\n      \"alias\": \"ANY_SYSTEM\",\n      \"uri\": \"https://any-system.com\",\n      \"proxy\": \"http://my-proxy:8080\"\n    }\n  ],\n  \"erp\": {\n    \"default\": \"ERP_001\",\n    \"systems\": [\n      {\n        \"alias\": \"ERP_001\",\n        \"uri\": \"https://my-erp.com\",\n        \"systemId\": \"ERP\",\n        \"sapClient\": \"001\",\n        \"locale\": \"en\",\n        \"erpEdition\": \"cloud\",\n        \"proxy\": \"http://my-proxy:8080\",\n        \"applicationServer\": \"my-erp.com\",\n        \"instanceNumber\": \"00\"\n      }\n    ]\n  }\n}\n";
    }
}

